/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.idl;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarEncodedArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLong64ArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStateArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULong64ArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.Any;
import org.tango.attribute.AttributeTangoType;
import org.tango.orb.ORBManager;
import org.tango.utils.ArrayUtils;
import org.tango.utils.DevFailedUtils;

public final class CleverAnyAttribute {
    private static final Map<Integer, Class<?>> CLASS_MAP = new HashMap();
    private static final Map<Integer, Class<?>> PARAM_MAP;

    private CleverAnyAttribute() {
    }

    public static Object get(Any any, int tangoType, AttrDataFormat format) throws DevFailed {
        Object result = null;
        if (any != null) {
            try {
                Class<?> extractorClass = CLASS_MAP.get(tangoType);
                Method method = extractorClass.getMethod("extract", Any.class);
                result = method.invoke(null, any);
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (IllegalAccessException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (InvocationTargetException e) {
                throw DevFailedUtils.newDevFailed(e.getCause());
            }
            catch (SecurityException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (NoSuchMethodException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            if (format.equals(AttrDataFormat.SCALAR)) {
                result = Array.get(result, 0);
            }
        }
        return result;
    }

    public static Any set(int tangoType, Object value) throws DevFailed {
        Any any = ORBManager.createAny();
        if (value != null) {
            Object array = null;
            if (value.getClass().isArray()) {
                array = ArrayUtils.toPrimitiveArray(value);
            } else {
                array = Array.newInstance(AttributeTangoType.getTypeFromTango(tangoType).getType(), 1);
                Array.set(array, 0, value);
            }
            Method method = null;
            try {
                Class<?> inserterClass = CLASS_MAP.get(tangoType);
                method = inserterClass.getMethod("insert", Any.class, PARAM_MAP.get(tangoType));
                method.invoke(null, any, array);
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed("API_AttrOptProp", value.getClass().getCanonicalName() + " is not of the good type, should be " + method);
            }
            catch (IllegalAccessException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (InvocationTargetException e) {
                throw DevFailedUtils.newDevFailed(e.getCause());
            }
            catch (SecurityException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (NoSuchMethodException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
        }
        return any;
    }

    static {
        CLASS_MAP.put(1, DevVarBooleanArrayHelper.class);
        CLASS_MAP.put(2, DevVarShortArrayHelper.class);
        CLASS_MAP.put(6, DevVarUShortArrayHelper.class);
        CLASS_MAP.put(3, DevVarLongArrayHelper.class);
        CLASS_MAP.put(7, DevVarULongArrayHelper.class);
        CLASS_MAP.put(23, DevVarLong64ArrayHelper.class);
        CLASS_MAP.put(24, DevVarULong64ArrayHelper.class);
        CLASS_MAP.put(4, DevVarFloatArrayHelper.class);
        CLASS_MAP.put(5, DevVarDoubleArrayHelper.class);
        CLASS_MAP.put(8, DevVarStringArrayHelper.class);
        CLASS_MAP.put(19, DevVarStateArrayHelper.class);
        CLASS_MAP.put(22, DevVarCharArrayHelper.class);
        CLASS_MAP.put(28, DevVarEncodedArrayHelper.class);
        PARAM_MAP = new HashMap();
        PARAM_MAP.put(1, boolean[].class);
        PARAM_MAP.put(2, short[].class);
        PARAM_MAP.put(6, short[].class);
        PARAM_MAP.put(3, int[].class);
        PARAM_MAP.put(7, int[].class);
        PARAM_MAP.put(23, long[].class);
        PARAM_MAP.put(24, long[].class);
        PARAM_MAP.put(4, float[].class);
        PARAM_MAP.put(5, double[].class);
        PARAM_MAP.put(8, String[].class);
        PARAM_MAP.put(19, DevState[].class);
        PARAM_MAP.put(22, byte[].class);
        PARAM_MAP.put(28, DevEncoded[].class);
    }
}

