/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.history;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.LockerLanguage;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Queue;
import org.apache.commons.lang3.ArrayUtils;
import org.omg.CORBA.BAD_OPERATION;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.orb.ServerRequestInterceptor;
import org.tango.utils.DevFailedUtils;

public final class DeviceBlackBox {
    private final Logger logger = LoggerFactory.getLogger(DeviceBlackBox.class);
    private final Logger clientRequestsLogger = LoggerFactory.getLogger("TangoClientRequests");
    private final Queue<String> blackbox = new ArrayDeque<String>(100);

    public String[] toArray(int size) throws DevFailed {
        Object[] result;
        if (this.blackbox.size() == 0) {
            throw DevFailedUtils.newDevFailed("API_BlackBoxEmpty", "blackbox is emty");
        }
        Object[] blackboxArray = this.blackbox.toArray(new String[0]);
        if (size < 100 && size < this.blackbox.size()) {
            result = new String[size];
            System.arraycopy(blackboxArray, blackboxArray.length - size, result, 0, result.length);
        } else {
            result = blackboxArray;
        }
        ArrayUtils.reverse(result);
        return result;
    }

    public void insertInblackBox(String message) {
        this.offerInblackBox(message + this.insertHostName());
    }

    private synchronized void offerInblackBox(String message) {
        while (this.blackbox.size() >= 99) {
            this.blackbox.poll();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
        StringBuilder sb = new StringBuilder(dateFormat.format(new Date()));
        sb.append(" : ").append(message);
        this.clientRequestsLogger.debug(message);
        boolean isInserted = this.blackbox.offer(sb.toString());
        if (!isInserted) {
            this.logger.debug("{} not inserted in black box queue ", (Object)sb);
        }
    }

    public void insertInblackBox(String message, DevSource devSource) {
        StringBuilder sb = this.insertSource(message, devSource);
        this.offerInblackBox(sb.toString());
    }

    public void insertInblackBox(String message, DevSource devSource, ClntIdent clt) {
        StringBuilder sb = this.insertSource(message, devSource);
        String cli = "";
        try {
            cli = clt.discriminator() == LockerLanguage.CPP ? "(CPP/Python client with PID " + Integer.valueOf(clt.cpp_clnt()).toString() + ")" : "(Java client with main class " + clt.java_clnt().MainClass + ")";
        }
        catch (BAD_OPERATION e) {
            this.logger.debug("{}", e);
        }
        sb.append((CharSequence)this.insertHostName()).append(" ").append(cli);
        this.offerInblackBox(sb.toString());
    }

    private StringBuilder insertHostName() {
        StringBuilder sb = new StringBuilder();
        sb.append(" requested from ").append(ServerRequestInterceptor.getInstance().getClientHostName());
        return sb;
    }

    private StringBuilder insertSource(String message, DevSource devSource) {
        StringBuilder sb = new StringBuilder(message);
        sb.append(" from ").append(devSource.toString());
        return sb;
    }

    public void insertInblackBox(String message, ClntIdent clt) {
        String cli = "";
        try {
            cli = clt.discriminator() == LockerLanguage.CPP ? Integer.valueOf(clt.cpp_clnt()).toString() : clt.java_clnt().MainClass;
        }
        catch (BAD_OPERATION e) {
            this.logger.debug("{}", e);
        }
        this.offerInblackBox(message + " from  \"" + cli + "\"");
    }
}

