/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.export;

import fr.esrf.Tango.DevFailed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.server.admin.AdminDevice;
import org.tango.server.build.DeviceClassBuilder;
import org.tango.server.cache.TangoCacheManager;
import org.tango.server.export.IExporter;
import org.tango.server.properties.PropertiesUtils;
import org.tango.server.servant.DeviceImpl;
import org.tango.server.servant.ORBUtils;
import org.tango.utils.DevFailedUtils;

public final class TangoExporter
implements IExporter {
    private final Logger logger = LoggerFactory.getLogger(TangoExporter.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(TangoExporter.class);
    private final String hostName;
    private final String serverName;
    private final String pid;
    private final Map<String, Class<?>> tangoClasses;
    private final List<DeviceClassBuilder> deviceClassList = new ArrayList<DeviceClassBuilder>();

    public TangoExporter(String hostName, String serverName, String pid, Map<String, Class<?>> tangoClasses) {
        this.hostName = hostName;
        this.serverName = serverName;
        this.pid = pid;
        this.tangoClasses = new LinkedHashMap(tangoClasses);
    }

    @Override
    public void exportAll() throws DevFailed {
        DatabaseFactory.getDatabase().loadCache(this.serverName, this.hostName);
        DeviceClassBuilder clazz = new DeviceClassBuilder(AdminDevice.class, "DServer");
        this.deviceClassList.add(clazz);
        DeviceImpl dev = this.buildDevice("dserver/" + this.serverName, clazz);
        ((AdminDevice)dev.getBusinessObject()).setTangoExporter(this);
        ((AdminDevice)dev.getBusinessObject()).setClassList(this.deviceClassList);
        this.exportDevices();
        TangoCacheManager.initPoolConf();
        DatabaseFactory.getDatabase().clearCache();
    }

    @Override
    public void exportDevices() throws DevFailed {
        for (Map.Entry<String, Class<?>> entry : this.tangoClasses.entrySet()) {
            String tangoClass = entry.getKey();
            Class<?> deviceClass = entry.getValue();
            this.logger.debug("loading class {}", (Object)deviceClass.getCanonicalName());
            DeviceClassBuilder deviceClassBuilder = new DeviceClassBuilder(deviceClass, tangoClass);
            this.deviceClassList.add(deviceClassBuilder);
            Object[] deviceList = DatabaseFactory.getDatabase().getDeviceList(this.serverName, tangoClass);
            this.logger.debug("devices found  {}", (Object)Arrays.toString(deviceList));
            for (Object deviceName : deviceList) {
                this.buildDevice((String)deviceName, deviceClassBuilder);
            }
        }
    }

    @Override
    public void unexportDevices() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        ArrayList<DeviceClassBuilder> clazzToRemove = new ArrayList<DeviceClassBuilder>();
        for (DeviceClassBuilder clazz : this.deviceClassList) {
            if (clazz.getDeviceClass().equals(AdminDevice.class)) continue;
            for (DeviceImpl device : clazz.getDeviceImplList()) {
                this.logger.debug("unexport device {}", (Object)device.getName());
                ORBUtils.unexportDevice(device);
            }
            clazz.clearDevices();
            clazzToRemove.add(clazz);
        }
        for (DeviceClassBuilder deviceClassBuilder : clazzToRemove) {
            this.deviceClassList.remove(deviceClassBuilder);
        }
        this.xlogger.exit();
    }

    @Override
    public void unexportDevice(String deviceName) throws DevFailed {
        block0: for (DeviceClassBuilder clazz : this.deviceClassList) {
            if (clazz.getDeviceClass().equals(AdminDevice.class)) continue;
            for (DeviceImpl device : clazz.getDeviceImplList()) {
                if (!deviceName.equalsIgnoreCase(device.getName())) continue;
                this.logger.debug("unexport device {}", (Object)device.getName());
                ORBUtils.unexportDevice(device);
                clazz.removeDevice(deviceName);
                continue block0;
            }
        }
    }

    @Override
    public void unexportAll() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (DeviceClassBuilder clazz : this.deviceClassList) {
            for (DeviceImpl device : clazz.getDeviceImplList()) {
                this.logger.debug("unexport device {}", (Object)device.getName());
                device.unLock(true);
                try {
                    ORBUtils.unexportDevice(device);
                }
                catch (DevFailed devFailed) {}
            }
            clazz.clearDevices();
        }
        this.unregisterServer();
        this.deviceClassList.clear();
        PropertiesUtils.clearCache();
        this.xlogger.exit();
    }

    private void unregisterServer() {
        this.xlogger.entry(new Object[0]);
        if (this.serverName != null) {
            try {
                this.logger.debug("unexporting server {}", (Object)this.serverName);
                DatabaseFactory.getDatabase().unexportServer(this.serverName);
            }
            catch (DevFailed e) {
                this.logger.debug(DevFailedUtils.toString(e));
            }
        }
        this.xlogger.exit();
    }

    @Override
    public DeviceImpl buildDevice(String deviceName, Class<?> clazz) throws DevFailed {
        DeviceClassBuilder builder = null;
        for (DeviceClassBuilder classBuilder : this.deviceClassList) {
            if (!classBuilder.getDeviceClass().equals(clazz)) continue;
            builder = classBuilder;
            break;
        }
        if (builder == null) {
            throw DevFailedUtils.newDevFailed("class not found");
        }
        return this.buildDevice(deviceName, builder);
    }

    @Override
    public DeviceImpl buildDevice(String name, DeviceClassBuilder classBuilder) throws DevFailed {
        DeviceImpl devToClean = classBuilder.getDeviceImpl(name);
        if (devToClean != null) {
            this.logger.debug("unexporting device {}", (Object)devToClean.getName());
            ORBUtils.unexportDevice(devToClean);
        }
        DeviceImpl dev = classBuilder.buildDevice(name);
        this.logger.debug("exporting device {}", (Object)dev.getName());
        ORBUtils.exportDevice(dev, this.hostName, this.pid);
        return dev;
    }

    @Override
    public DeviceImpl getDevice(String className, String deviceName) throws DevFailed {
        if (!className.equalsIgnoreCase("DServer") && !this.tangoClasses.containsKey(className)) {
            throw DevFailedUtils.newDevFailed("API_ClassNotFound", className + " does not exists on this server");
        }
        DeviceImpl device = null;
        for (DeviceClassBuilder classBuilder : this.deviceClassList) {
            if (!className.equalsIgnoreCase(classBuilder.getClassName())) continue;
            device = classBuilder.getDeviceImpl(deviceName);
            break;
        }
        if (device == null) {
            throw DevFailedUtils.newDevFailed("API_DeviceNotFound", deviceName + " does not exists on this server");
        }
        return device;
    }

    public String[] getDevicesOfClass(String tangoClass) throws DevFailed {
        if (!this.tangoClasses.containsKey(tangoClass)) {
            throw DevFailedUtils.newDevFailed("API_ClassNotFound", tangoClass + " does not exists on this server");
        }
        String[] deviceNames = new String[]{};
        for (DeviceClassBuilder classBuilder : this.deviceClassList) {
            if (!tangoClass.equalsIgnoreCase(classBuilder.getClassName())) continue;
            List<String> list = classBuilder.getDeviceNameList();
            deviceNames = list.toArray(new String[0]);
            break;
        }
        return deviceNames;
    }

    public List<DeviceClassBuilder> getDeviceClassList() {
        return new ArrayList<DeviceClassBuilder>(this.deviceClassList);
    }

    public void clearClass() {
        this.tangoClasses.clear();
    }
}

