/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.AttDataReadyHelper;
import fr.esrf.Tango.AttributeConfig_3;
import fr.esrf.Tango.AttributeConfig_3Helper;
import fr.esrf.Tango.AttributeConfig_5;
import fr.esrf.Tango.AttributeConfig_5Helper;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.AttributeValue_4Helper;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.AttributeValue_5Helper;
import fr.esrf.Tango.DevErrorListHelper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChange;
import fr.esrf.Tango.DevIntrChangeHelper;
import fr.esrf.Tango.DevPipeData;
import fr.esrf.Tango.DevPipeDataHelper;
import fr.esrf.Tango.ZmqCallInfo;
import fr.esrf.Tango.ZmqCallInfoHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jacorb.orb.CDROutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.events.EventConstants;
import org.tango.server.events.EventType;
import org.tango.server.idl.TangoIDLAttributeUtil;
import org.zeromq.ZMQ;

class EventUtilities {
    private static final byte[] LITTLE_ENDIAN = new byte[]{0};
    private static final String HEARTBEAT = ".heartbeat";
    private static final String TANGO = "tango://";
    private static final String IDL_VERSION = "idlversion_";
    private static final String DOT = ".";
    private static final String VERSION = "version";
    private static final XLogger XLOGGER = XLoggerFactory.getXLogger(EventUtilities.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EventUtilities.class);
    private static double zmqVersion = -1.0;
    private static String tangoHost = null;

    EventUtilities() {
    }

    static String buildEventName(String deviceName, String attributeName, EventType eventType, int idlVersion) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, attributeName);
        fullName = idlVersion >= 5 ? fullName + DOT + IDL_VERSION.replace(VERSION, Integer.toString(idlVersion)) + eventType.getString() : fullName + DOT + eventType.getString();
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    static String buildEventName(String deviceName, String attributeName, EventType eventType) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, attributeName);
        fullName = fullName + ".idl5_" + eventType.getString();
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    static String buildPipeEventName(String deviceName, String pipename) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, null);
        fullName = fullName + "/" + pipename + DOT + EventType.PIPE_EVENT.getString();
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    static String buildHeartBeatEventName(String deviceName) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, null);
        fullName = fullName + HEARTBEAT;
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    static String buildDeviceEventName(String deviceName, EventType eventType) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, null);
        fullName = fullName + DOT + eventType.getString();
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    private static String buildEventNameBeginning(String deviceName, String attributeName) throws DevFailed {
        if (tangoHost == null) {
            tangoHost = DatabaseFactory.getDatabase().getPossibleTangoHosts()[0];
        }
        String fullName = TANGO + tangoHost + "/" + deviceName.toLowerCase(Locale.ENGLISH);
        if (attributeName != null) {
            fullName = fullName + "/" + attributeName.toLowerCase(Locale.ENGLISH);
        }
        return fullName;
    }

    static byte[] cppAlignmentAdd8(byte[] data) {
        XLOGGER.entry(new Object[0]);
        byte[] buffer = new byte[data.length + 8];
        buffer[0] = -64;
        buffer[1] = -34;
        buffer[2] = -64;
        buffer[3] = -34;
        buffer[4] = -64;
        buffer[5] = -34;
        buffer[6] = -64;
        buffer[7] = -34;
        System.arraycopy(data, 0, buffer, 8, data.length);
        XLOGGER.exit();
        return buffer;
    }

    static byte[] cppAlignment(byte[] data) {
        XLOGGER.entry(new Object[0]);
        byte[] buffer = new byte[data.length + 4];
        buffer[0] = -64;
        buffer[1] = -34;
        buffer[2] = -64;
        buffer[3] = -34;
        System.arraycopy(data, 0, buffer, 4, data.length);
        XLOGGER.exit();
        return buffer;
    }

    static byte[] marshallIDL5(AttributeValue_5 attributeValue) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        try (CDROutputStream os = new CDROutputStream();){
            AttributeValue_5Helper.write(os, attributeValue);
            XLOGGER.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
    }

    static byte[] marshallIDL4(AttributeValue_4 attributeValue) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        try (CDROutputStream os = new CDROutputStream();){
            AttributeValue_4Helper.write(os, attributeValue);
            XLOGGER.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
    }

    static byte[] marshallIDL5(AttributeImpl attribute) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        AttributeValue_5 attributeValue = TangoIDLAttributeUtil.toAttributeValue5(attribute, attribute.getReadValue(), attribute.getWriteValue());
        return EventUtilities.marshallIDL5(attributeValue);
    }

    static byte[] marshallIDL4(AttributeImpl attribute) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        AttributeValue_4 attributeValue = TangoIDLAttributeUtil.toAttributeValue4(attribute, attribute.getReadValue(), attribute.getWriteValue());
        return EventUtilities.marshallIDL4(attributeValue);
    }

    static byte[] marshall(AttDataReady dataReady) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        try (CDROutputStream os = new CDROutputStream();){
            AttDataReadyHelper.write(os, dataReady);
            XLOGGER.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshallIDL4Config(AttributeImpl attribute) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        AttributeConfig_3 config = TangoIDLAttributeUtil.toAttributeConfig3(attribute);
        try (CDROutputStream os = new CDROutputStream();){
            AttributeConfig_3Helper.write(os, config);
            XLOGGER.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
    }

    static byte[] marshallIDL5Config(AttributeImpl attribute) throws DevFailed {
        return EventUtilities.marshallIDL5Config(TangoIDLAttributeUtil.toAttributeConfig5(attribute));
    }

    static byte[] marshallIDL5Config(AttributeConfig_5 config) {
        XLOGGER.entry(new Object[0]);
        try (CDROutputStream os = new CDROutputStream();){
            AttributeConfig_5Helper.write(os, config);
            XLOGGER.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
    }

    static byte[] marshall(DevFailed devFailed) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        try (CDROutputStream os = new CDROutputStream();){
            DevErrorListHelper.write(os, devFailed.errors);
            XLOGGER.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshall(int counter, boolean isException) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        ZmqCallInfo zmqCallInfo = new ZmqCallInfo(EventConstants.ZMQ_RELEASE, counter, "", EventConstants.OBJECT_IDENTIFIER, isException);
        try (CDROutputStream os = new CDROutputStream();){
            ZmqCallInfoHelper.write(os, zmqCallInfo);
            XLOGGER.exit();
            byte[] byArray = os.getBufferCopy();
            return byArray;
        }
    }

    static byte[] marshall(DevIntrChange deviceInterface) {
        XLOGGER.entry(new Object[0]);
        try (CDROutputStream os = new CDROutputStream();){
            DevIntrChangeHelper.write(os, deviceInterface);
            XLOGGER.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
    }

    static byte[] marshall(DevPipeData pipeData) {
        XLOGGER.entry(new Object[0]);
        try (CDROutputStream os = new CDROutputStream();){
            DevPipeDataHelper.write(os, pipeData);
            XLOGGER.exit();
            byte[] byArray = EventUtilities.cppAlignmentAdd8(os.getBufferCopy());
            return byArray;
        }
    }

    static double getZmqVersion() {
        XLOGGER.entry(new Object[0]);
        if (zmqVersion < 0.0) {
            zmqVersion = 0.0;
            try {
                String strVersion = ZMQ.getVersionString();
                StringTokenizer stk = new StringTokenizer(strVersion, DOT);
                ArrayList<String> list = new ArrayList<String>();
                while (stk.hasMoreTokens()) {
                    list.add(stk.nextToken());
                }
                strVersion = (String)list.get(0) + DOT + (String)list.get(1);
                if (list.size() > 2) {
                    strVersion = strVersion + (String)list.get(2);
                }
                try {
                    zmqVersion = Double.parseDouble(strVersion);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        XLOGGER.exit();
        return zmqVersion;
    }

    static void sendContextData(ZMQ.Socket eventSocket, String fullName, int counter) throws DevFailed {
        EventUtilities.sendContextData(eventSocket, fullName, counter, false);
    }

    static void sendContextData(ZMQ.Socket eventSocket, String fullName, int counter, boolean isException) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        eventSocket.sendMore(fullName);
        eventSocket.send(LITTLE_ENDIAN, 2);
        eventSocket.send(EventUtilities.marshall(counter, isException), 2);
        XLOGGER.exit();
    }

    static void sendHeartbeat(ZMQ.Socket heartbeatSocket, String fullName) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        heartbeatSocket.sendMore(fullName);
        heartbeatSocket.send(LITTLE_ENDIAN, 2);
        heartbeatSocket.send(EventUtilities.marshall(0, false));
        XLOGGER.exit();
    }

    static void sendToSocket(ZMQ.Socket eventSocket, String fullName, int counter, boolean isException, byte[] data) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        EventUtilities.sendContextData(eventSocket, fullName, counter, isException);
        eventSocket.send(data);
        LOGGER.debug("event {} sent", (Object)fullName);
        XLOGGER.exit();
    }

    static void sendToSocket(ZMQ.Socket eventSocket, String fullName, int counter, byte[] data) throws DevFailed {
        EventUtilities.sendToSocket(eventSocket, fullName, counter, false, data);
    }
}

