/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.esrf.Tango.AttributeConfig_5;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChange;
import fr.esrf.Tango.DevPipeData;
import fr.esrf.Tango.DevVarLongStringArray;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.orb.ORBManager;
import org.tango.orb.ServerRequestInterceptor;
import org.tango.server.ServerManager;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.events.ArchiveEventTrigger;
import org.tango.server.events.ChangeEventTrigger;
import org.tango.server.events.EventConstants;
import org.tango.server.events.EventImpl;
import org.tango.server.events.EventType;
import org.tango.server.events.EventUtilities;
import org.tango.server.idl.TangoIDLUtil;
import org.tango.server.pipe.PipeImpl;
import org.tango.server.pipe.PipeValue;
import org.tango.utils.DevFailedUtils;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public final class EventManager {
    public static final int MINIMUM_IDL_VERSION = 4;
    public static final String IDL_REGEX = "idl[0-9]_[a-z]*";
    public static final String IDL_LATEST = "idl5_";
    private static final EventManager INSTANCE = new EventManager();
    private final Logger logger = LoggerFactory.getLogger(EventManager.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(EventManager.class);
    private final Map<String, EventImpl> eventImplMap = new HashMap<String, EventImpl>();
    private final ScheduledExecutorService heartBeatExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Event HeartBeat");
        }
    });
    private final ZContext context = new ZContext();
    private final int serverHWM = this.initializeServerHwm();
    private final int clientHWN = this.initializeClientHwm();
    private final Map<String, ZMQ.Socket> heartbeatEndpoints = new LinkedHashMap<String, ZMQ.Socket>();
    private final Map<String, ZMQ.Socket> eventEndpoints = new LinkedHashMap<String, ZMQ.Socket>();
    private volatile boolean isInitialized;

    private EventManager() {
        this.logger.debug("client IP address is {}", (Object)ServerRequestInterceptor.getInstance().getClientIPAddress());
        this.logger.info("ZMQ ({}) SERVER event system started", (Object)ZMQ.getVersionString());
        this.isInitialized = false;
    }

    private int initializeServerHwm() {
        String env = System.getenv("TANGO_DS_EVENT_BUFFER_HWM");
        try {
            if (env != null) {
                return Integer.parseInt(env);
            }
            return 1000;
        }
        catch (NumberFormatException e) {
            this.logger.error("system.env TANGO_DS_EVENT_BUFFER_HWM is not a number: {} ", (Object)env);
            return 1000;
        }
    }

    private int initializeClientHwm() {
        String value = "";
        try {
            value = DatabaseFactory.getDatabase().getFreeProperty("CtrlSystem", "EventBufferHwm");
            return Integer.parseInt(value);
        }
        catch (DevFailed e) {
            DevFailedUtils.logDevFailed(e, this.logger);
            return 1000;
        }
        catch (NumberFormatException e) {
            this.logger.error("CtrlSystem/EventBufferHwm property is not a number: {} ", (Object)value);
            return 1000;
        }
    }

    public static EventManager getInstance() {
        return INSTANCE;
    }

    public static void checkEventCriteria(AttributeImpl attribute, EventType eventType) throws DevFailed {
        switch (eventType) {
            case CHANGE_EVENT: {
                ChangeEventTrigger.checkEventCriteria(attribute);
                break;
            }
            case ARCHIVE_EVENT: {
                ArchiveEventTrigger.checkEventCriteria(attribute);
                break;
            }
        }
    }

    private void initialize() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        Iterable<String> ipAddress = this.getIpAddresses();
        Iterable<String> ip4Address = Iterables.filter(ipAddress, new Predicate<String>(){

            @Override
            public boolean apply(String s) {
                return s.split("\\.").length == 4;
            }
        });
        this.bindEndpoints(this.createSocket(), ip4Address, this.heartbeatEndpoints, SocketType.HEARTBEAT);
        this.bindEndpoints(this.createEventSocket(), ip4Address, this.eventEndpoints, SocketType.EVENTS);
        String adminDeviceName = ServerManager.getInstance().getAdminDeviceName();
        String heartbeatName = EventUtilities.buildHeartBeatEventName(adminDeviceName);
        this.heartBeatExecutor.scheduleAtFixedRate(new HeartbeatThread(heartbeatName), 0L, 9000L, TimeUnit.MILLISECONDS);
        this.isInitialized = true;
        this.xlogger.exit();
    }

    private Iterable<String> getIpAddresses() throws DevFailed {
        ArrayList<String> result;
        if (ORBManager.OAI_ADDR != null && !ORBManager.OAI_ADDR.isEmpty()) {
            result = new ArrayList<String>(1);
            result.add(ORBManager.OAI_ADDR);
        } else {
            try {
                ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
                result = new ArrayList();
                Predicate<NetworkInterface> isLoopback = new Predicate<NetworkInterface>(){

                    @Override
                    public boolean apply(NetworkInterface networkInterface) {
                        try {
                            return !networkInterface.isLoopback();
                        }
                        catch (SocketException e) {
                            EventManager.this.logger.warn("Ignoring NetworkInterface({}) due to an exception: {}", (Object)networkInterface.getName(), (Object)e);
                            return false;
                        }
                    }
                };
                Function<InterfaceAddress, String> interfaceAddressToString = new Function<InterfaceAddress, String>(){

                    @Override
                    public String apply(InterfaceAddress interfaceAddress) {
                        return interfaceAddress.getAddress().getHostAddress();
                    }
                };
                Iterable<NetworkInterface> filteredNICs = Iterables.filter(networkInterfaces, isLoopback);
                for (NetworkInterface nic : filteredNICs) {
                    result.addAll(Lists.transform(nic.getInterfaceAddresses(), interfaceAddressToString));
                }
            }
            catch (SocketException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
        }
        return result;
    }

    private void bindEndpoints(ZMQ.Socket socket, Iterable<String> ipAddresses, Map<String, ZMQ.Socket> endpoints, SocketType socketType) {
        this.xlogger.entry(new Object[]{ipAddresses, endpoints, socketType});
        for (String ipAddress : ipAddresses) {
            StringBuilder endpoint = new StringBuilder("tcp://").append(ipAddress).append(":*");
            int port = socket.bind(endpoint.toString());
            endpoint.deleteCharAt(endpoint.length() - 1).append(port);
            endpoints.put(endpoint.toString(), socket);
            this.logger.debug("bind ZMQ socket {} for {}", (Object)endpoint.toString(), (Object)socketType);
        }
        this.xlogger.exit();
    }

    private ZMQ.Socket createSocket() {
        ZMQ.Socket socket = this.context.createSocket(1);
        socket.setLinger(0L);
        socket.setReconnectIVL(-1L);
        return socket;
    }

    private ZMQ.Socket createEventSocket() {
        ZMQ.Socket socket = this.context.createSocket(1);
        socket.setLinger(0L);
        socket.setReconnectIVL(-1L);
        socket.setSndHWM(this.serverHWM);
        this.logger.debug("HWM has been set to {}", (Object)socket.getSndHWM());
        return socket;
    }

    private EventImpl getEventImpl(String fullName) {
        if (!this.isInitialized) {
            return null;
        }
        EventImpl eventImpl = this.eventImplMap.get(fullName);
        if (eventImpl != null && !eventImpl.isStillSubscribed()) {
            this.logger.debug("{} not subscribed any more", (Object)fullName);
            this.eventImplMap.remove(fullName);
            if (this.eventImplMap.isEmpty()) {
                this.logger.debug("no subscribers on server, closing resources");
                this.close();
            }
            eventImpl = null;
        }
        return eventImpl;
    }

    public boolean hasSubscriber(String deviceName) {
        boolean hasSubscriber = false;
        for (String eventName : this.eventImplMap.keySet()) {
            if (!eventName.toLowerCase(Locale.ENGLISH).contains(deviceName.toLowerCase(Locale.ENGLISH))) continue;
            hasSubscriber = true;
            break;
        }
        return hasSubscriber;
    }

    public void close() {
        this.xlogger.entry(new Object[0]);
        this.logger.debug("closing all event resources");
        if (this.heartBeatExecutor != null) {
            this.heartBeatExecutor.shutdown();
            try {
                this.heartBeatExecutor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.error("could not stop event hearbeat");
                Thread.currentThread().interrupt();
            }
        }
        if (this.context != null) {
            this.context.destroy();
        }
        this.eventImplMap.clear();
        this.isInitialized = false;
        this.logger.debug("all event resources closed");
        this.xlogger.exit();
    }

    public DevVarLongStringArray getInfo() {
        DevVarLongStringArray longStringArray = new DevVarLongStringArray();
        longStringArray.lvalue = new int[]{900, 5, this.clientHWN, 0, 0, EventConstants.ZMQ_RELEASE};
        longStringArray.svalue = this.heartbeatEndpoints.isEmpty() || this.eventEndpoints.isEmpty() ? new String[]{"No ZMQ event yet !"} : this.endpointsAsStringArray();
        return longStringArray;
    }

    private String[] endpointsAsStringArray() {
        ArrayList<String> svalue = new ArrayList<String>(this.heartbeatEndpoints.size() + this.eventEndpoints.size());
        int size = this.heartbeatEndpoints.size();
        for (int i = 0; i < size; ++i) {
            svalue.add(Iterables.get(this.heartbeatEndpoints.keySet(), i));
            svalue.add(Iterables.get(this.eventEndpoints.keySet(), i));
        }
        return svalue.toArray(new String[svalue.size()]);
    }

    public DevVarLongStringArray subscribe(String deviceName, PipeImpl pipe) throws DevFailed {
        String fullName;
        EventImpl eventImpl;
        this.xlogger.entry(new Object[0]);
        if (!this.isInitialized) {
            this.initialize();
        }
        if ((eventImpl = this.eventImplMap.get(fullName = EventUtilities.buildPipeEventName(deviceName, pipe.getName()))) == null) {
            eventImpl = new EventImpl(pipe, 5, fullName);
            this.eventImplMap.put(fullName, eventImpl);
        } else {
            eventImpl.updateSubscribeTime();
        }
        return this.buildConnectionParameters(fullName);
    }

    public DevVarLongStringArray subscribe(String deviceName, AttributeImpl attribute, EventType eventType, int idlVersion) throws DevFailed {
        String fullName;
        EventImpl eventImpl;
        this.xlogger.entry(new Object[0]);
        if (!this.isInitialized) {
            this.initialize();
        }
        if ((eventImpl = this.eventImplMap.get(fullName = EventUtilities.buildEventName(deviceName, attribute.getName(), eventType, idlVersion))) == null) {
            if (attribute.getBehavior() instanceof ForwardedAttribute) {
                ForwardedAttribute fwdAttr = (ForwardedAttribute)attribute.getBehavior();
                fwdAttr.subscribe(eventType);
            }
            eventImpl = new EventImpl(attribute, eventType, idlVersion, fullName);
            this.eventImplMap.put(fullName, eventImpl);
        } else {
            eventImpl.updateSubscribeTime();
        }
        this.logger.debug("starting event {}", (Object)fullName);
        return this.buildConnectionParameters(fullName);
    }

    public DevVarLongStringArray subscribe(String deviceName) throws DevFailed {
        String fullName;
        EventImpl eventImpl;
        this.xlogger.entry(new Object[0]);
        if (!this.isInitialized) {
            this.initialize();
        }
        if ((eventImpl = this.eventImplMap.get(fullName = EventUtilities.buildDeviceEventName(deviceName, EventType.INTERFACE_CHANGE_EVENT))) == null) {
            eventImpl = new EventImpl(5, fullName);
            this.eventImplMap.put(fullName, eventImpl);
        } else {
            eventImpl.updateSubscribeTime();
        }
        return this.buildConnectionParameters(fullName);
    }

    private DevVarLongStringArray buildConnectionParameters(String fullName) {
        DevVarLongStringArray longStringArray = new DevVarLongStringArray();
        longStringArray.lvalue = new int[]{900, 5, this.clientHWN, 0, 0, EventConstants.ZMQ_RELEASE};
        longStringArray.svalue = this.endpointsAsStringArray();
        this.logger.debug("event registered for {}", (Object)fullName);
        return longStringArray;
    }

    public void pushAttributeErrorEvent(String deviceName, String attributeName, DevFailed devFailed) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (EventType eventType : EventType.values()) {
            String fullName = EventUtilities.buildEventName(deviceName, attributeName, eventType);
            EventImpl eventImpl = this.getEventImpl(fullName);
            if (eventImpl == null) continue;
            for (ZMQ.Socket eventSocket : this.eventEndpoints.values()) {
                eventImpl.pushDevFailedEvent(devFailed, eventSocket);
            }
        }
        this.xlogger.exit();
    }

    public void pushAttributeValueEvent(String deviceName, String attributeName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (EventType eventType : EventType.getEventAttrValueTypeList()) {
            this.pushAttributeValueEventIdlLoop(deviceName, attributeName, eventType);
        }
        this.xlogger.exit();
    }

    private void pushAttributeValueEventIdlLoop(String deviceName, String attributeName, EventType eventType) throws DevFailed {
        for (int idl = 4; idl <= 5; ++idl) {
            String fullName = EventUtilities.buildEventName(deviceName, attributeName, eventType, idl);
            EventImpl eventImpl = this.getEventImpl(fullName);
            if (eventImpl == null) continue;
            for (ZMQ.Socket eventSocket : this.eventEndpoints.values()) {
                eventImpl.pushAttributeValueEvent(eventSocket);
            }
        }
        this.xlogger.exit();
    }

    public void pushAttributeValueEvent(String deviceName, String attributeName, EventType eventType) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        this.pushAttributeValueEventIdlLoop(deviceName, attributeName, eventType);
        this.xlogger.exit();
    }

    public void pushAttributeDataReadyEvent(String deviceName, String attributeName, int counter) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildEventName(deviceName, attributeName, EventType.DATA_READY_EVENT);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            for (ZMQ.Socket eventSocket : this.eventEndpoints.values()) {
                eventImpl.pushAttributeDataReadyEvent(counter, eventSocket);
            }
        }
        this.xlogger.exit();
    }

    public void pushAttributeConfigEvent(String deviceName, String attributeName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (int idl = 4; idl <= 5; ++idl) {
            String fullName = EventUtilities.buildEventName(deviceName, attributeName, EventType.ATT_CONF_EVENT, idl);
            EventImpl eventImpl = this.getEventImpl(fullName);
            if (eventImpl == null) continue;
            for (ZMQ.Socket eventSocket : this.eventEndpoints.values()) {
                eventImpl.pushAttributeConfigEvent(eventSocket);
            }
        }
        this.xlogger.exit();
    }

    public void pushInterfaceChangedEvent(String deviceName, DevIntrChange deviceInterface) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildDeviceEventName(deviceName, EventType.INTERFACE_CHANGE_EVENT);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            for (ZMQ.Socket eventSocket : this.eventEndpoints.values()) {
                eventImpl.pushInterfaceChangeEvent(deviceInterface, eventSocket);
            }
        }
        this.xlogger.exit();
    }

    public void pushPipeEvent(String deviceName, String pipeName, PipeValue blob) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildPipeEventName(deviceName, pipeName);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            for (ZMQ.Socket eventSocket : this.eventEndpoints.values()) {
                eventImpl.pushPipeEvent(new DevPipeData(pipeName, TangoIDLUtil.getTime(blob.getTime()), blob.getValue().getDevPipeBlobObject()), eventSocket);
            }
        }
        this.xlogger.exit();
    }

    public void pushPipeEvent(String deviceName, String pipeName, DevFailed devFailed) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildPipeEventName(deviceName, pipeName);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            for (ZMQ.Socket eventSocket : this.eventEndpoints.values()) {
                eventImpl.pushDevFailedEvent(devFailed, eventSocket);
            }
        }
        this.xlogger.exit();
    }

    public void pushAttributeValueIDL5Event(String deviceName, String attributeName, AttributeValue_5 value, EventType evtType) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildEventName(deviceName, attributeName, evtType);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            for (ZMQ.Socket eventSocket : this.eventEndpoints.values()) {
                eventImpl.pushAttributeIDL5Event(value, eventSocket);
            }
        }
        this.xlogger.exit();
    }

    public void pushAttributeConfigIDL5Event(String deviceName, String attributeName, AttributeConfig_5 config) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildEventName(deviceName, attributeName, EventType.ATT_CONF_EVENT);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            for (ZMQ.Socket eventSocket : this.eventEndpoints.values()) {
                eventImpl.pushAttributeConfigIDL5Event(config, eventSocket);
            }
        }
        this.xlogger.exit();
    }

    class HeartbeatThread
    implements Runnable {
        private final String heartbeatName;

        HeartbeatThread(String heartbeatName) {
            this.heartbeatName = heartbeatName;
        }

        @Override
        public void run() {
            EventManager.this.xlogger.entry(new Object[0]);
            if (EventManager.this.eventImplMap.isEmpty()) {
                return;
            }
            for (ZMQ.Socket heartbeatSocket : EventManager.this.heartbeatEndpoints.values()) {
                try {
                    EventUtilities.sendHeartbeat(heartbeatSocket, this.heartbeatName);
                }
                catch (DevFailed e) {
                    DevFailedUtils.logDevFailed(e, EventManager.this.logger);
                }
                EventManager.this.logger.debug("Heartbeat sent for {}", (Object)this.heartbeatName);
            }
            EventManager.this.xlogger.exit();
        }
    }

    private static enum SocketType {
        HEARTBEAT,
        EVENTS;

    }
}

