/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.dynamic.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.tango.server.StateMachineBehavior;
import org.tango.server.command.CommandConfiguration;
import org.tango.server.command.ICommandBehavior;
import org.tango.utils.TangoUtil;

public class AsyncGroupCommand
implements ICommandBehavior {
    private final CommandConfiguration config = new CommandConfiguration();
    private final Map<DeviceProxy, String> proxyList = new HashMap<DeviceProxy, String>();

    public AsyncGroupCommand(String name, String ... commandFullNames) throws DevFailed {
        this.config.setName(name);
        this.config.setInType(Void.TYPE);
        this.config.setOutType(Void.TYPE);
        this.config.setInTypeDesc("execute commands " + Arrays.toString(commandFullNames));
        for (String commandName : commandFullNames) {
            String deviceName = TangoUtil.getFullDeviceNameForCommand(commandName);
            DeviceProxy deviceProxy = new DeviceProxy(deviceName);
            this.proxyList.put(deviceProxy, TangoUtil.getAttributeName(commandName));
        }
    }

    @Override
    public CommandConfiguration getConfiguration() throws DevFailed {
        return this.config;
    }

    @Override
    public Object execute(Object arg) throws DevFailed {
        for (Map.Entry<DeviceProxy, String> entry : this.proxyList.entrySet()) {
            entry.getKey().command_inout_asynch(entry.getValue());
        }
        return null;
    }

    @Override
    public StateMachineBehavior getStateMachine() throws DevFailed {
        return null;
    }
}

