/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.dynamic.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.idl.TangoIDLAttributeUtil;

public final class TangoConverter {
    private TangoConverter() {
    }

    public static AttributeConfiguration toAttributeConfiguration(AttributeInfo ai) throws DevFailed {
        AttributeConfiguration result = new AttributeConfiguration();
        result.setName(ai.name);
        result.setTangoType(ai.data_type, ai.data_format);
        result.setMemorized(false);
        result.setDispLevel(ai.level);
        result.setWritable(ai.writable);
        AttributePropertiesImpl properties = new AttributePropertiesImpl();
        properties.setLabel(ai.label);
        properties.setFormat(ai.format);
        properties.setDescription(ai.description);
        properties.setDisplayUnit(ai.display_unit);
        properties.setStandardUnit(ai.standard_unit);
        properties.setUnit(ai.unit);
        properties.setMaxAlarm(ai.max_alarm);
        properties.setMaxValue(ai.max_value);
        properties.setMinAlarm(ai.min_alarm);
        properties.setMinValue(ai.min_value);
        result.setAttributeProperties(properties);
        return result;
    }

    public static AttributeConfiguration toAttributeConfigurationEx(AttributeInfoEx ai) throws DevFailed {
        AttributeConfiguration result = TangoConverter.toAttributeConfiguration(ai);
        AttributePropertiesImpl properties = result.getAttributeProperties();
        properties.setEnumLabels(ai.enum_label);
        properties.setRootAttribute(ai.root_attr_name);
        properties.setEventAbsChange(ai.events.ch_event.abs_change);
        properties.setEventRelChange(ai.events.ch_event.rel_change);
        properties.setEventPeriod(ai.events.per_event.period);
        properties.setArchivingEventAbsChange(ai.events.arch_event.abs_change);
        properties.setArchivingEventRelChange(ai.events.arch_event.rel_change);
        result.setAttributeProperties(properties);
        return result;
    }

    public static AttributeInfoEx toAttributeConfigurationEx(AttributeConfiguration config) throws DevFailed {
        return new AttributeInfoEx(TangoIDLAttributeUtil.toAttributeConfig5(config));
    }
}

