/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.device;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.DeviceState;
import org.tango.utils.DevFailedUtils;

public final class StatusImpl {
    private final Logger logger = LoggerFactory.getLogger(StatusImpl.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(StatusImpl.class);
    private final Method getStatusMethod;
    private final Method setStatusMethod;
    private String status = "";
    private final Object businessObject;
    private final Map<String, String> attributeAlarm = new HashMap<String, String>();

    public StatusImpl(Object businessObject, Method getStatusMethod, Method setStatusMethod) {
        this.getStatusMethod = getStatusMethod;
        this.setStatusMethod = setStatusMethod;
        this.businessObject = businessObject;
        this.status = "";
    }

    public String updateStatus(DeviceState state) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        if (this.getStatusMethod != null) {
            try {
                this.status = (String)this.getStatusMethod.invoke(this.businessObject, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (IllegalAccessException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof DevFailed) {
                    throw (DevFailed)e.getCause();
                }
                throw DevFailedUtils.newDevFailed("INVOCATION_ERROR", ExceptionUtils.getStackTrace(e.getCause()) + " InvocationTargetException");
            }
        } else if (this.status.isEmpty()) {
            this.status = "The device is in " + (Object)((Object)state) + " state.";
        }
        StringBuilder statusAlarm = new StringBuilder();
        for (String string : this.attributeAlarm.values()) {
            statusAlarm = statusAlarm.append(string);
        }
        return this.status + statusAlarm;
    }

    public synchronized void statusMachine(String status, DeviceState state) throws DevFailed {
        if (status != null) {
            this.logger.debug("Changing status to: {}", (Object)status);
            this.status = status;
            if (this.setStatusMethod != null) {
                try {
                    this.setStatusMethod.invoke(this.businessObject, status);
                }
                catch (IllegalArgumentException e) {
                    throw DevFailedUtils.newDevFailed(e);
                }
                catch (IllegalAccessException e) {
                    throw DevFailedUtils.newDevFailed(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof DevFailed) {
                        throw (DevFailed)e.getCause();
                    }
                    throw DevFailedUtils.newDevFailed(e.getCause());
                }
            }
        }
    }

    public void addAttributeAlarm(String attributeName, boolean isTooHigh) throws DevFailed {
        String alarmStatus = isTooHigh ? "\nAlarm : Value too high for " + attributeName : "\nAlarm : Value too low for " + attributeName;
        this.attributeAlarm.put(attributeName, alarmStatus);
    }

    public void addDeltaAttributeAlarm(String attributeName) throws DevFailed {
        String alarmStatus = "\nAlarm : RDS (R-W delta) for " + attributeName;
        this.attributeAlarm.put(attributeName, alarmStatus);
    }

    public void removeAttributeAlarm(String attributeName) {
        this.attributeAlarm.remove(attributeName);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("getStatusMethod", this.getStatusMethod);
        builder.append("setStatusMethod", this.setStatusMethod);
        builder.append("device class", this.businessObject.getClass());
        return builder.toString();
    }

    public String getStatus() {
        return this.status;
    }
}

