/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.device;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.DeviceState;
import org.tango.utils.DevFailedUtils;

public final class StateImpl {
    private final Logger logger = LoggerFactory.getLogger(StateImpl.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(StateImpl.class);
    private final Method getStateMethod;
    private final Method setStateMethod;
    private final Object businessObject;
    private DevState state = DevState.UNKNOWN;
    private final Set<String> attributeAlarm = new HashSet<String>();

    public StateImpl(Object businessObject, Method getStateMethod, Method setStateMethod) {
        this.businessObject = businessObject;
        this.getStateMethod = getStateMethod;
        this.setStateMethod = setStateMethod;
    }

    public boolean isDefaultState() {
        return this.getStateMethod == null;
    }

    public DevState updateState() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        if (this.getStateMethod != null) {
            try {
                Object getState = this.getStateMethod.invoke(this.businessObject, new Object[0]);
                if (getState != null) {
                    this.state = getState instanceof DeviceState ? ((DeviceState)((Object)getState)).getDevState() : (DevState)getState;
                }
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (IllegalAccessException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof DevFailed) {
                    throw (DevFailed)e.getCause();
                }
                throw DevFailedUtils.newDevFailed(e.getCause());
            }
        }
        this.xlogger.exit();
        return this.state;
    }

    public void addAttributeAlarm(String attributeName) {
        this.attributeAlarm.add(attributeName);
        this.state = DevState.ALARM;
    }

    public void removeAttributeAlarm(String attributeName) {
        this.attributeAlarm.remove(attributeName);
    }

    public synchronized void stateMachine(DeviceState state) throws DevFailed {
        if (state != null) {
            this.state = state.getDevState();
            if (this.setStateMethod != null) {
                this.logger.debug("Changing state to {}", (Object)state);
                try {
                    if (this.setStateMethod.getParameterTypes()[0].equals(DeviceState.class)) {
                        this.setStateMethod.invoke(this.businessObject, new Object[]{state});
                    } else {
                        this.setStateMethod.invoke(this.businessObject, this.state);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw DevFailedUtils.newDevFailed(e);
                }
                catch (IllegalAccessException e) {
                    throw DevFailedUtils.newDevFailed(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof DevFailed) {
                        throw (DevFailed)e.getCause();
                    }
                    throw DevFailedUtils.newDevFailed(e.getCause());
                }
            }
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("getStateMethod", this.getStateMethod);
        builder.append("setStateMethod", this.setStateMethod);
        builder.append("device class", this.businessObject.getClass());
        return builder.toString();
    }

    public DevState getState() {
        return this.state;
    }
}

