/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.device;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevFailed;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tango.DeviceState;
import org.tango.orb.ServerRequestInterceptor;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.command.CommandImpl;
import org.tango.server.events.EventManager;
import org.tango.server.events.EventType;
import org.tango.server.pipe.PipeImpl;
import org.tango.server.pipe.PipeValue;
import org.tango.server.servant.AttributeGetterSetter;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.ClientIDUtil;
import org.tango.utils.DevFailedUtils;

public final class DeviceManager {
    private final DeviceImpl device;
    private final String name;
    private final String className;
    private final String adminName;

    public DeviceManager(DeviceImpl device) {
        this.device = device;
        this.name = device.getName();
        this.className = device.getClassName();
        this.adminName = device.getAdminDeviceName();
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public AttributePropertiesImpl getAttributeProperties(String attributeName) throws DevFailed {
        AttributeImpl attr = AttributeGetterSetter.getAttribute(attributeName, this.device.getAttributeList());
        return attr.getProperties();
    }

    public void setAttributeProperties(String attributeName, AttributePropertiesImpl properties) throws DevFailed {
        AttributeImpl attr = AttributeGetterSetter.getAttribute(attributeName, this.device.getAttributeList());
        attr.setProperties(properties);
    }

    public void removeAttributeProperties(String attributeName) throws DevFailed {
        AttributeImpl attr = AttributeGetterSetter.getAttribute(attributeName, this.device.getAttributeList());
        attr.removeProperties();
    }

    public boolean isPolled(String polledObject) throws DevFailed {
        try {
            return AttributeGetterSetter.getAttribute(polledObject, this.device.getAttributeList()).isPolled();
        }
        catch (DevFailed e) {
            return this.device.getCommand(polledObject).isPolled();
        }
    }

    public int getPollingPeriod(String polledObject) throws DevFailed {
        try {
            return AttributeGetterSetter.getAttribute(polledObject, this.device.getAttributeList()).getPollingPeriod();
        }
        catch (DevFailed e) {
            return this.device.getCommand(polledObject).getPollingPeriod();
        }
    }

    public void startPolling(String polledObject, int pollingPeriod) throws DevFailed {
        try {
            AttributeImpl attr = AttributeGetterSetter.getAttribute(polledObject, this.device.getAttributeList());
            attr.configurePolling(pollingPeriod);
            this.device.startPolling(attr);
        }
        catch (DevFailed e) {
            if (polledObject.equalsIgnoreCase("State") || polledObject.equalsIgnoreCase("Status")) {
                CommandImpl cmd = this.device.getCommand(polledObject);
                cmd.configurePolling(pollingPeriod);
                this.device.startPolling(cmd);
            }
            throw e;
        }
    }

    public void startPolling(String polledObject) throws DevFailed {
        try {
            AttributeImpl attr = AttributeGetterSetter.getAttribute(polledObject, this.device.getAttributeList());
            this.device.startPolling(attr);
        }
        catch (DevFailed e) {
            if (polledObject.equalsIgnoreCase("State") || polledObject.equalsIgnoreCase("Status")) {
                CommandImpl cmd = this.device.getCommand(polledObject);
                this.device.startPolling(cmd);
            }
            throw e;
        }
    }

    public void stopPolling(String polledObject) throws DevFailed {
        try {
            this.device.removeAttributePolling(polledObject);
        }
        catch (DevFailed e) {
            if (polledObject.equalsIgnoreCase("State") || polledObject.equalsIgnoreCase("Status")) {
                this.device.removeCommandPolling(polledObject);
            }
            throw e;
        }
    }

    public void triggerPolling(String polledObject) throws DevFailed {
        this.device.triggerPolling(polledObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvent(String attributeName, EventType eventType) throws DevFailed {
        switch (eventType) {
            case CHANGE_EVENT: 
            case ARCHIVE_EVENT: 
            case USER_EVENT: {
                AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.device.getAttributeList());
                attribute.lock();
                try {
                    attribute.updateValue();
                    EventManager.getInstance().pushAttributeValueEvent(this.name, attributeName, eventType);
                    break;
                }
                catch (DevFailed e) {
                    EventManager.getInstance().pushAttributeErrorEvent(this.name, attributeName, e);
                    break;
                }
                finally {
                    attribute.unlock();
                }
            }
            default: {
                throw DevFailedUtils.newDevFailed("Only USER, ARCHIVE or CHANGE event can be send");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvent(String attributeName, AttributeValue value, EventType eventType) throws DevFailed {
        switch (eventType) {
            case CHANGE_EVENT: 
            case ARCHIVE_EVENT: 
            case USER_EVENT: {
                AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.device.getAttributeList());
                attribute.lock();
                try {
                    if (value.getValue() instanceof DeviceState) {
                        DeviceState state = (DeviceState)((Object)value.getValue());
                        value.setValue(state.getDevState());
                    }
                    attribute.updateValue(value);
                    EventManager.getInstance().pushAttributeValueEvent(this.name, attributeName, eventType);
                    break;
                }
                catch (DevFailed e) {
                    EventManager.getInstance().pushAttributeErrorEvent(this.name, attributeName, e);
                    break;
                }
                finally {
                    attribute.unlock();
                }
            }
            default: {
                throw DevFailedUtils.newDevFailed("Only USER, ARCHIVE or CHANGE event can be send");
            }
        }
    }

    public void pushDataReadyEvent(String attributeName, int counter) throws DevFailed {
        EventManager.getInstance().pushAttributeDataReadyEvent(this.name, attributeName, counter);
    }

    public void pushPipeEvent(String pipeName, PipeValue blob) throws DevFailed {
        PipeImpl pipe = DeviceImpl.getPipe(pipeName, this.device.getPipeList());
        try {
            pipe.updateValue(blob);
            EventManager.getInstance().pushPipeEvent(this.name, pipeName, blob);
        }
        catch (DevFailed e) {
            EventManager.getInstance().pushPipeEvent(this.name, pipeName, e);
        }
    }

    @Deprecated
    public ClntIdent getClientIdentity() {
        return ClientIDUtil.copyClntIdent(this.device.getClientIdentity());
    }

    @Deprecated
    public String getClientHostName() {
        return ServerRequestInterceptor.getInstance().getClientHostName();
    }

    public boolean hasEventSubsriber() {
        return EventManager.getInstance().hasSubscriber(this.name);
    }

    public String toString() {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        reflectionToStringBuilder.setExcludeFieldNames("device");
        return reflectionToStringBuilder.toString();
    }
}

