/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.device;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.InvocationContext;
import org.tango.utils.DevFailedUtils;

public final class AroundInvokeImpl {
    private final XLogger xlogger = XLoggerFactory.getXLogger(AroundInvokeImpl.class);
    private final Object businessObject;
    private final Method aroundInvokeMethod;

    public AroundInvokeImpl(Object businessObject, Method aroundInvokeMethod) {
        this.businessObject = businessObject;
        this.aroundInvokeMethod = aroundInvokeMethod;
    }

    public void aroundInvoke(InvocationContext ctx) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        if (this.aroundInvokeMethod != null) {
            try {
                this.aroundInvokeMethod.invoke(this.businessObject, ctx);
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (IllegalAccessException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof DevFailed) {
                    throw (DevFailed)e.getCause();
                }
                throw DevFailedUtils.newDevFailed(e.getCause());
            }
        }
        this.xlogger.exit();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("method", this.aroundInvokeMethod);
        builder.append("device class", this.businessObject.getClass());
        return builder.toString();
    }
}

