/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.command;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.StateMachineBehavior;
import org.tango.server.command.CommandConfiguration;
import org.tango.server.command.ICommandBehavior;
import org.tango.utils.DevFailedUtils;

public final class ReflectCommandBehavior
implements ICommandBehavior {
    private final XLogger xlogger = XLoggerFactory.getXLogger(ReflectCommandBehavior.class);
    private final Method executeMethod;
    private final Object businessObject;
    private final CommandConfiguration config;

    public ReflectCommandBehavior(Method executeMethod, Object businessObject, CommandConfiguration config) {
        this.executeMethod = executeMethod;
        this.businessObject = businessObject;
        this.config = config;
    }

    @Override
    public Object execute(Object arg) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        Object obj = null;
        try {
            if (!this.config.getInType().equals(Void.class)) {
                this.checkInputType(arg);
                obj = this.executeMethod.invoke(this.businessObject, arg);
            } else {
                obj = this.executeMethod.invoke(this.businessObject, new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        catch (IllegalAccessException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof DevFailed) {
                throw (DevFailed)e.getCause();
            }
            throw DevFailedUtils.newDevFailed(e.getCause());
        }
        this.xlogger.exit();
        return obj;
    }

    private void checkInputType(Object arg) throws DevFailed {
        Class<?> input;
        Class<?>[] paramType = this.executeMethod.getParameterTypes();
        if (paramType.length > 1) {
            throw DevFailedUtils.newDevFailed("INIT_FAILED", "Command can have only one parameter");
        }
        Class<?> paramMethod = paramType[0];
        if (Number.class.isAssignableFrom(paramMethod) || Boolean.class.isAssignableFrom(paramMethod)) {
            paramMethod = ClassUtils.wrapperToPrimitive(paramMethod);
        }
        if (Number.class.isAssignableFrom(input = arg.getClass()) || Boolean.class.isAssignableFrom(input)) {
            input = ClassUtils.wrapperToPrimitive(arg.getClass());
        }
        if (!paramMethod.isAssignableFrom(input)) {
            throw DevFailedUtils.newDevFailed("TYPE_ERROR", "type mismatch, expected was " + paramMethod.getCanonicalName() + ", input is " + arg.getClass().getCanonicalName());
        }
    }

    @Override
    public CommandConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public StateMachineBehavior getStateMachine() {
        return null;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("executeMethod", this.executeMethod);
        return builder.toString();
    }
}

