/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.command;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.command.CommandTangoType;
import org.tango.server.DeviceBehaviorObject;
import org.tango.server.IPollable;
import org.tango.server.cache.PollingUtils;
import org.tango.server.command.CommandConfiguration;
import org.tango.server.command.CommandHistory;
import org.tango.server.command.ICommandBehavior;
import org.tango.server.properties.AttributePropertiesManager;

public class CommandImpl
extends DeviceBehaviorObject
implements Comparable<CommandImpl>,
IPollable {
    public static final int TANGO_OPERATOR_CMD = 0;
    public static final int TANGO_EXPERT_CMD = 1;
    private final XLogger xlogger = XLoggerFactory.getXLogger(CommandImpl.class);
    private final String name;
    private final CommandConfiguration config;
    private final ICommandBehavior behavior;
    private final CommandTangoType inType;
    private final CommandTangoType outType;
    private final CommandHistory history;
    private final AttributePropertiesManager attributePropertiesManager;
    private volatile double executionDuration;
    private volatile double lastUpdateTime;
    private volatile double deltaTime;
    private DevFailed lastError;

    public CommandImpl(ICommandBehavior behavior, String deviceName) throws DevFailed {
        this.config = behavior.getConfiguration();
        this.name = this.config.getName();
        this.behavior = behavior;
        this.attributePropertiesManager = new AttributePropertiesManager(deviceName);
        this.inType = CommandTangoType.getTypeFromTango(this.config.getInTangoType());
        this.outType = CommandTangoType.getTypeFromTango(this.config.getOutTangoType());
        this.history = new CommandHistory(this.config.getOutTangoType());
    }

    public Object execute(Object dataIn) throws DevFailed {
        Object result;
        this.xlogger.entry(this.name);
        try {
            result = this.behavior.execute(dataIn);
        }
        catch (DevFailed e) {
            this.lastError = e;
            throw e;
        }
        this.xlogger.exit(this.name);
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CommandTangoType getInType() {
        return this.inType;
    }

    public int getInTangoType() {
        return this.config.getInTangoType();
    }

    public boolean isArginPrimitive() {
        return this.config.getInType().isPrimitive();
    }

    public CommandTangoType getOutType() {
        return this.outType;
    }

    public int getOutTangoType() {
        return this.config.getOutTangoType();
    }

    public String getInTypeDesc() {
        return this.config.getInTypeDesc();
    }

    public String getOutTypeDesc() {
        return this.config.getOutTypeDesc();
    }

    public int getTag() {
        if (this.config.getDispLevel().equals(DispLevel.OPERATOR)) {
            return 0;
        }
        return 1;
    }

    public DispLevel getDisplayLevel() {
        return this.config.getDispLevel();
    }

    public void setDisplayLevel(DispLevel level) {
        this.config.setDispLevel(level);
    }

    public void addToHistory(Object value) throws DevFailed {
        this.history.addToHistory(value, new DevError[0]);
    }

    public void addErrorToHistory(DevFailed e) throws DevFailed {
        this.history.addToHistory(null, e.errors);
    }

    public CommandHistory getHistory() {
        return this.history;
    }

    @Override
    public String toString() {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE);
        reflectionToStringBuilder.setExcludeFieldNames("inType", "outType", "history");
        return reflectionToStringBuilder.toString();
    }

    public ICommandBehavior getBehavior() {
        return this.behavior;
    }

    @Override
    public int getPollingPeriod() {
        return this.config.getPollingPeriod();
    }

    @Override
    public boolean isPolled() {
        return this.config.isPolled();
    }

    @Override
    public void configurePolling(int pollingPeriod) throws DevFailed {
        PollingUtils.configurePolling(pollingPeriod, this.config, this.attributePropertiesManager);
        this.history.clear();
    }

    @Override
    public void resetPolling() throws DevFailed {
        PollingUtils.resetPolling(this.config, this.attributePropertiesManager);
    }

    public void updatePollingConfigFromDB() throws DevFailed {
        PollingUtils.updatePollingConfigFromDB(this.config, this.attributePropertiesManager);
    }

    @Override
    public int compareTo(CommandImpl o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public int getPollRingDepth() {
        return this.history.getMaxSize();
    }

    @Override
    public void setPollRingDepth(int pollRingDepth) {
        this.history.setMaxSize(pollRingDepth);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandImpl other = (CommandImpl)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public double getExecutionDuration() {
        return this.executionDuration;
    }

    @Override
    public double getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public double getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public void setPollingStats(double executionDuration, double lastUpdateTime, double deltaTime) {
        this.executionDuration = executionDuration;
        this.lastUpdateTime = lastUpdateTime;
        this.deltaTime = deltaTime;
    }

    @Override
    public String getLastDevFailed() {
        return PollingUtils.toString(this.lastError);
    }
}

