/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.cache;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.cache.CacheRefresher;
import org.tango.server.cache.StateStatusCacheEntryFactory;
import org.tango.server.command.CommandImpl;
import org.tango.server.device.AroundInvokeImpl;
import org.tango.server.device.DeviceLocker;

public final class StateStatusCache {
    private final Logger logger = LoggerFactory.getLogger(StateStatusCache.class);
    private ScheduledFuture<?> result;
    private final SelfPopulatingCache cache;
    private final CommandImpl command;

    public StateStatusCache(CacheManager manager, CommandImpl command, AttributeImpl attribute, String deviceName, DeviceLocker deviceLock, AroundInvokeImpl aroundInvoke) {
        this.command = command;
        String cacheName = "stateStatusTangoPollingCache." + deviceName + "/" + command.getName();
        Cache defaultCache = manager.getCache(cacheName);
        if (defaultCache == null) {
            manager.addCache(cacheName);
            defaultCache = manager.getCache(cacheName);
        }
        defaultCache.flush();
        this.cache = new SelfPopulatingCache((Ehcache)defaultCache, new StateStatusCacheEntryFactory(command, attribute, deviceLock, deviceName, aroundInvoke));
        this.cache.getCacheConfiguration().setTimeToLiveSeconds(60L);
    }

    public void startRefresh(ScheduledExecutorService pollingPool) {
        this.logger.debug("start refresh cache of {} at period of {}", (Object)this.command.getName(), (Object)this.command.getPollingPeriod());
        CacheRefresher refresher = new CacheRefresher(this.cache, this.command.getName());
        this.result = pollingPool.scheduleAtFixedRate(refresher, 0L, this.command.getPollingPeriod(), TimeUnit.MILLISECONDS);
    }

    public void stopRefresh() {
        if (this.result != null) {
            this.logger.debug("stop refresh cache of {}", (Object)this.command.getName());
            boolean isCancelled = this.result.cancel(true);
            if (!isCancelled) {
                this.logger.error("stop refresh NOT CANCELLED");
            }
        }
    }

    public SelfPopulatingCache getCache() {
        return this.cache;
    }
}

