/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.cache;

import java.io.Serializable;
import java.util.Locale;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheRefresher
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(CacheRefresher.class);
    private final SelfPopulatingCache cache;
    private final String name;

    public CacheRefresher(SelfPopulatingCache cache, String name) {
        this.cache = cache;
        this.name = name.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void run() {
        this.logger.debug("refresh {}", (Object)this.cache.getName());
        try {
            this.cache.get((Serializable)((Object)this.name));
            this.cache.refresh();
        }
        catch (CacheException e) {
            this.logger.error("error {}", e.getCause());
        }
    }
}

