/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.annotation.Status;
import org.tango.server.build.AttributeMethodBuilder;
import org.tango.server.build.BuilderUtils;
import org.tango.server.device.StatusImpl;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class StatusBuilder {
    private final Logger logger = LoggerFactory.getLogger(AttributeMethodBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(AttributeMethodBuilder.class);

    StatusBuilder() {
    }

    public void build(Class<?> clazz, Field field, DeviceImpl device, Object businessObject) throws DevFailed {
        Method setter;
        Method getter;
        this.xlogger.entry(new Object[0]);
        BuilderUtils.checkStatic(field);
        String stateName = field.getName();
        String getterName = "get" + stateName.substring(0, 1).toUpperCase(Locale.ENGLISH) + stateName.substring(1);
        try {
            getter = clazz.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        if (getter.getParameterTypes().length != 0) {
            throw DevFailedUtils.newDevFailed("TANGO_BUILD_FAILED", getter + " must not have a parameter");
        }
        this.logger.debug("Has an status : {}", (Object)field.getName());
        if (getter.getReturnType() != String.class) {
            throw DevFailedUtils.newDevFailed("TANGO_BUILD_FAILED", getter + " must have a return type of  " + String.class);
        }
        String setterName = "set" + stateName.substring(0, 1).toUpperCase(Locale.ENGLISH) + stateName.substring(1);
        try {
            setter = clazz.getMethod(setterName, String.class);
        }
        catch (NoSuchMethodException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        device.setStatusImpl(new StatusImpl(businessObject, getter, setter));
        Status annot = field.getAnnotation(Status.class);
        if (annot.isPolled()) {
            device.addAttributePolling("Status", annot.pollingPeriod());
        }
        this.xlogger.exit();
    }
}

