/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute;

import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.DevAttrHistory_5;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.Device_5;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.soleil.tango.clientapi.TangoAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.StateMachineBehavior;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.server.dynamic.attribute.TangoConverter;
import org.tango.server.events.EventManager;
import org.tango.server.events.EventType;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

public class ForwardedAttribute
implements IAttributeBehavior {
    private final Logger logger = LoggerFactory.getLogger(ForwardedAttribute.class);
    private TangoAttribute proxy;
    private String fullRootAttributeName;
    private String rootAttributeName;
    private final String attributeName;
    private String localLabel;
    private String remoteLabel;
    private String deviceName;

    public ForwardedAttribute(String fullRootAttributeName, String attributeName, String defaultLabel) throws DevFailed {
        this.attributeName = attributeName;
        this.fullRootAttributeName = fullRootAttributeName;
        this.localLabel = defaultLabel;
    }

    public void init(String deviceName) throws DevFailed {
        if (this.fullRootAttributeName == null || this.fullRootAttributeName.isEmpty()) {
            throw DevFailedUtils.newDevFailed("FWD_MISSING_ROOT", "root attribute name is empty");
        }
        this.deviceName = deviceName;
        this.rootAttributeName = TangoUtil.getAttributeName(this.fullRootAttributeName);
        this.proxy = new TangoAttribute(this.fullRootAttributeName);
        if (this.proxy.getAttributeProxy().get_idl_version() != 5) {
            throw DevFailedUtils.newDevFailed("FWD_TOO_OLD_ROOT_DEVICE", "root device must have an IDL version 5");
        }
        this.logger.debug("forwarded attribute {} created ", (Object)this.fullRootAttributeName);
    }

    public void init(String deviceName, String rootAttributeProperty) throws DevFailed {
        this.deviceName = deviceName;
        this.fullRootAttributeName = rootAttributeProperty;
        this.rootAttributeName = TangoUtil.getAttributeName(this.fullRootAttributeName);
        this.proxy = new TangoAttribute(rootAttributeProperty);
        if (this.proxy.getAttributeProxy().get_idl_version() != 5) {
            throw DevFailedUtils.newDevFailed("FWD_TOO_OLD_ROOT_DEVICE", "root device must have an IDL version 5");
        }
        this.logger.debug("forwarded attribute {} created ", (Object)this.fullRootAttributeName);
    }

    @Override
    public AttributeConfiguration getConfiguration() throws DevFailed {
        AttributeConfiguration config;
        if (this.proxy != null) {
            config = TangoConverter.toAttributeConfigurationEx(this.proxy.getAttributeProxy().get_info_ex());
            this.remoteLabel = config.getAttributeProperties().getLabel();
        } else {
            config = new AttributeConfiguration();
        }
        config.setName(this.attributeName);
        config.getAttributeProperties().setRootAttribute(this.fullRootAttributeName);
        config.getAttributeProperties().setLabel(this.localLabel);
        return config;
    }

    @Override
    public AttributeValue getValue() throws DevFailed {
        AttributeValue readValue = new AttributeValue();
        readValue.setValue(this.proxy.read());
        readValue.setQuality(this.proxy.getDeviceAttribute().getQuality());
        readValue.setTime(this.proxy.getTimestamp());
        return readValue;
    }

    public AttributeValue_5 getValue5() throws DevFailed {
        AttributeValue_5 read5 = this.proxy.getAttributeProxy().read().getAttributeValueObject_5();
        read5.name = this.attributeName;
        return read5;
    }

    @Override
    public void setValue(AttributeValue value) throws DevFailed {
        this.proxy.write(value.getValue());
    }

    @Override
    public StateMachineBehavior getStateMachine() throws DevFailed {
        return null;
    }

    void setLabel(String label) {
        this.localLabel = label;
    }

    void setAttributeConfiguration(AttributeConfiguration config) throws DevFailed {
        AttributeInfoEx info = TangoConverter.toAttributeConfigurationEx(config);
        info.name = this.rootAttributeName;
        this.localLabel = info.label;
        info.label = this.remoteLabel;
        this.proxy.getAttributeProxy().set_info(new AttributeInfoEx[]{info});
    }

    AttributePropertiesImpl getProperties() throws DevFailed {
        return this.getConfiguration().getAttributeProperties();
    }

    public DevAttrHistory_5 getAttributeHistory(int maxSize) throws DevFailed {
        DevAttrHistory_5 result = null;
        DeviceProxy conn = this.proxy.getAttributeProxy().getDeviceProxy();
        conn.build_connection();
        Device_5 device5 = conn.getDevice_5();
        if (device5 != null) {
            result = device5.read_attribute_history_5(this.rootAttributeName, maxSize);
        }
        return result;
    }

    public String getRootName() {
        return this.fullRootAttributeName;
    }

    public void subscribe(EventType eventType) throws DevFailed {
        this.logger.info("fowarded attribute \"{}\" event subscribe {}", (Object)this.attributeName, (Object)eventType);
        CallBack callback = new CallBack(){

            @Override
            public void push_event(EventData evt) {
                try {
                    if (evt.errors != null && evt.errors.length > 0) {
                        EventManager.getInstance().pushAttributeErrorEvent(ForwardedAttribute.this.deviceName, ForwardedAttribute.this.attributeName, new DevFailed(evt.errors));
                    } else {
                        EventType evtT = EventType.getEvent(evt.event_type);
                        switch (evtT) {
                            case ARCHIVE_EVENT: 
                            case PERIODIC_EVENT: 
                            case CHANGE_EVENT: 
                            case USER_EVENT: {
                                EventManager.getInstance().pushAttributeValueIDL5Event(ForwardedAttribute.this.deviceName, ForwardedAttribute.this.attributeName, evt.attr_value.getAttributeValueObject_5(), evtT);
                                break;
                            }
                            case ATT_CONF_EVENT: {
                                EventManager.getInstance().pushAttributeConfigIDL5Event(ForwardedAttribute.this.deviceName, ForwardedAttribute.this.attributeName, evt.attr_config.get_attribute_config_obj_5());
                                break;
                            }
                            case DATA_READY_EVENT: {
                                EventManager.getInstance().pushAttributeDataReadyEvent(ForwardedAttribute.this.deviceName, ForwardedAttribute.this.attributeName, evt.data_ready.ctr);
                                break;
                            }
                        }
                    }
                }
                catch (DevFailed e) {
                    ForwardedAttribute.this.logger.error("error in forwarded event", e);
                    ForwardedAttribute.this.logger.error(DevFailedUtils.toString(e));
                }
            }
        };
        this.proxy.getAttributeProxy().subscribe_event(eventType.getValue(), callback, new String[0]);
    }
}

