/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.DevAttrHistory_4;
import fr.esrf.Tango.DevAttrHistory_5;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.attribute.AttributeHistoryConvertor;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.HistoryItem;

public final class AttributeHistory {
    private final Logger logger = LoggerFactory.getLogger(AttributeHistory.class);
    private final String attributeName;
    private final Deque<HistoryItem> valueHistory = new ArrayDeque<HistoryItem>(100);
    private final boolean isReadWrite;
    private final int tangoType;
    private int maxSize = 10;
    private final AttrDataFormat format;

    public AttributeHistory(String attributeName, boolean isReadWrite, int tangoType, AttrDataFormat format) {
        this.attributeName = attributeName;
        this.isReadWrite = isReadWrite;
        this.tangoType = tangoType;
        this.format = format;
    }

    public synchronized void addToHistory(AttributeValue readValue, AttributeValue writeValue, DevError[] error) {
        while (this.valueHistory.size() >= this.maxSize - 1) {
            this.valueHistory.poll();
        }
        boolean isInserted = this.valueHistory.offer(new HistoryItem(readValue, writeValue, error));
        if (!isInserted) {
            this.logger.debug("{} not inserted in history queue ", (Object)readValue);
        }
    }

    public synchronized int size() {
        return this.valueHistory.size();
    }

    public synchronized void clear() {
        this.valueHistory.clear();
    }

    public synchronized DevAttrHistory_4 getAttrHistory4(int maxSize) throws DevFailed {
        return new AttributeHistoryConvertor(this.attributeName, this.valueHistory, maxSize, this.tangoType, this.format, this.isReadWrite).getAttrHistory4();
    }

    public synchronized DevAttrHistory_5 getAttrHistory5(int maxSize) throws DevFailed {
        return new AttributeHistoryConvertor(this.attributeName, this.valueHistory, maxSize, this.tangoType, this.format, this.isReadWrite).getAttrHistory5();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE);
        builder.append("history size", this.valueHistory.size());
        return builder.toString();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

