/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.admin;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.esrf.Tango.DevFailed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.IPollable;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.build.DeviceClassBuilder;
import org.tango.server.command.CommandImpl;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

public class PollStatusCommand
implements Callable<String[]> {
    private final Logger logger = LoggerFactory.getLogger(PollStatusCommand.class);
    private final String deviceName;
    private final List<DeviceClassBuilder> classList;

    PollStatusCommand(String deviceName, List<DeviceClassBuilder> classList) {
        this.deviceName = deviceName;
        this.classList = classList;
    }

    @Override
    public String[] call() throws DevFailed {
        ArrayList<String> result = new ArrayList<String>();
        DeviceImpl device = this.tryFindDeviceByName(this.deviceName);
        this.addPolledStatus(result, device, device.getCommandList());
        this.addPolledStatus(result, device, device.getAttributeList());
        return result.toArray(new String[0]);
    }

    private void addPolledStatus(List<String> pollStatus, final DeviceImpl device, List<? extends IPollable> pollableList) {
        Collection<IPollable> polledCommands = Collections2.filter(pollableList, new Predicate<IPollable>(){

            @Override
            public boolean apply(IPollable pollable) {
                return pollable.isPolled();
            }
        });
        pollStatus.addAll(Collections2.transform(polledCommands, new Function<IPollable, String>(){

            @Override
            public String apply(IPollable pollable) {
                return PollStatusCommand.this.buildPollingStatus(device, pollable).toString();
            }
        }));
    }

    private DeviceImpl tryFindDeviceByName(final String deviceName) throws DevFailed {
        LinkedList<DeviceImpl> allDevices = Lists.newLinkedList(Iterables.concat(Iterables.transform(this.classList, new Function<DeviceClassBuilder, List<DeviceImpl>>(){

            @Override
            public List<DeviceImpl> apply(DeviceClassBuilder input) {
                return input.getDeviceImplList();
            }
        })));
        Optional<DeviceImpl> device = Iterables.tryFind(allDevices, new Predicate<DeviceImpl>(){

            @Override
            public boolean apply(DeviceImpl input) {
                return deviceName.equalsIgnoreCase(input.getName());
            }
        });
        if (!device.isPresent()) {
            device = Iterables.tryFind(allDevices, new Predicate<DeviceImpl>(){

                @Override
                public boolean apply(DeviceImpl input) {
                    try {
                        return TangoUtil.getfullNameForDevice(deviceName).equalsIgnoreCase(input.getName());
                    }
                    catch (DevFailed devFailed) {
                        PollStatusCommand.this.logger.warn("Failed to get full name for device {}", (Object)deviceName);
                        DevFailedUtils.logDevFailed(devFailed, PollStatusCommand.this.logger);
                        return false;
                    }
                }
            });
        }
        if (!device.isPresent()) {
            throw DevFailedUtils.newDevFailed("API_DeviceNotFound", deviceName + " does not exist");
        }
        return device.get();
    }

    private StringBuilder buildPollingStatus(DeviceImpl device, IPollable pollable) {
        StringBuilder buf = pollable instanceof AttributeImpl ? new StringBuilder("Polled attribute name = ") : new StringBuilder("Polled command name = ");
        buf.append(pollable.getName());
        if (pollable.getPollingPeriod() == 0) {
            buf.append("\nPolling externally triggered");
        } else {
            buf.append("\nPolling period (mS) = ");
            buf.append(pollable.getPollingPeriod());
        }
        buf.append("\nPolling ring buffer depth = ");
        buf.append(pollable.getPollRingDepth());
        if (pollable instanceof AttributeImpl && device.getAttributeHistorySize((AttributeImpl)pollable) == 0) {
            buf.append("\nNo data recorded yet");
        }
        if (pollable instanceof CommandImpl && device.getCommandHistorySize((CommandImpl)pollable) == 0) {
            buf.append("\nNo data recorded yet");
        }
        if (!pollable.getLastDevFailed().isEmpty()) {
            buf.append("\nLast attribute read FAILED :\n").append(pollable.getLastDevFailed());
        } else {
            buf.append("\nTime needed for the last attribute reading (mS) = ");
            buf.append(pollable.getExecutionDuration());
            buf.append("\nData not updated since ");
            buf.append(System.currentTimeMillis() - (long)pollable.getLastUpdateTime());
            buf.append(" mS\nDelta between last records (in mS) = ");
            buf.append(pollable.getDeltaTime());
        }
        return buf;
    }
}

