/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.admin;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.DeviceState;
import org.tango.logging.LoggingManager;
import org.tango.orb.ORBManager;
import org.tango.orb.ServerRequestInterceptor;
import org.tango.server.PolledObjectType;
import org.tango.server.ServerManager;
import org.tango.server.admin.PollStatusCommand;
import org.tango.server.annotation.Attribute;
import org.tango.server.annotation.Command;
import org.tango.server.annotation.Device;
import org.tango.server.annotation.DeviceProperty;
import org.tango.server.annotation.Init;
import org.tango.server.annotation.StateMachine;
import org.tango.server.annotation.Status;
import org.tango.server.annotation.TransactionType;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.build.DeviceClassBuilder;
import org.tango.server.cache.TangoCacheManager;
import org.tango.server.command.CommandImpl;
import org.tango.server.events.EventManager;
import org.tango.server.events.EventType;
import org.tango.server.export.IExporter;
import org.tango.server.monitoring.TangoMXBean;
import org.tango.server.monitoring.TangoStats;
import org.tango.server.pipe.PipeImpl;
import org.tango.server.properties.ClassPropertyImpl;
import org.tango.server.properties.DevicePropertyImpl;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

@Device(transactionType=TransactionType.DEVICE)
public final class AdminDevice
implements TangoMXBean {
    public static final String DOES_NOT_EXIST = " does not exist";
    private static final String DOES_NOT_EXISTS = " does not exists";
    private static final String DEVICE_NAME = "Device name";
    private static final String INPUT_ERROR = "INPUT_ERROR";
    private final Logger logger = LoggerFactory.getLogger(AdminDevice.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(AdminDevice.class);
    @DeviceProperty(name="polling_threads_pool_size", defaultValue={"0"})
    private int pollingThreadsPoolSize = 0;
    private List<DeviceClassBuilder> classList;
    @Status
    private String status;
    private IExporter tangoExporter;
    private TangoStats tangoStats;

    @Init
    @StateMachine(endState=DeviceState.ON)
    public void init() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        TangoCacheManager.setPollSize(this.pollingThreadsPoolSize);
        this.status = "The device is ON\nThe polling is ON";
        this.tangoStats = TangoStats.getInstance();
        this.xlogger.exit();
    }

    public void setTangoExporter(IExporter tangoExporter) {
        this.tangoExporter = tangoExporter;
    }

    public void setClassList(List<DeviceClassBuilder> classList) {
        this.classList = classList;
    }

    @Command(name="DevPollStatus", inTypeDesc="Device name", outTypeDesc="Device polling status")
    public String[] getPollStatus(String deviceName) throws DevFailed {
        this.xlogger.entry(deviceName);
        String[] ret = new PollStatusCommand(deviceName, this.classList).call();
        this.xlogger.exit(ret);
        return ret;
    }

    @Command(name="QueryClass", outTypeDesc="Device server class(es) list")
    public String[] queryClass() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        Object[] ret = new String[this.classList.size() - 1];
        int i = 0;
        for (DeviceClassBuilder clazz : this.classList) {
            if (clazz.getDeviceClass().equals(AdminDevice.class)) continue;
            ret[i++] = clazz.getClassName();
        }
        this.xlogger.exit(Arrays.toString(ret));
        return ret;
    }

    @Command(name="QueryDevice", outTypeDesc="Device server device(s) list")
    public String[] queryDevice() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        ArrayList<String> deviceNames = new ArrayList<String>();
        for (DeviceClassBuilder clazz : this.classList) {
            if (clazz.getDeviceClass().equals(AdminDevice.class)) continue;
            for (DeviceImpl dev : clazz.getDeviceImplList()) {
                deviceNames.add(clazz.getClassName() + "::" + dev.getName());
            }
        }
        this.xlogger.exit();
        return deviceNames.toArray(new String[0]);
    }

    @Command(name="QuerySubDevice", outTypeDesc="Device server sub device(s) list")
    public String[] querySubDevice() throws DevFailed {
        return new String[0];
    }

    @Command(name="DevRestart", inTypeDesc="Device name")
    public void restart(String deviceName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        int nbClasses = 0;
        ClntIdent id = this.tangoExporter.getDevice("DServer", ServerManager.getInstance().getAdminDeviceName()).getClientIdentity();
        for (DeviceClassBuilder deviceClass : this.classList) {
            if (deviceClass.containsDevice(deviceName)) {
                deviceClass.getDeviceImpl(deviceName).checkLocking(id);
                this.tangoExporter.buildDevice(deviceName, deviceClass);
                this.xlogger.exit();
                break;
            }
            ++nbClasses;
        }
        if (nbClasses == this.classList.size()) {
            throw DevFailedUtils.newDevFailed("API_DeviceNotFound", deviceName + DOES_NOT_EXISTS);
        }
    }

    @Command(name="EventSubscriptionChange", inTypeDesc="Event consumer wants to subscribe to", outTypeDesc="Tango lib release")
    public int eventSubscriptionChange(String[] argin) {
        return 0;
    }

    @Command(name="RestartServer")
    public void restartServer() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        this.tangoExporter.unexportAll();
        this.tangoExporter.exportAll();
        this.xlogger.exit();
    }

    @Command(name="Kill")
    public void kill() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        new Thread(){

            @Override
            public void run() {
                AdminDevice.this.logger.error("kill server");
                try {
                    AdminDevice.this.tangoExporter.unexportAll();
                }
                catch (DevFailed devFailed) {
                }
                finally {
                    ORBManager.shutdown();
                    System.exit(-1);
                }
                AdminDevice.this.logger.error("everything has been shutdown normally");
            }
        }.start();
        this.xlogger.exit();
    }

    @Command(name="StartLogging")
    public void startLogging() {
        LoggingManager.getInstance().startAll();
    }

    @Command(name="StopLogging")
    public void stopLogging() {
        LoggingManager.getInstance().stopAll();
    }

    @Command(name="AddLoggingTarget", inTypeDesc="Str[i]=Device-name. Str[i+1]=Target-type::Target-name")
    public void addLoggingTarget(String[] argin) throws DevFailed {
        if (argin.length % 2 != 0) {
            throw DevFailedUtils.newDevFailed(INPUT_ERROR, "argin must be of even size");
        }
        for (int i = 0; i < argin.length - 1; i += 2) {
            String deviceName = argin[i];
            String[] config = argin[i + 1].split("::");
            if (config.length != 2) {
                throw DevFailedUtils.newDevFailed(INPUT_ERROR, "config must be of size 2: targetType::targetName");
            }
            if (config[0].equalsIgnoreCase("device")) {
                Class<?> className = null;
                for (DeviceClassBuilder deviceClass : this.classList) {
                    if (!deviceClass.containsDevice(deviceName)) continue;
                    className = deviceClass.getDeviceClass();
                    break;
                }
                if (className == null) continue;
                LoggingManager.getInstance().addDeviceAppender(config[1], className, deviceName);
                continue;
            }
            LoggingManager.getInstance().addFileAppender(config[1], deviceName);
        }
    }

    @Command(name="RemoveLoggingTarget", inTypeDesc="Str[i]=Device-name. Str[i+1]=Target-type::Target-name")
    public void removeLoggingTarget(String[] argin) throws DevFailed {
        if (argin.length % 2 != 0) {
            throw DevFailedUtils.newDevFailed(INPUT_ERROR, "argin must be of even size");
        }
        for (int i = 0; i < argin.length - 1; i += 2) {
            String deviceName = argin[i];
            String[] config = argin[i + 1].split("::");
            if (config.length != 2) {
                throw DevFailedUtils.newDevFailed(INPUT_ERROR, "config must be of size 2: targetType::targetName");
            }
            LoggingManager.getInstance().removeAppender(deviceName, config[0]);
        }
    }

    @Command(name="GetLoggingLevel", inTypeDesc="Device list", outTypeDesc="Lg[i]=Logging Level. Str[i]=Device name.")
    public DevVarLongStringArray getLoggingLevel(String[] deviceNames) {
        int[] levels = new int[deviceNames.length];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = LoggingManager.getInstance().getLoggingLevel(deviceNames[i]);
        }
        return new DevVarLongStringArray(levels, deviceNames);
    }

    @Command(name="GetLoggingTarget", inTypeDesc="Device name", outTypeDesc="Logging target list")
    public String[] getLoggingTarget(String deviceName) throws DevFailed {
        return LoggingManager.getInstance().getLoggingTarget(deviceName);
    }

    @Command(name="SetLoggingLevel", inTypeDesc="Lg[i]=Logging Level. Str[i]=Device name.")
    public void setLoggingLevel(DevVarLongStringArray dvlsa) throws DevFailed {
        String[] deviceNames = dvlsa.svalue;
        int[] levels = dvlsa.lvalue;
        if (deviceNames.length != levels.length) {
            throw DevFailedUtils.newDevFailed(INPUT_ERROR, "argin must be of same size for string and long ");
        }
        for (int i = 0; i < levels.length; ++i) {
            LoggingManager.getInstance().setLoggingLevel(deviceNames[i], levels[i]);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Command(name="PolledDevice", outTypeDesc="Polled device name list")
    public String[] getPolledDevice() {
        this.xlogger.entry(new Object[0]);
        LinkedHashSet<String> pollDevices = new LinkedHashSet<String>();
        for (DeviceClassBuilder deviceClass : this.classList) {
            for (DeviceImpl device : deviceClass.getDeviceImplList()) {
                for (CommandImpl command : device.getCommandList()) {
                    if (!command.isPolled()) continue;
                    pollDevices.add(device.getName());
                }
                for (AttributeImpl attribute : device.getAttributeList()) {
                    if (!attribute.isPolled()) continue;
                    pollDevices.add(device.getName());
                }
            }
        }
        this.xlogger.exit();
        return pollDevices.toArray(new String[pollDevices.size()]);
    }

    @Command(name="AddObjPolling", inTypeDesc="Lg[0]=Upd period. Str[0]=Device name. Str[1]=Object type. Str[2]=Object name")
    public void addPolling(DevVarLongStringArray dvlsa) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        if (dvlsa.svalue.length != 3 || dvlsa.lvalue.length != 1) {
            throw DevFailedUtils.newDevFailed("API_WrongNumberOfArgs", "Incorrect number of inout arguments");
        }
        String deviceName = dvlsa.svalue[0];
        String type = dvlsa.svalue[1];
        String polledObjectName = dvlsa.svalue[2];
        int pollPeriod = dvlsa.lvalue[0];
        this.logger.info("add polling for {}/{} {} with period {}", deviceName, polledObjectName, type, pollPeriod);
        for (DeviceClassBuilder deviceClass : this.classList) {
            if (!deviceClass.containsDevice(deviceName)) continue;
            DeviceImpl dev = deviceClass.getDeviceImpl(deviceName);
            if (type.equalsIgnoreCase(PolledObjectType.ATTRIBUTE.toString())) {
                dev.addAttributePolling(polledObjectName, pollPeriod);
                break;
            }
            dev.addCommandPolling(polledObjectName, pollPeriod);
            break;
        }
        this.xlogger.exit();
    }

    @Command(name="UpdObjPollingPeriod", inTypeDesc="Lg[0]=Upd period. Str[0]=Device name. Str[1]=Object type. Str[2]=Object name")
    public void updatePollingPeriod(DevVarLongStringArray dvlsa) throws DevFailed {
        this.addPolling(dvlsa);
    }

    @Command(name="RemObjPolling", inTypeDesc="Str[0]=Device name. Str[1]=Object type. Str[2]=Object name")
    public void removePolling(String[] devices) throws DevFailed {
        String[] attributes;
        this.xlogger.entry(new Object[0]);
        if (devices.length < 3) {
            throw DevFailedUtils.newDevFailed("API_WrongNumberOfArgs", "Incorrect number of inout arguments");
        }
        String deviceName = devices[0];
        String type = devices[1];
        for (String attribute : attributes = Arrays.copyOfRange(devices, 2, devices.length)) {
            for (DeviceClassBuilder deviceClass : this.classList) {
                if (!deviceClass.containsDevice(deviceName)) continue;
                DeviceImpl dev = deviceClass.getDeviceImpl(deviceName);
                if (type.equalsIgnoreCase(PolledObjectType.ATTRIBUTE.toString())) {
                    this.logger.debug("remove polling of attribute {} on device {}", (Object)attribute, (Object)deviceName);
                    dev.removeAttributePolling(attribute);
                    continue;
                }
                this.logger.debug("remove polling of command {} on device {}", (Object)attribute, (Object)deviceName);
                dev.removeCommandPolling(attribute);
            }
        }
        this.xlogger.exit();
    }

    @Command(name="StopPolling")
    public void stopPolling() {
        this.xlogger.entry(new Object[0]);
        for (DeviceClassBuilder deviceClass : this.classList) {
            for (DeviceImpl dev : deviceClass.getDeviceImplList()) {
                dev.stopPolling();
            }
        }
        this.status = "The device is ON\nThe polling is OFF";
        this.xlogger.exit();
    }

    @Command(name="StartPolling")
    public void startPolling() {
        this.xlogger.entry(new Object[0]);
        for (DeviceClassBuilder deviceClass : this.classList) {
            for (DeviceImpl dev : deviceClass.getDeviceImplList()) {
                dev.startPolling();
            }
        }
        this.status = "The device is ON\nThe polling is ON";
        this.xlogger.exit();
    }

    @Command(name="QueryWizardClassProperty", inTypeDesc="Class name", outTypeDesc="Class property list (name - description and default value)")
    public String[] queryClassProp(String className) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        ArrayList<String> names = new ArrayList<String>();
        for (DeviceClassBuilder deviceClass : this.classList) {
            if (!deviceClass.getClassName().equalsIgnoreCase(className)) continue;
            List<DeviceImpl> devices = deviceClass.getDeviceImplList();
            if (devices.size() <= 0) break;
            DeviceImpl dev = devices.get(0);
            List<ClassPropertyImpl> props = dev.getClassPropertyList();
            for (ClassPropertyImpl prop : props) {
                names.add(prop.getName());
                names.add(prop.getDescription());
                names.add("");
            }
        }
        this.xlogger.exit();
        return names.toArray(new String[names.size()]);
    }

    @Command(name="QueryWizardDevProperty", inTypeDesc="Class name", outTypeDesc="Device property list (name - description and default value)")
    public String[] queryDevProp(String className) {
        this.xlogger.entry(new Object[0]);
        ArrayList<String> names = new ArrayList<String>();
        for (DeviceClassBuilder deviceClass : this.classList) {
            if (!deviceClass.getClassName().equalsIgnoreCase(className)) continue;
            List<DeviceImpl> devices = deviceClass.getDeviceImplList();
            if (devices.size() <= 0) break;
            DeviceImpl dev = devices.get(0);
            List<DevicePropertyImpl> props = dev.getDevicePropertyList();
            for (DevicePropertyImpl prop : props) {
                names.add(prop.getName());
                names.add(prop.getDescription());
                if (prop.getDefaultValue().length == 0) {
                    names.add("");
                    continue;
                }
                names.add(prop.getDefaultValue()[0]);
            }
        }
        this.xlogger.exit(names);
        return names.toArray(new String[names.size()]);
    }

    @Command(name="ZmqEventSubscriptionChange", inTypeDesc="Events consumer wants to subscribe to", outTypeDesc="Str[0] = Heartbeat pub endpoint - Str[1] = Event pub endpoint - Lg[0] = Tango lib release - Lg[1] = Device IDL release")
    public DevVarLongStringArray zmqEventSubscriptionChange(String[] argin) throws DevFailed {
        DevVarLongStringArray returned;
        this.xlogger.entry(new Object[0]);
        if (argin.length == 1) {
            if (argin[0].equals("info")) {
                return EventManager.getInstance().getInfo();
            }
            throw DevFailedUtils.newDevFailed("API_WrongNumberOfArgs", "Command ZmqEventSubscriptionChange expect 4 input arguments");
        }
        if (argin.length < 4) {
            throw DevFailedUtils.newDevFailed("API_WrongNumberOfArgs", "Command ZmqEventSubscriptionChange expect 4 input arguments");
        }
        String deviceName = argin[0].toLowerCase(Locale.ENGLISH);
        String attributeName = argin[1].toLowerCase(Locale.ENGLISH);
        String eventTypeAndIDL = argin[3].toLowerCase(Locale.ENGLISH);
        Pattern p = Pattern.compile("idl[0-9]_[a-z]*");
        Matcher m = p.matcher(eventTypeAndIDL);
        if (m.matches()) {
            returned = this.subcribeIDLInEventString(eventTypeAndIDL, deviceName, attributeName);
        } else {
            int idlversion = 4;
            if (argin.length == 5) {
                idlversion = Integer.parseInt(argin[4]);
            }
            EventType eventType = EventType.getEvent(eventTypeAndIDL);
            this.logger.debug("Subscribe event for {}/{} with type {}", new Object[]{deviceName, attributeName, eventType});
            Pair<PipeImpl, AttributeImpl> result = this.findSubscribers(eventType, deviceName, attributeName);
            returned = this.subscribeEvent(eventType, deviceName, idlversion, result.getRight(), result.getLeft());
        }
        this.xlogger.exit();
        return returned;
    }

    @Command(name="EventConfirmSubscription")
    public void eventConfirmSubscription(String[] argin) throws DevFailed {
        this.xlogger.entry(Arrays.toString(argin));
        if (argin.length == 0 || argin.length % 3 != 0) {
            throw DevFailedUtils.newDevFailed("API_WrongNumberOfArgs", "must a modulo 3 length");
        }
        int eventNb = argin.length / 3;
        for (int i = 0; i < eventNb; ++i) {
            int idx = i * 3;
            String deviceName = argin[idx].toLowerCase(Locale.ENGLISH);
            String objName = argin[idx + 1].toLowerCase(Locale.ENGLISH);
            String eventTypeAndIDL = argin[idx + 2].toLowerCase(Locale.ENGLISH);
            this.subcribeIDLInEventString(eventTypeAndIDL, deviceName, objName);
            this.xlogger.exit();
        }
    }

    private DevVarLongStringArray subcribeIDLInEventString(String eventTypeAndIDL, String deviceName, String objName) throws DevFailed {
        String event = eventTypeAndIDL;
        int idlversion = 4;
        if (eventTypeAndIDL.contains("idl5_")) {
            idlversion = 5;
            event = eventTypeAndIDL.substring(eventTypeAndIDL.indexOf("_") + 1, eventTypeAndIDL.length());
        }
        EventType eventType = EventType.getEvent(event);
        this.logger.debug("event subscription/confirmation for {}, attribute/pipe {} with type {} and IDL {}", new Object[]{deviceName, objName, eventType, idlversion});
        Pair<PipeImpl, AttributeImpl> result = this.findSubscribers(eventType, deviceName, objName);
        return this.subscribeEvent(eventType, deviceName, idlversion, result.getRight(), result.getLeft());
    }

    private Pair<PipeImpl, AttributeImpl> findSubscribers(EventType eventType, String deviceName, String objName) throws DevFailed {
        DeviceImpl device = null;
        PipeImpl pipe = null;
        AttributeImpl attribute = null;
        for (DeviceClassBuilder deviceClass : this.classList) {
            for (DeviceImpl deviceImpl : deviceClass.getDeviceImplList()) {
                if (!deviceImpl.getName().toLowerCase(Locale.ENGLISH).equals(deviceName)) continue;
                if (eventType.equals((Object)EventType.INTERFACE_CHANGE_EVENT)) {
                    device = deviceImpl;
                    continue;
                }
                if (eventType.equals((Object)EventType.PIPE_EVENT)) {
                    for (PipeImpl pipeImpl : deviceImpl.getPipeList()) {
                        if (!pipeImpl.getName().toLowerCase(Locale.ENGLISH).equals(objName)) continue;
                        device = deviceImpl;
                        pipe = pipeImpl;
                    }
                    continue;
                }
                for (AttributeImpl attributeImpl : deviceImpl.getAttributeList()) {
                    if (!attributeImpl.getName().toLowerCase(Locale.ENGLISH).equals(objName)) continue;
                    if (attributeImpl.getBehavior() instanceof ForwardedAttribute) {
                        device = deviceImpl;
                        attribute = attributeImpl;
                        continue;
                    }
                    if (attributeImpl.isPolled()) {
                        EventManager.checkEventCriteria(attributeImpl, eventType);
                        device = deviceImpl;
                        attribute = attributeImpl;
                        continue;
                    }
                    boolean throwError = false;
                    switch (eventType) {
                        case ARCHIVE_EVENT: {
                            if (attributeImpl.isPushArchiveEvent()) break;
                            throwError = true;
                            break;
                        }
                        case CHANGE_EVENT: {
                            if (attributeImpl.isPushChangeEvent()) break;
                            throwError = true;
                            break;
                        }
                        case DATA_READY_EVENT: {
                            if (attributeImpl.isPushDataReady()) break;
                            throwError = true;
                            break;
                        }
                        case USER_EVENT: 
                        case ATT_CONF_EVENT: 
                        case INTERFACE_CHANGE_EVENT: {
                            break;
                        }
                        default: {
                            throwError = true;
                        }
                    }
                    if (throwError) {
                        throw DevFailedUtils.newDevFailed("API_AttrNotPolled", "The polling (necessary to send events) for the attribute " + objName + " is not started");
                    }
                    device = deviceImpl;
                    attribute = attributeImpl;
                }
            }
        }
        if (eventType.equals((Object)EventType.PIPE_EVENT)) {
            if (pipe == null) {
                throw DevFailedUtils.newDevFailed("API_AttrNotFound", "Pipe " + objName + " not found");
            }
        } else if (!eventType.equals((Object)EventType.INTERFACE_CHANGE_EVENT) && attribute == null) {
            throw DevFailedUtils.newDevFailed("API_AttrNotFound", "Attribute " + objName + " not found");
        }
        if (device == null) {
            throw DevFailedUtils.newDevFailed("API_DeviceNotFound", "Device " + deviceName + " not found");
        }
        return ImmutablePair.of(pipe, attribute);
    }

    private DevVarLongStringArray subscribeEvent(EventType eventType, String deviceName, int idlversion, AttributeImpl attribute, PipeImpl pipe) throws DevFailed {
        DevVarLongStringArray result = eventType.equals((Object)EventType.INTERFACE_CHANGE_EVENT) ? EventManager.getInstance().subscribe(deviceName) : (eventType.equals((Object)EventType.PIPE_EVENT) ? EventManager.getInstance().subscribe(deviceName, pipe) : EventManager.getInstance().subscribe(deviceName, attribute, eventType, idlversion));
        return result;
    }

    @Command(name="LockDevice", inTypeDesc="Str[0] = Device name. Lg[0] = Lock validity")
    public void lockDevice(DevVarLongStringArray argin) throws DevFailed {
        if (argin.svalue.length != 1 && argin.lvalue.length != 1) {
            throw DevFailedUtils.newDevFailed("API_WrongNumberOfArgs", "Incorrect number of inout arguments");
        }
        String deviceName = argin.svalue[0];
        int validity = argin.lvalue[0];
        this.logger.debug("locking {} with {}", (Object)deviceName, (Object)validity);
        if (deviceName.equalsIgnoreCase(ServerManager.getInstance().getAdminDeviceName())) {
            throw DevFailedUtils.newDevFailed("API_DeviceUnlockable", deviceName + " not lockable");
        }
        ClntIdent id = null;
        for (DeviceClassBuilder deviceClass : this.classList) {
            if (!deviceClass.containsDevice(ServerManager.getInstance().getAdminDeviceName())) continue;
            id = deviceClass.getDeviceImpl(ServerManager.getInstance().getAdminDeviceName()).getClientIdentity();
            break;
        }
        int nbClasses = 0;
        for (DeviceClassBuilder deviceClass : this.classList) {
            if (deviceClass.containsDevice(deviceName)) {
                deviceClass.getDeviceImpl(deviceName).lock(validity, id, ServerRequestInterceptor.getInstance().getGiopHostAddress());
                this.xlogger.exit();
                break;
            }
            ++nbClasses;
        }
        if (nbClasses == this.classList.size()) {
            throw DevFailedUtils.newDevFailed("API_DeviceNotFound", deviceName + DOES_NOT_EXISTS);
        }
    }

    @Command(name="UnLockDevice", inTypeDesc="Str[x] = Device name(s). Lg[0] = Force flag", outTypeDesc="Device global lock counter")
    public int unlockDevice(DevVarLongStringArray argin) throws DevFailed {
        Object[] deviceNames = argin.svalue;
        boolean isForced = false;
        if (argin.lvalue[0] == 1) {
            isForced = true;
        }
        this.logger.debug("unlocking {} - force = {}", (Object)Arrays.toString(deviceNames), (Object)isForced);
        for (Object deviceName : deviceNames) {
            int nbClasses = 0;
            for (DeviceClassBuilder deviceClass : this.classList) {
                if (deviceClass.containsDevice((String)deviceName)) {
                    deviceClass.getDeviceImpl((String)deviceName).unLock(isForced);
                    this.xlogger.exit();
                    break;
                }
                ++nbClasses;
            }
            if (nbClasses != this.classList.size()) continue;
            throw DevFailedUtils.newDevFailed("API_DeviceNotFound", (String)deviceName + DOES_NOT_EXISTS);
        }
        return 0;
    }

    @Command(name="ReLockDevices", inTypeDesc="Device(s) name")
    public void relockDevice(String[] deviceNames) throws DevFailed {
        for (String deviceName : deviceNames) {
            this.logger.debug("re locking {} ", (Object)deviceName);
            if (deviceName.equalsIgnoreCase(ServerManager.getInstance().getAdminDeviceName())) {
                throw DevFailedUtils.newDevFailed("API_DeviceUnlockable", deviceName + " not lockable");
            }
            for (DeviceClassBuilder deviceClass : this.classList) {
                if (!deviceClass.containsDevice(deviceName)) continue;
                deviceClass.getDeviceImpl(deviceName).relock();
                this.xlogger.exit();
            }
        }
    }

    @Command(name="DevLockStatus", inTypeDesc="Device name", outTypeDesc="Device locking status")
    public DevVarLongStringArray devLockStatus(String deviceName) throws DevFailed {
        DevVarLongStringArray result = null;
        int nbClasses = 0;
        String fullDeviceName = TangoUtil.getfullNameForDevice(deviceName);
        for (DeviceClassBuilder deviceClass : this.classList) {
            if (deviceClass.containsDevice(fullDeviceName)) {
                result = deviceClass.getDeviceImpl(fullDeviceName).getLockStatus();
                this.logger.debug("DevLockStatus {} {}", (Object)Arrays.toString(result.lvalue), (Object)Arrays.toString(result.svalue));
                this.xlogger.exit();
                break;
            }
            ++nbClasses;
        }
        if (nbClasses == this.classList.size()) {
            throw DevFailedUtils.newDevFailed("API_DeviceNotFound", deviceName + DOES_NOT_EXISTS);
        }
        return result;
    }

    public void setPollingThreadsPoolSize(int pollingThreadsPoolSize) {
        this.pollingThreadsPoolSize = pollingThreadsPoolSize;
    }

    @Override
    public String getServerName() {
        return "";
    }

    @Override
    @Attribute
    public String getLastRequest() {
        return this.tangoStats.getLastRequest();
    }

    @Override
    @Attribute
    public String getMaxRequest() {
        return this.tangoStats.getMaxRequest();
    }

    @Override
    @Attribute
    public long getRequestsPerSecond() {
        return this.tangoStats.getRequestsPerSecond();
    }

    @Override
    @Attribute
    public long getLastRequestDuration() {
        return this.tangoStats.getLastRequestDuration();
    }

    @Override
    @Attribute
    public long getMaxRequestDuration() {
        return this.tangoStats.getMaxRequestDuration();
    }

    @Override
    @Attribute
    public long getAverageRequestDuration() {
        return this.tangoStats.getAverageRequestDuration();
    }

    @Override
    @Attribute
    public long getMinRequestDuration() {
        return this.tangoStats.getMinRequestDuration();
    }

    @Override
    @Command
    public void resetStats() {
        this.tangoStats.resetStats();
    }

    @Override
    @Attribute
    public long getErrorNr() {
        return this.tangoStats.getErrorNr();
    }

    @Override
    public long getMaxRequestsPerSecond() {
        return this.tangoStats.getMaxRequestsPerSecond();
    }

    @Override
    public long getAverageRequestsPerSecond() {
        return this.tangoStats.getAverageRequestsPerSecond();
    }

    @Override
    public long getMinRequestsPerSecond() {
        return this.tangoStats.getMinRequestsPerSecond();
    }
}

