/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database;

import fr.esrf.Tango.DevFailed;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.tango.client.database.DeviceExportInfo;
import org.tango.client.database.DeviceImportInfo;
import org.tango.client.database.ITangoDB;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

public final class FileTangoDB
implements ITangoDB {
    private static final String ERROR_PARSING_FILE_PROP = "error parsing file prop";
    private final Map<String, Map<String, String[]>> deviceProperties = new HashMap<String, Map<String, String[]>>();
    private final Map<String, Map<String, String[]>> classProperties = new HashMap<String, Map<String, String[]>>();
    private final Map<String, Map<String, String[]>> attributeProperties = new HashMap<String, Map<String, String[]>>();
    private final String[] devices;
    private final String className;

    FileTangoDB(String[] devices, String className) {
        this.devices = Arrays.copyOf(devices, devices.length);
        this.className = className;
    }

    FileTangoDB(File propertiesFiles, String[] devices, String className) throws DevFailed {
        this.devices = Arrays.copyOf(devices, devices.length);
        this.className = className;
        this.loadFileProperties(propertiesFiles);
    }

    @Override
    public void exportDevice(DeviceExportInfo info) throws DevFailed {
    }

    @Override
    public String[] getInstanceNameList(String dsExecName) throws DevFailed {
        return new String[0];
    }

    @Override
    public DeviceImportInfo importDevice(String toBeImported) throws DevFailed {
        return new DeviceImportInfo("", false, "", "", 0);
    }

    @Override
    public void unexportServer(String serverName) throws DevFailed {
    }

    @Override
    public String[] getDeviceList(String serverName, String className) throws DevFailed {
        String[] result = new String[]{};
        if (this.className.equalsIgnoreCase(className)) {
            result = Arrays.copyOf(this.devices, this.devices.length);
        }
        return result;
    }

    @Override
    public Map<String, String[]> getDeviceProperties(String name, String ... propertyNames) throws DevFailed {
        Map<Object, Object> result;
        Map<String, String[]> prop = this.deviceProperties.get(name);
        if (prop == null) {
            result = new HashMap();
        } else if (propertyNames.length == 0) {
            result = prop;
        } else {
            result = new HashMap();
            for (String propertyName : propertyNames) {
                String[] props = prop.get(propertyName);
                if (props == null) {
                    result.put(propertyName, new String[0]);
                    continue;
                }
                result.put(propertyName, props);
            }
        }
        return result;
    }

    @Override
    public void setDeviceProperties(String deviceName, Map<String, String[]> properties) throws DevFailed {
        if (this.deviceProperties.containsKey(deviceName)) {
            this.deviceProperties.get(deviceName).putAll(properties);
        } else {
            this.deviceProperties.put(deviceName, properties);
        }
    }

    @Override
    public Map<String, String[]> getClassProperties(String name, String ... propertyNames) throws DevFailed {
        Map<String, String[]> prop = this.classProperties.get(name);
        HashMap<String, String[]> result = new HashMap();
        if (prop == null) {
            result = new HashMap();
        } else if (propertyNames.length == 0) {
            result = prop;
        } else {
            for (String propertyName : propertyNames) {
                String[] props = prop.get(propertyName);
                if (props == null) {
                    result.put(propertyName, new String[0]);
                    continue;
                }
                result.put(propertyName, props);
            }
        }
        return result;
    }

    @Override
    public void setClassProperties(String name, Map<String, String[]> properties) throws DevFailed {
        if (this.classProperties.containsKey(name)) {
            this.classProperties.get(name).putAll(properties);
        } else {
            this.classProperties.put(name, properties);
        }
    }

    @Override
    public Map<String, String[]> getAttributeProperties(String deviceName, String attributeName) throws DevFailed {
        Map<String, String[]> map = this.attributeProperties.get(deviceName + "/" + attributeName);
        if (map == null) {
            map = new HashMap<String, String[]>();
        }
        return map;
    }

    @Override
    public void setAttributeProperties(String deviceName, String attributeName, Map<String, String[]> properties) throws DevFailed {
        Map<String, String[]> map = this.attributeProperties.get(deviceName + "/" + attributeName);
        if (map == null) {
            this.attributeProperties.put(deviceName + "/" + attributeName, properties);
        } else {
            map.putAll(properties);
        }
    }

    private void loadFileProperties(File propertiesFiles) throws DevFailed {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(propertiesFiles));
            System.out.println("loading file " + propertiesFiles);
            String previousLine = "";
            String propertyName = "";
            String className = "";
            String deviceName = "";
            while (in.ready()) {
                String[] array;
                Map<String, String[]> props;
                String line = in.readLine();
                if (line == null) {
                    break;
                }
                if ((line = line.trim()).startsWith("# ---")) {
                    deviceName = line.split("# ---")[1].trim().split("properties")[0].trim();
                }
                if (!deviceName.isEmpty() && line.startsWith(deviceName)) {
                    Map<Object, Object> props2;
                    String prop = line.split("->")[1].trim().split(",\\\\")[0];
                    propertyName = prop.substring(0, prop.indexOf(58));
                    String propertyValue = prop.substring(prop.indexOf(58) + 1).trim();
                    if (propertyValue.startsWith("\"") && propertyValue.endsWith("\"")) {
                        propertyValue = propertyValue.substring(1, propertyValue.length() - 1);
                    }
                    if (this.deviceProperties.containsKey(deviceName)) {
                        props2 = this.deviceProperties.get(deviceName);
                        if (props2.containsKey(propertyName)) {
                            ArrayUtils.add((Object[])props2.get(propertyName), propertyValue);
                        } else {
                            props2.put(propertyName, new String[]{propertyValue});
                        }
                    } else {
                        props2 = new HashMap<String, String[]>();
                        props2.put(propertyName, new String[]{propertyValue});
                        this.deviceProperties.put(deviceName, props2);
                    }
                    previousLine = line;
                    continue;
                }
                if (line.startsWith("CLASS")) {
                    Map<Object, Object> props3;
                    String[] split = line.split("->");
                    className = split[0].split("/")[1];
                    String prop = split[1].trim().split(",\\\\")[0];
                    propertyName = prop.substring(0, prop.indexOf(58));
                    String propertyValue = prop.substring(prop.indexOf(58) + 1).trim();
                    if (propertyValue.startsWith("\"") && propertyValue.endsWith("\"")) {
                        propertyValue = propertyValue.substring(1, propertyValue.length() - 1);
                    }
                    if (this.classProperties.containsKey(className)) {
                        props3 = this.classProperties.get(className);
                        if (props3.containsKey(propertyName)) {
                            ArrayUtils.add((Object[])props3.get(propertyName), propertyValue);
                        } else {
                            props3.put(propertyName, new String[]{propertyValue});
                        }
                    } else {
                        props3 = new HashMap<String, String[]>();
                        props3.put(propertyName, new String[]{propertyValue});
                        this.classProperties.put(className, props3);
                    }
                    previousLine = line;
                    continue;
                }
                if (line.startsWith("#") || line.isEmpty() || !previousLine.endsWith(",\\") || deviceName.isEmpty() && className.isEmpty()) continue;
                String propertyValue = line;
                if (propertyValue.endsWith(",\\")) {
                    propertyValue = line.substring(0, line.length() - 2);
                }
                if (propertyValue.startsWith("\"") && propertyValue.endsWith("\"")) {
                    propertyValue = propertyValue.substring(1, propertyValue.length() - 1);
                }
                if (previousLine.startsWith(deviceName)) {
                    if (this.deviceProperties.containsKey(deviceName)) {
                        props = this.deviceProperties.get(deviceName);
                        if (props.containsKey(propertyName)) {
                            array = ArrayUtils.add((Object[])props.get(propertyName), propertyValue);
                            props.put(propertyName, array);
                            continue;
                        }
                        throw DevFailedUtils.newDevFailed(ERROR_PARSING_FILE_PROP);
                    }
                    throw DevFailedUtils.newDevFailed(ERROR_PARSING_FILE_PROP);
                }
                if (!previousLine.startsWith("CLASS")) continue;
                if (this.classProperties.containsKey(className)) {
                    props = this.classProperties.get(className);
                    if (props.containsKey(propertyName)) {
                        array = ArrayUtils.add((Object[])props.get(propertyName), propertyValue);
                        props.put(propertyName, array);
                        continue;
                    }
                    throw DevFailedUtils.newDevFailed(ERROR_PARSING_FILE_PROP);
                }
                throw DevFailedUtils.newDevFailed(ERROR_PARSING_FILE_PROP);
            }
        }
        catch (IOException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void deleteDeviceProperty(String deviceName, String propertyName) throws DevFailed {
        Map<String, String[]> props = this.deviceProperties.get(deviceName);
        if (props != null) {
            props.remove(propertyName);
        }
    }

    @Override
    public void loadCache(String serverName, String hostName) {
    }

    @Override
    public void clearCache() {
    }

    @Override
    public String getAccessDeviceName() throws DevFailed {
        return "";
    }

    @Override
    public void deleteAttributeProperties(String deviceName, String ... attributeNames) throws DevFailed {
        if (attributeNames == null || attributeNames.length == 0) {
            for (String attributeName : this.attributeProperties.keySet()) {
                if (!TangoUtil.getfullDeviceNameForAttribute(attributeName).equalsIgnoreCase(deviceName)) continue;
                this.attributeProperties.remove(attributeName);
            }
        } else {
            for (String attributeName : attributeNames) {
                if (!this.attributeProperties.containsKey(deviceName + "/" + attributeName)) continue;
                this.attributeProperties.remove(deviceName + "/" + attributeName);
            }
        }
    }

    @Override
    public String[] getPossibleTangoHosts() {
        return new String[]{"nodb"};
    }

    @Override
    public String getFreeProperty(String name, String propertyName) {
        return "";
    }

    @Override
    public Map<String, String[]> getDevicePipeProperties(String deviceName, String pipeName) throws DevFailed {
        return null;
    }

    @Override
    public void setDevicePipeProperties(String deviceName, String pipeName, Map<String, String[]> properties) throws DevFailed {
    }

    @Override
    public Map<String, String[]> getClassPipeProperties(String className, String pipeName) throws DevFailed {
        return null;
    }

    @Override
    public void setClassPipeProperties(String className, String pipeName, Map<String, String[]> properties) throws DevFailed {
    }

    @Override
    public void deleteDevicePipeProperties(String deviceName, String ... pipeNames) throws DevFailed {
    }
}

