/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database;

import fr.esrf.Tango.DevFailed;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.client.database.DeviceExportInfo;
import org.tango.client.database.DeviceImportInfo;
import org.tango.client.database.ITangoDB;
import org.tango.client.database.cache.DatabaseCache;
import org.tango.client.database.cache.ICachableDatabase;
import org.tango.client.database.cache.NoCacheDatabase;
import org.tango.utils.DevFailedUtils;

public final class Database
implements ITangoDB {
    private final Logger logger = LoggerFactory.getLogger(Database.class);
    private final fr.esrf.TangoApi.Database database;
    private ICachableDatabase cache;

    Database(String host, String port) throws DevFailed {
        this.database = new fr.esrf.TangoApi.Database(host, port);
        NoCacheDatabase noCache = new NoCacheDatabase(host, port);
        try {
            DatabaseCache tmp = new DatabaseCache(this.database, noCache);
            if (tmp.isCacheAvailable()) {
                this.cache = tmp;
            } else {
                this.logger.warn("database cache version {} not supported, please install it to have better performance", (Object)tmp.getVersion());
                this.cache = noCache;
            }
        }
        catch (DevFailed e) {
            this.logger.error("error loading db cache, {} ", (Object)DevFailedUtils.toString(e));
            this.cache = noCache;
        }
        catch (Exception e) {
            this.logger.error("error loading db cache", e);
            this.cache = noCache;
        }
    }

    @Override
    public void exportDevice(DeviceExportInfo info) throws DevFailed {
        this.cache.exportDevice(info);
    }

    @Override
    public String[] getInstanceNameList(String dsExecName) throws DevFailed {
        return this.cache.getInstanceNameList(dsExecName);
    }

    @Override
    public DeviceImportInfo importDevice(String toBeImported) throws DevFailed {
        return this.cache.importDevice(toBeImported);
    }

    @Override
    public void unexportServer(String serverName) throws DevFailed {
        this.cache.unexportServer(serverName);
    }

    @Override
    public String[] getDeviceList(String serverName, String className) throws DevFailed {
        return this.cache.getDeviceList(serverName, className);
    }

    @Override
    public Map<String, String[]> getDeviceProperties(String name, String ... propertyNames) throws DevFailed {
        return this.cache.getDeviceProperties(name, propertyNames);
    }

    @Override
    public void setDeviceProperties(String deviceName, Map<String, String[]> properties) throws DevFailed {
        this.cache.setDeviceProperties(deviceName, properties);
    }

    @Override
    public Map<String, String[]> getClassProperties(String name, String ... propertyNames) throws DevFailed {
        return this.cache.getClassProperties(name, propertyNames);
    }

    @Override
    public void setClassProperties(String name, Map<String, String[]> properties) throws DevFailed {
        this.cache.setClassProperties(name, properties);
    }

    @Override
    public Map<String, String[]> getAttributeProperties(String deviceName, String attributeName) throws DevFailed {
        return this.cache.getAttributeProperties(deviceName, attributeName);
    }

    @Override
    public void setAttributeProperties(String deviceName, String attributeName, Map<String, String[]> properties) throws DevFailed {
        this.cache.setAttributeProperties(deviceName, attributeName, properties);
    }

    @Override
    public void deleteDeviceProperty(String deviceName, String propertyName) throws DevFailed {
        this.cache.deleteDeviceProperty(deviceName, propertyName);
    }

    @Override
    public void loadCache(String serverName, String hostName) throws DevFailed {
        this.cache.loadCache(serverName, hostName);
    }

    @Override
    public String getAccessDeviceName() throws DevFailed {
        return this.cache.getAccessDeviceName();
    }

    @Override
    public void clearCache() {
        this.cache.clearCache();
    }

    @Override
    public void deleteAttributeProperties(String deviceName, String ... attributeNames) throws DevFailed {
        this.cache.deleteAttributeProperties(deviceName, attributeNames);
    }

    @Override
    public String[] getPossibleTangoHosts() throws DevFailed {
        return this.cache.getPossibleTangoHosts();
    }

    @Override
    public String getFreeProperty(String name, String propertyName) throws DevFailed {
        return this.cache.getFreeProperty(name, propertyName);
    }

    @Override
    public Map<String, String[]> getDevicePipeProperties(String deviceName, String pipeName) throws DevFailed {
        return this.cache.getDevicePipeProperties(deviceName, pipeName);
    }

    @Override
    public void setDevicePipeProperties(String deviceName, String pipeName, Map<String, String[]> properties) throws DevFailed {
        this.cache.setDevicePipeProperties(deviceName, pipeName, properties);
    }

    @Override
    public Map<String, String[]> getClassPipeProperties(String className, String pipeName) throws DevFailed {
        return this.cache.getClassPipeProperties(className, pipeName);
    }

    @Override
    public void setClassPipeProperties(String className, String pipeName, Map<String, String[]> properties) throws DevFailed {
        this.cache.setClassPipeProperties(className, pipeName, properties);
    }

    @Override
    public void deleteDevicePipeProperties(String deviceName, String ... pipeNames) throws DevFailed {
        this.cache.deleteDevicePipeProperties(deviceName, pipeNames);
    }
}

