/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.remoting.jmx;

import java.util.HashSet;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.nanocontainer.remoting.jmx.DynamicMBeanComponentProvider;
import org.nanocontainer.remoting.jmx.DynamicMBeanProvider;
import org.nanocontainer.remoting.jmx.JMXRegistrationException;
import org.nanocontainer.remoting.jmx.JMXRegistrationInfo;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractPicoVisitor;

public class JMXVisitor
extends AbstractPicoVisitor {
    private final DynamicMBeanProvider[] mBeanProviders;
    private final MBeanServer mBeanServer;
    private final Set visited;
    private final Set registeredInfo;
    private PicoContainer picoContainer;

    public JMXVisitor(MBeanServer server) {
        this(server, new DynamicMBeanProvider[]{new DynamicMBeanComponentProvider()});
    }

    public JMXVisitor(MBeanServer server, DynamicMBeanProvider[] providers) {
        if (server == null) {
            throw new NullPointerException("MBeanServer may not be null");
        }
        if (providers == null) {
            throw new NullPointerException("DynamicMBeanProvider[] may not be null");
        }
        if (providers.length == 0) {
            throw new IllegalArgumentException("DynamicMBeanProvider[] may not be empty");
        }
        this.mBeanServer = server;
        this.mBeanProviders = providers;
        this.visited = new HashSet();
        this.registeredInfo = new HashSet();
    }

    public Object traverse(Object node) {
        super.traverse(node);
        this.picoContainer = null;
        HashSet set = new HashSet(this.registeredInfo);
        this.registeredInfo.clear();
        return set;
    }

    public void visitContainer(PicoContainer pico) {
        this.checkTraversal();
        this.picoContainer = pico;
        this.visited.clear();
    }

    public void visitComponentAdapter(ComponentAdapter componentAdapter) {
        this.checkTraversal();
        if (this.picoContainer == null) {
            throw new JMXRegistrationException("Cannot start JMXVisitor traversal with a ComponentAdapter");
        }
        if (!this.visited.contains(componentAdapter.getComponentKey())) {
            this.visited.add(componentAdapter.getComponentKey());
            for (int i = 0; i < this.mBeanProviders.length; ++i) {
                DynamicMBeanProvider provider = this.mBeanProviders[i];
                JMXRegistrationInfo info = provider.provide(this.picoContainer, componentAdapter);
                if (info == null) continue;
                this.registeredInfo.add(this.register(info.getMBean(), info.getObjectName()));
                break;
            }
        }
    }

    public void visitParameter(Parameter parameter) {
        this.checkTraversal();
    }

    protected ObjectInstance register(DynamicMBean dynamicMBean, ObjectName objectName) throws JMXRegistrationException {
        try {
            return this.mBeanServer.registerMBean(dynamicMBean, objectName);
        }
        catch (JMException e) {
            throw new JMXRegistrationException("Unable to register MBean to MBean Server", e);
        }
    }
}

