/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.remoting.ejb;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.nanocontainer.remoting.ejb.ServiceUnavailableException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class EJBClientComponentAdapter
extends AbstractComponentAdapter {
    private final Object m_proxy;

    public EJBClientComponentAdapter(String name, Class type) throws ClassNotFoundException {
        this(name, type, null, false);
    }

    public EJBClientComponentAdapter(String name, Class type, ProxyFactory factory) throws ClassNotFoundException {
        this(name, type, null, false, factory);
    }

    public EJBClientComponentAdapter(String name, Class type, Hashtable environment, boolean earlyBinding) throws ClassNotFoundException {
        this(name, type, type.getClassLoader().loadClass(type.getName() + "Home"), environment, earlyBinding);
    }

    public EJBClientComponentAdapter(String name, Class type, Hashtable environment, boolean earlyBinding, ProxyFactory factory) throws ClassNotFoundException {
        this(name, type, type.getClassLoader().loadClass(type.getName() + "Home"), environment, earlyBinding, factory);
    }

    public EJBClientComponentAdapter(String name, Class type, Class homeInterface, Hashtable environment, boolean earlyBinding) {
        this(name, type, homeInterface, environment, earlyBinding, new StandardProxyFactory());
    }

    public EJBClientComponentAdapter(String name, Class type, Class homeInterface, Hashtable environment, boolean earlyBinding, ProxyFactory factory) {
        super(name, type);
        if (!EJBHome.class.isAssignableFrom(homeInterface)) {
            throw new AssignabilityRegistrationException(EJBHome.class, homeInterface);
        }
        if (!EJBObject.class.isAssignableFrom(type)) {
            throw new AssignabilityRegistrationException(EJBObject.class, type);
        }
        if (!type.isInterface()) {
            throw new PicoIntrospectionException(type.getName() + " must be an interface");
        }
        EJBClientInvoker invoker = new EJBClientInvoker(name, type, homeInterface, environment);
        this.m_proxy = factory.createProxy(new Class[]{type}, invoker);
        if (earlyBinding) {
            this.m_proxy.hashCode();
        }
    }

    public Object getComponentInstance(PicoContainer pico) {
        return this.m_proxy;
    }

    public void verify(PicoContainer pico) throws UnsatisfiableDependenciesException {
    }

    private static final class EJBClientInvoker
    implements Invoker {
        private final String m_name;
        private final Class m_type;
        private final Class m_home;
        private final Hashtable m_environment;
        private transient Object m_stub;

        private EJBClientInvoker(String name, Class type, Class home, Hashtable environment) {
            this.m_name = name;
            this.m_type = type;
            this.m_home = home;
            this.m_environment = environment;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (this.m_stub == null) {
                    this.m_stub = this.bind();
                }
                return method.invoke(this.m_stub, args);
            }
            catch (InvocationTargetException e) {
                this.m_stub = null;
                Throwable target = e.getTargetException();
                if (target instanceof ConnectException || target instanceof NoSuchObjectException) {
                    throw new ServiceUnavailableException("EJB instance named " + this.m_name + " no longer available", target);
                }
                throw target;
            }
            catch (Throwable t) {
                this.m_stub = null;
                throw t;
            }
        }

        private Object bind() {
            try {
                InitialContext context = new InitialContext(this.m_environment);
                Object ref = context.lookup(this.m_name);
                Object proxy = PortableRemoteObject.narrow((Object)ref, (Class)this.m_home);
                Class<?> homeClass = proxy.getClass();
                Method create = homeClass.getMethod("create", null);
                if (this.m_type.isAssignableFrom(create.getReturnType())) {
                    return create.invoke(proxy, null);
                }
                throw new PicoIntrospectionException("Wrong return type of EJBHome implementation", new ClassCastException(create.getReturnType().getName()));
            }
            catch (SecurityException e) {
                throw new PicoIntrospectionException("Security Exception occured accessing create method of home interface of " + this.m_name, e);
            }
            catch (NoSuchMethodException e) {
                throw new PicoIntrospectionException("Home interface of " + this.m_name + " has no create method", e);
            }
            catch (NameNotFoundException e) {
                throw new ServiceUnavailableException("EJB named " + this.m_name + " not found", e);
            }
            catch (NamingException e) {
                Throwable rootCause = e.getRootCause();
                if (rootCause != null && (rootCause instanceof SocketTimeoutException || rootCause instanceof NoSuchObjectException)) {
                    throw new ServiceUnavailableException("Timeout occured creating EJB named " + this.m_name, e);
                }
                throw new PicoInitializationException("InitialContext has no EJB named " + this.m_name, e);
            }
            catch (IllegalAccessException e) {
                throw new PicoInitializationException("Cannot access default constructor for " + this.m_name, e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                if (e.getTargetException() instanceof Error) {
                    throw (Error)e.getTargetException();
                }
                throw new PicoInvocationTargetInitializationException(e.getTargetException());
            }
        }
    }
}

