/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.jacorb.transaction.CoordinatorImpl;
import org.jacorb.transaction.Timer;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.TransactionFactoryPOA;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.slf4j.Logger;

public class TransactionService
extends TransactionFactoryPOA {
    private static boolean initialized = false;
    private static TransactionService factory;
    private static TransactionFactory fact_ref;
    private static CoordinatorImpl[] coordinators;
    private static Timer timer;
    private static int trans_id;
    private static POA poa;
    private static Logger logger;

    static Timer get_timer() {
        return timer;
    }

    public static boolean is_initialized() {
        return initialized;
    }

    public static TransactionFactory get_reference() {
        return fact_ref;
    }

    static void release_coordinator(int hash_code) {
        TransactionService.coordinators[hash_code] = null;
    }

    private int find_free() {
        for (int i = 0; i < coordinators.length; ++i) {
            if (coordinators[i] != null) continue;
            return i;
        }
        throw new INTERNAL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Control create(int time_out) {
        ++trans_id;
        CoordinatorImpl[] coordinatorImplArray = coordinators;
        synchronized (coordinators) {
            int ix = this.find_free();
            TransactionService.coordinators[ix] = new CoordinatorImpl(poa, trans_id, ix, time_out);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return coordinators[ix]._get_control();
        }
    }

    @Override
    public Control recreate(PropagationContext ctx) {
        throw new NO_IMPLEMENT();
    }

    public static void start(POA _poa, int max_of_trans) {
        if (initialized) {
            throw new INTERNAL();
        }
        try {
            poa = _poa;
            factory = new TransactionService();
            fact_ref = TransactionFactoryHelper.narrow(poa.servant_to_reference(factory));
            coordinators = new CoordinatorImpl[max_of_trans];
            for (int i = 0; i < coordinators.length; ++i) {
                TransactionService.coordinators[i] = null;
            }
            timer = new Timer(max_of_trans);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        initialized = true;
    }

    public static void main(String[] args) {
        ORB orb = ORB.init(args, null);
        logger = ((org.jacorb.orb.ORB)orb).getConfiguration().getLogger("org.jacorb.tx_service");
        try {
            POA poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            TransactionService transactionService = new TransactionService();
            TransactionService.start(poa, 10);
            if (args.length == 1) {
                PrintWriter ps = new PrintWriter(new FileOutputStream(new File(args[0])));
                ps.println(orb.object_to_string(transactionService.get_reference()));
                ps.close();
            } else {
                NamingContextExt nc = NamingContextExtHelper.narrow(orb.resolve_initial_references("NameService"));
                NameComponent[] name = new NameComponent[]{new NameComponent("TransactionService", "service")};
                nc.bind(name, transactionService.get_reference());
            }
            if (logger.isInfoEnabled()) {
                logger.info("TransactionService up");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        orb.run();
    }

    static {
        trans_id = 0;
    }
}

