/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.util.PropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.INTERNAL;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.TimeBase.TimeTHelper;

public class QoSPropertySet
extends PropertySet {
    public static final int CHANNEL_QOS = 0;
    public static final int ADMIN_QOS = 1;
    public static final int PROXY_QOS = 2;
    private Property[] defaultChannelQoS_;
    private Property[] defaultAdminQoS_;
    private static final Set<String> sValidChannelQoSNames_;
    private static final Set<String> sValidAdminQoSNames_;
    private static final Set<String> sValidProxyQoSNames_;
    private static final Any connectionReliabilityLow_;
    private static final Any connectionReliabilityHigh_;
    private static final Any eventReliabilityLow_;
    private static final Any eventReliabilityHigh_;
    private static Any orderPolicyLow_;
    private static Any orderPolicyHigh_;
    private static Any discardPolicyLow_;
    private static Any discardPolicyHigh_;
    private static Any priorityLow_;
    private static Any priorityDefault_;
    private static Any priorityHigh_;
    private Any maxEventsPerConsumerLow_;
    private Any maxEventsPerConsumerDefault_;
    private Any maxEventsPerConsumerHigh_;
    private Any timeoutDefault_;
    private static final Any trueAny;
    private static final Any falseAny;
    private final Set<String> validNames_;

    private void configure(Configuration conf) {
        int _maxBatchSize;
        int _maxEventsPerConsumerDefault;
        try {
            _maxEventsPerConsumerDefault = conf.getAttributeAsInteger("jacorb.notification.max_events_per_consumer", 100);
            _maxBatchSize = conf.getAttributeAsInteger("jacorb.notification.max_batch_size", 1);
        }
        catch (ConfigurationException ex) {
            this.logger_.error("Error configuring QoSPropertySet ", ex);
            throw new INTERNAL("Error configuring QoSPropertySet " + ex);
        }
        this.maxEventsPerConsumerDefault_ = sORB.create_any();
        this.maxEventsPerConsumerDefault_.insert_long(_maxEventsPerConsumerDefault);
        this.maxEventsPerConsumerHigh_ = sORB.create_any();
        this.maxEventsPerConsumerLow_ = sORB.create_any();
        this.maxEventsPerConsumerLow_.insert_long(0);
        this.maxEventsPerConsumerHigh_.insert_long(Integer.MAX_VALUE);
        this.timeoutDefault_ = sORB.create_any();
        TimeTHelper.insert(this.timeoutDefault_, 0L);
        Any _isStartTimeSupportedDefault = sORB.create_any();
        boolean _isStartTimeSupported = conf.getAttribute("jacorb.notification.start_time_supported", "on").equalsIgnoreCase("on");
        _isStartTimeSupportedDefault.insert_boolean(_isStartTimeSupported);
        Any _isStopTimeSupportedDefault = sORB.create_any();
        boolean _isStopTimeSupported = conf.getAttribute("jacorb.notification.stop_time_supported", "on").equalsIgnoreCase("on");
        _isStopTimeSupportedDefault.insert_boolean(_isStopTimeSupported);
        Any _maxBatchSizeDefault = sORB.create_any();
        _maxBatchSizeDefault.insert_long(_maxBatchSize);
        this.defaultChannelQoS_ = new Property[]{new Property("EventReliability", eventReliabilityLow_), new Property("ConnectionReliability", connectionReliabilityLow_), new Property("Priority", priorityDefault_), new Property("MaxEventsPerConsumer", this.maxEventsPerConsumerDefault_), new Property("Timeout", this.timeoutDefault_), new Property("StartTimeSupported", _isStartTimeSupportedDefault), new Property("StopTimeSupported", _isStartTimeSupportedDefault), new Property("MaximumBatchSize", _maxBatchSizeDefault)};
        this.defaultAdminQoS_ = new Property[]{new Property("ConnectionReliability", connectionReliabilityLow_), new Property("Priority", priorityDefault_), new Property("MaxEventsPerConsumer", this.maxEventsPerConsumerDefault_), new Property("Timeout", this.timeoutDefault_), new Property("StartTimeSupported", _isStartTimeSupportedDefault), new Property("StopTimeSupported", _isStartTimeSupportedDefault), new Property("MaximumBatchSize", _maxBatchSizeDefault)};
    }

    public QoSPropertySet(Configuration configuration, int type) {
        this.configure(configuration);
        switch (type) {
            case 0: {
                this.validNames_ = sValidChannelQoSNames_;
                this.set_qos(this.defaultChannelQoS_);
                break;
            }
            case 1: {
                this.validNames_ = sValidAdminQoSNames_;
                this.set_qos(this.defaultAdminQoS_);
                break;
            }
            case 2: {
                this.validNames_ = sValidProxyQoSNames_;
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + type + " is invalid");
            }
        }
    }

    protected Set<String> getValidNames() {
        return this.validNames_;
    }

    public void set_qos(Property[] ps) {
        this.set_properties(ps);
    }

    public Property[] get_qos() {
        return this.toArray();
    }

    public void validate_qos(Property[] props, NamedPropertyRangeSeqHolder namedPropertyRange) throws UnsupportedQoS {
        ArrayList<PropertyError> _errors = new ArrayList<PropertyError>();
        this.checkPropertyExistence(props, _errors);
        if (!_errors.isEmpty()) {
            throw new UnsupportedQoS(_errors.toArray(PROPERTY_ERROR_ARRAY_TEMPLATE));
        }
        this.checkPropertyValues(props, _errors);
        if (!_errors.isEmpty()) {
            throw new UnsupportedQoS(_errors.toArray(PROPERTY_ERROR_ARRAY_TEMPLATE));
        }
    }

    private short checkIsShort(String name, Any value, List<PropertyError> errors) throws BAD_OPERATION {
        try {
            return value.extract_short();
        }
        catch (BAD_OPERATION e) {
            errors.add(this.badType(name));
            throw e;
        }
    }

    private void logError(List<PropertyError> errors, QoSError_code error_code, String name, Any value, Any high, Any low) {
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("wrong value for Property '" + name + "': " + value);
        }
        errors.add(new PropertyError(error_code, name, new PropertyRange(high, low)));
    }

    private void checkPropertyValues(Property[] props, List<PropertyError> errors) {
        for (int x = 0; x < props.length; ++x) {
            String _name = props[x].name;
            Any _value = props[x].value;
            try {
                if ("ConnectionReliability".equals(_name)) {
                    short _connectionReliability = this.checkIsShort(_name, _value, errors);
                    switch (_connectionReliability) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            this.logError(errors, QoSError_code.BAD_VALUE, _name, _value, connectionReliabilityLow_, connectionReliabilityHigh_);
                            break;
                        }
                    }
                    continue;
                }
                if ("EventReliability".equals(_name)) {
                    short _eventReliability = this.checkIsShort(_name, _value, errors);
                    switch (_eventReliability) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            this.logError(errors, QoSError_code.BAD_VALUE, _name, _value, eventReliabilityLow_, eventReliabilityHigh_);
                            break;
                        }
                    }
                    continue;
                }
                if ("OrderPolicy".equals(_name)) {
                    short _orderPolicy = this.checkIsShort(_name, _value, errors);
                    switch (_orderPolicy) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            this.logError(errors, QoSError_code.BAD_VALUE, _name, _value, orderPolicyLow_, orderPolicyHigh_);
                            break;
                        }
                    }
                    continue;
                }
                if (!"DiscardPolicy".equals(_name)) continue;
                short _discardPolicy = this.checkIsShort(_name, _value, errors);
                switch (_discardPolicy) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        this.logError(errors, QoSError_code.BAD_VALUE, _name, _value, discardPolicyLow_, discardPolicyHigh_);
                    }
                }
                continue;
            }
            catch (BAD_OPERATION e) {
                // empty catch block
            }
        }
    }

    static {
        trueAny = sORB.create_any();
        falseAny = sORB.create_any();
        trueAny.insert_boolean(true);
        falseAny.insert_boolean(false);
        HashSet<String> _validChannelQoS = new HashSet<String>();
        _validChannelQoS.add("EventReliability");
        _validChannelQoS.add("ConnectionReliability");
        _validChannelQoS.add("Priority");
        _validChannelQoS.add("Timeout");
        _validChannelQoS.add("StartTimeSupported");
        _validChannelQoS.add("StopTimeSupported");
        _validChannelQoS.add("MaxEventsPerConsumer");
        _validChannelQoS.add("OrderPolicy");
        _validChannelQoS.add("DiscardPolicy");
        _validChannelQoS.add("MaximumBatchSize");
        _validChannelQoS.add("PacingInterval");
        sValidChannelQoSNames_ = Collections.unmodifiableSet(_validChannelQoS);
        HashSet<String> _adminNames = new HashSet<String>(sValidChannelQoSNames_);
        _adminNames.remove("EventReliability");
        sValidAdminQoSNames_ = Collections.unmodifiableSet(_adminNames);
        sValidProxyQoSNames_ = sValidAdminQoSNames_;
        HashSet<String> _validMessageQoS = new HashSet<String>();
        _validMessageQoS.add("EventReliability");
        _validMessageQoS.add("Priority");
        _validMessageQoS.add("StartTime");
        _validMessageQoS.add("StopTime");
        _validMessageQoS.add("Timeout");
        connectionReliabilityHigh_ = sORB.create_any();
        connectionReliabilityHigh_.insert_short((short)1);
        connectionReliabilityLow_ = sORB.create_any();
        connectionReliabilityLow_.insert_short((short)0);
        eventReliabilityLow_ = sORB.create_any();
        eventReliabilityLow_.insert_short((short)0);
        eventReliabilityHigh_ = sORB.create_any();
        eventReliabilityHigh_.insert_short((short)0);
        orderPolicyLow_ = sORB.create_any();
        orderPolicyLow_.insert_short((short)0);
        orderPolicyHigh_ = sORB.create_any();
        orderPolicyHigh_.insert_short((short)3);
        discardPolicyLow_ = sORB.create_any();
        discardPolicyLow_.insert_short((short)0);
        discardPolicyHigh_ = sORB.create_any();
        discardPolicyHigh_.insert_short((short)3);
        priorityLow_ = sORB.create_any();
        priorityLow_.insert_short((short)Short.MIN_VALUE);
        priorityDefault_ = sORB.create_any();
        priorityDefault_.insert_short((short)0);
        priorityHigh_ = sORB.create_any();
        priorityHigh_.insert_short((short)Short.MAX_VALUE);
    }
}

