/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.DisposableManager;

public class DefaultTaskExecutor
implements TaskExecutor {
    private final Executor executor_;
    private final DisposableManager disposeHooks_ = new DisposableManager();

    public DefaultTaskExecutor(String name, int numberOfThreads, boolean mayDie) {
        if (numberOfThreads < 0) {
            throw new IllegalArgumentException();
        }
        if (numberOfThreads == 0) {
            this.executor_ = new DirectExecutor();
        } else {
            DefaultThreadFactory _threadFactory = new DefaultThreadFactory(name);
            ExecutorService _executor = mayDie ? Executors.newCachedThreadPool(_threadFactory) : Executors.newFixedThreadPool(numberOfThreads, _threadFactory);
            this.executor_ = _executor;
        }
    }

    public DefaultTaskExecutor(String string, int numberOfThreads) {
        this(string, numberOfThreads, false);
    }

    @Override
    public void dispose() {
        if (this.executor_ instanceof ExecutorService) {
            ((ExecutorService)this.executor_).shutdown();
            ((ExecutorService)this.executor_).shutdownNow();
        }
        this.disposeHooks_.dispose();
    }

    @Override
    public void registerDisposable(Disposable d) {
        this.disposeHooks_.addDisposable(d);
    }

    @Override
    public void execute(Runnable runnable) {
        this.executor_.execute(runnable);
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger counter_ = new AtomicInteger(0);
        private final String name_;

        private DefaultThreadFactory(String name) {
            this.name_ = name;
        }

        @Override
        public Thread newThread(Runnable task) {
            Thread _thread = new Thread(task);
            _thread.setDaemon(true);
            _thread.setName(this.name_ + "#" + this.counter_.getAndIncrement());
            return _thread;
        }
    }

    private final class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

