/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.Block;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.DuplicatesPredicate;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.Transformer;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.core.VisibilityPredicate;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class FastClassEmitter
extends ClassEmitter {
    private static final Signature CSTRUCT_CLASS = TypeUtils.parseConstructor("Class");
    private static final Signature METHOD_GET_INDEX = TypeUtils.parseSignature("int getIndex(String, Class[])");
    private static final Signature SIGNATURE_GET_INDEX = TypeUtils.parseSignature("int getIndex(net.sf.cglib.core.Signature)");
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Signature CONSTRUCTOR_GET_INDEX = TypeUtils.parseSignature("int getIndex(Class[])");
    private static final Signature INVOKE = TypeUtils.parseSignature("Object invoke(int, Object, Object[])");
    private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(int, Object[])");
    private static final Signature GET_MAX_INDEX = TypeUtils.parseSignature("int getMaxIndex()");
    private static final Signature GET_SIGNATURE_WITHOUT_RETURN_TYPE = TypeUtils.parseSignature("String getSignatureWithoutReturnType(String, Class[])");
    private static final Type FAST_CLASS = TypeUtils.parseType("net.sf.cglib.reflect.FastClass");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type INVOCATION_TARGET_EXCEPTION = TypeUtils.parseType("java.lang.reflect.InvocationTargetException");
    private static final Type[] INVOCATION_TARGET_EXCEPTION_ARRAY = new Type[]{INVOCATION_TARGET_EXCEPTION};
    private static final int TOO_MANY_METHODS = 100;

    public FastClassEmitter(ClassVisitor v, String className, Class type) {
        super(v);
        this.begin_class(1, className, FAST_CLASS, null, "<generated>");
        CodeEmitter e = this.begin_method(1, CSTRUCT_CLASS, null, null);
        e.load_this();
        e.load_args();
        e.super_invoke_constructor(CSTRUCT_CLASS);
        e.return_value();
        e.end_method();
        VisibilityPredicate vp = new VisibilityPredicate(type, false);
        List methodList = ReflectUtils.addAllMethods(type, new ArrayList());
        CollectionUtils.filter(methodList, (Predicate)vp);
        CollectionUtils.filter(methodList, (Predicate)new DuplicatesPredicate());
        Object[] methods = methodList.toArray(new Method[methodList.size()]);
        Object[] constructors = (Constructor[])CollectionUtils.filter(type.getDeclaredConstructors(), (Predicate)vp);
        this.emitIndexBySignature((Method[])methods);
        this.emitIndexByClassArray((Method[])methods);
        e = this.begin_method(1, CONSTRUCTOR_GET_INDEX, null, null);
        e.load_args();
        EmitUtils.constructor_switch(e, (Constructor[])constructors, new GetIndexCallback(e, constructors));
        e.end_method();
        e = this.begin_method(1, INVOKE, INVOCATION_TARGET_EXCEPTION_ARRAY, null);
        e.load_arg(1);
        e.checkcast(Type.getType(type));
        e.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(e, methods, 2);
        e.end_method();
        e = this.begin_method(1, NEW_INSTANCE, INVOCATION_TARGET_EXCEPTION_ARRAY, null);
        e.new_instance(Type.getType(type));
        e.dup();
        e.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(e, constructors, 1);
        e.end_method();
        e = this.begin_method(1, GET_MAX_INDEX, null, null);
        e.push(methods.length - 1);
        e.return_value();
        e.end_method();
        this.end_class();
    }

    private void emitIndexBySignature(Method[] methods) {
        CodeEmitter e = this.begin_method(1, SIGNATURE_GET_INDEX, null, null);
        List signatures = CollectionUtils.transform(Arrays.asList(methods), new Transformer(){

            public Object transform(Object obj) {
                return ReflectUtils.getSignature((Method)obj).toString();
            }
        });
        e.load_arg(0);
        e.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        this.signatureSwitchHelper(e, signatures);
        e.end_method();
    }

    private void emitIndexByClassArray(Method[] methods) {
        CodeEmitter e = this.begin_method(1, METHOD_GET_INDEX, null, null);
        if (methods.length > 100) {
            List signatures = CollectionUtils.transform(Arrays.asList(methods), new Transformer(){

                public Object transform(Object obj) {
                    String s = ReflectUtils.getSignature((Method)obj).toString();
                    return s.substring(0, s.lastIndexOf(41) + 1);
                }
            });
            e.load_args();
            e.invoke_static(FAST_CLASS, GET_SIGNATURE_WITHOUT_RETURN_TYPE);
            this.signatureSwitchHelper(e, signatures);
        } else {
            e.load_args();
            EmitUtils.method_switch(e, methods, new GetIndexCallback(e, methods));
        }
        e.end_method();
    }

    private void signatureSwitchHelper(final CodeEmitter e, final List signatures) {
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                e.push(signatures.indexOf(key));
                e.return_value();
            }

            public void processDefault() {
                e.push(-1);
                e.return_value();
            }
        };
        EmitUtils.string_switch(e, signatures.toArray(new String[signatures.size()]), 1, callback);
    }

    private static void invokeSwitchHelper(final CodeEmitter e, final Object[] members, final int arg) {
        final Label illegalArg = e.make_label();
        Block block = e.begin_block();
        e.process_switch(FastClassEmitter.getIntRange(members.length), new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                Member member = (Member)members[key];
                Signature sig = ReflectUtils.getSignature(member);
                Type[] types = sig.getArgumentTypes();
                int i = 0;
                while (i < types.length) {
                    e.load_arg(arg);
                    e.aaload(i);
                    e.unbox(types[i]);
                    ++i;
                }
                if (member instanceof Method) {
                    e.invoke((Method)member);
                    e.box(Type.getType(((Method)member).getReturnType()));
                } else {
                    e.invoke_constructor(Type.getType(member.getDeclaringClass()), sig);
                }
                e.return_value();
            }

            public void processDefault() {
                e.goTo(illegalArg);
            }
        });
        block.end();
        EmitUtils.wrap_throwable(block, INVOCATION_TARGET_EXCEPTION);
        e.mark(illegalArg);
        e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Cannot find matching method/constructor");
    }

    private static int[] getIntRange(int length) {
        int[] range = new int[length];
        int i = 0;
        while (i < length) {
            range[i] = i;
            ++i;
        }
        return range;
    }

    private static class GetIndexCallback
    implements ObjectSwitchCallback {
        private CodeEmitter e;
        private Map indexes = new HashMap();

        public GetIndexCallback(CodeEmitter e, Object[] members) {
            this.e = e;
            int i = 0;
            while (i < members.length) {
                this.indexes.put(members[i], new Integer(i));
                ++i;
            }
        }

        public void processCase(Object key, Label end) {
            this.e.push((Integer)this.indexes.get(key));
            this.e.return_value();
        }

        public void processDefault() {
            this.e.push(-1);
            this.e.return_value();
        }
    }
}

