/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature.parser;

import java.util.ArrayList;
import net.entropysoft.transmorph.signature.parser.CharacterBuffer;
import net.entropysoft.transmorph.signature.parser.InvalidSignatureException;
import net.entropysoft.transmorph.signature.parser.UnexpectedCharacterException;

public class JavaSyntaxTypeSignatureLexer {
    private CharacterBuffer characterBuffer;
    private Token[] tokens;
    private int position = 0;

    public JavaSyntaxTypeSignatureLexer(String str) {
        this.characterBuffer = new CharacterBuffer(str);
    }

    public Token nextToken() {
        if (this.tokens == null) {
            this.readTokens();
        }
        if (this.position >= this.tokens.length) {
            return this.tokens[this.tokens.length - 1];
        }
        return this.tokens[this.position++];
    }

    public Token nextToken(TokenType expectedTokenType) {
        Token token2 = this.nextToken();
        if (token2.tokenType != expectedTokenType) {
            throw new InvalidSignatureException("Unexpected token at position " + token2.tokenStart, token2.tokenStart);
        }
        return token2;
    }

    public Token peekToken(int i) {
        if (this.tokens == null) {
            this.readTokens();
        }
        if (this.position + i >= this.tokens.length) {
            return this.tokens[this.tokens.length - 1];
        }
        return this.tokens[this.position + i];
    }

    private void readTokens() {
        Token token2;
        ArrayList<Token> tokens = new ArrayList<Token>();
        do {
            token2 = this.readToken();
            tokens.add(token2);
        } while (token2.tokenType != TokenType.END_OF_TOKENS);
        this.tokens = tokens.toArray(new Token[tokens.size()]);
    }

    private Token readToken() {
        Token token2 = new Token();
        try {
            int nextChar = this.characterBuffer.peekNextNonWhiteSpaceChar();
            token2.tokenStart = this.characterBuffer.getPosition();
            if (nextChar == 36) {
                this.characterBuffer.nextChar();
                token2.tokenType = TokenType.INNER_CLASS_PREFIX;
            } else if (nextChar == 91) {
                this.characterBuffer.nextChar();
                this.characterBuffer.nextNonWhiteSpaceChar(93);
                token2.tokenType = TokenType.ARRAY;
            } else if (nextChar == 60) {
                this.characterBuffer.nextChar();
                token2.tokenType = TokenType.TYPE_ARG_BEGIN;
            } else if (nextChar == 62) {
                this.characterBuffer.nextChar();
                token2.tokenType = TokenType.TYPE_ARG_END;
            } else if (nextChar == 46) {
                this.characterBuffer.nextChar();
                token2.tokenType = TokenType.PACKAGE_SEPARATOR;
            } else if (nextChar == 44) {
                this.characterBuffer.nextChar();
                token2.tokenType = TokenType.TYPE_ARG_SEPARATOR;
            } else if (nextChar == 63) {
                this.characterBuffer.nextChar();
                token2.tokenType = TokenType.TYPE_ARG_QUESTION_MARK;
            } else if (nextChar == -1) {
                token2.tokenType = TokenType.END_OF_TOKENS;
            } else {
                String javaId = this.parseJavaId();
                if (javaId != null) {
                    token2.text = javaId;
                    token2.tokenType = TokenType.JAVA_ID;
                } else {
                    this.characterBuffer.unexpectedCharacterError();
                }
            }
            token2.tokenEnd = this.characterBuffer.getPosition();
            return token2;
        }
        catch (UnexpectedCharacterException e) {
            throw new InvalidSignatureException(e.getMessage(), e.getPosition());
        }
    }

    private String parseJavaId() {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int ch;
            if ((ch = this.characterBuffer.peekChar()) == -1 || !this.isJavaIdentifierPart(ch)) {
                if (sb.length() == 0) {
                    return null;
                }
                return sb.toString();
            }
            sb.append((char)ch);
            this.characterBuffer.nextChar();
        }
    }

    private boolean isJavaIdentifierPart(int codePoint) {
        if (codePoint == 36) {
            return false;
        }
        return Character.isJavaIdentifierPart(codePoint);
    }

    public String toString() {
        return this.characterBuffer.toString();
    }

    public static class Token {
        TokenType tokenType;
        String text;
        int tokenStart;
        int tokenEnd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenType {
        ARRAY,
        JAVA_ID,
        INNER_CLASS_PREFIX,
        TYPE_ARG_BEGIN,
        TYPE_ARG_END,
        TYPE_ARG_SEPARATOR,
        TYPE_ARG_QUESTION_MARK,
        PACKAGE_SEPARATOR,
        END_OF_TOKENS;

    }
}

