/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.beans;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.converters.beans.DefaultBeanToMapMapping;
import net.entropysoft.transmorph.converters.beans.IBeanToMapMapping;
import net.entropysoft.transmorph.converters.beans.IBeanToMapMapping2;
import net.entropysoft.transmorph.type.TypeReference;
import net.entropysoft.transmorph.utils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanToMap
extends AbstractContainerConverter {
    private Class<? extends Map> defaultMapClass = HashMap.class;
    private IBeanToMapMapping beanToMapMapping = new DefaultBeanToMapMapping();
    private Set<Class<?>> excludedClasses = new HashSet<Class>(Arrays.asList(String.class, Map.class, Collection.class, Calendar.class, Date.class));
    private boolean failIfNoGetters = true;

    public BeanToMap() {
        this.useObjectPool = true;
    }

    public void setBeanToMapMapping(IBeanToMapMapping beanToMapMapping) {
        this.beanToMapMapping = beanToMapMapping;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        if (!destinationType.isRawTypeSubOf(Map.class)) {
            return false;
        }
        TypeReference<?>[] destinationTypeArguments = destinationType.getTypeArguments();
        return destinationTypeArguments.length <= 0 || destinationTypeArguments[0].isType((Type)((Object)String.class)) || !destinationTypeArguments[0].isType((Type)((Object)Object.class));
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        try {
            sourceObject.getClass().getConstructor(new Class[0]);
        }
        catch (Exception e) {
            return false;
        }
        if (sourceObject.getClass().isArray()) {
            return false;
        }
        for (Class<?> excludedClass : this.excludedClasses) {
            if (!excludedClass.isInstance(sourceObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        Map<Object, Object> destinationMap;
        if (sourceObject == null) {
            return null;
        }
        try {
            destinationMap = this.createDestinationMap(destinationType);
        }
        catch (Exception e) {
            throw new ConverterException("Could not create destination map", e);
        }
        if (destinationMap == null) {
            throw new ConverterException("Could not create destination map");
        }
        if (this.useObjectPool) {
            context.getConvertedObjectPool().add(this, sourceObject, destinationType, destinationMap);
        }
        TypeReference<?>[] destinationTypeArguments = this.getDestinationTypeArguments(destinationType);
        Map<String, Method> getterMethods = BeanUtils.getGetters(sourceObject.getClass());
        Map<String, Method> setterMethods = BeanUtils.getSetters(sourceObject.getClass());
        if (this.failIfNoGetters && getterMethods.size() == 1) {
            throw new ConverterException("No getters defined for source object");
        }
        for (Map.Entry<String, Method> entry : getterMethods.entrySet()) {
            Object sourcePropertyValue;
            Method setterMethod;
            Method getterMethod;
            String propertyName = entry.getKey();
            if (!this.selectProperty(sourceObject, propertyName, getterMethod = entry.getValue(), setterMethod = setterMethods.get(propertyName))) continue;
            try {
                sourcePropertyValue = getterMethod.invoke(sourceObject, new Object[0]);
            }
            catch (Exception e) {
                throw new ConverterException(MessageFormat.format("Could not get property ''{0}'' for bean with class ''{1}''", propertyName, sourceObject.getClass().getName()), e);
            }
            String mapKey = this.beanToMapMapping.getMapKey(sourceObject, propertyName, sourcePropertyValue, getterMethod, setterMethod);
            if (mapKey == null) continue;
            Object value = this.elementConverter.convert(context, sourcePropertyValue, destinationTypeArguments[1]);
            destinationMap.put(mapKey, value);
        }
        Map<String, Object> otherValues = this.beanToMapMapping.getOtherValues(sourceObject);
        for (Map.Entry<String, Object> entry : otherValues.entrySet()) {
            Object value = this.elementConverter.convert(context, entry.getValue(), destinationTypeArguments[1]);
            destinationMap.put(entry.getKey(), value);
        }
        return destinationMap;
    }

    private boolean selectProperty(Object bean, String propertyName, Method getterMethod, Method setterMethod) {
        if (this.beanToMapMapping instanceof IBeanToMapMapping2) {
            return ((IBeanToMapMapping2)this.beanToMapMapping).select(bean, propertyName, getterMethod, setterMethod);
        }
        return true;
    }

    private Map<Object, Object> createDestinationMap(TypeReference<?> destinationType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<? extends Map> clazz = this.getConcreteMapDestinationClass(destinationType);
        if (clazz == null) {
            return null;
        }
        return clazz.newInstance();
    }

    protected Class<? extends Map> getConcreteMapDestinationClass(TypeReference<?> destinationType) throws ClassNotFoundException {
        if (destinationType.hasRawType(Map.class)) {
            return this.defaultMapClass;
        }
        Class<?> destinationClass = destinationType.getRawType();
        if (destinationClass.isInterface() || Modifier.isAbstract(destinationClass.getModifiers())) {
            return null;
        }
        try {
            destinationClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
        return destinationClass;
    }

    protected TypeReference<?>[] getDestinationTypeArguments(TypeReference<?> mapDestinationType) {
        if (mapDestinationType.isRawTypeSubOf(Properties.class)) {
            return new TypeReference[]{TypeReference.get(String.class), TypeReference.get(String.class)};
        }
        TypeReference<?>[] destinationTypeArguments = mapDestinationType.getTypeArguments();
        if (destinationTypeArguments.length == 0) {
            destinationTypeArguments = new TypeReference[]{TypeReference.get(Object.class), TypeReference.get(Object.class)};
        }
        return destinationTypeArguments;
    }

    public Set<Class<?>> getExcludedClasses() {
        return this.excludedClasses;
    }

    public void setExcludedClasses(Set<Class<?>> excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    public void setFailIfNoGetters(boolean failIfNoGetters) {
        this.failIfNoGetters = failIfNoGetters;
    }

    public boolean isFailIfNoGetters() {
        return this.failIfNoGetters;
    }
}

