/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToNumber
extends AbstractConverter {
    public StringToNumber() {
        this.useObjectPool = false;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            if (destinationType.isPrimitive()) {
                throw new ConverterException("Cannot convert null to primitive number");
            }
            return null;
        }
        String sourceString = (String)sourceObject;
        try {
            if (destinationType.hasRawType(Byte.TYPE) || destinationType.hasRawType(Byte.class)) {
                return Byte.parseByte(sourceString);
            }
            if (destinationType.hasRawType(Double.TYPE) || destinationType.hasRawType(Double.class)) {
                return Double.parseDouble(sourceString);
            }
            if (destinationType.hasRawType(Float.TYPE) || destinationType.hasRawType(Float.class)) {
                return Float.valueOf(Float.parseFloat(sourceString));
            }
            if (destinationType.hasRawType(Integer.TYPE) || destinationType.hasRawType(Integer.class)) {
                return Integer.parseInt(sourceString);
            }
            if (destinationType.hasRawType(Long.TYPE) || destinationType.hasRawType(Long.class)) {
                return Long.parseLong(sourceString);
            }
            if (destinationType.hasRawType(Short.TYPE) || destinationType.hasRawType(Short.class)) {
                return Short.parseShort(sourceString);
            }
            if (destinationType.hasRawType(BigInteger.class)) {
                return new BigInteger(sourceString);
            }
            if (destinationType.hasRawType(BigDecimal.class)) {
                return new BigDecimal(sourceString);
            }
            if (destinationType.hasRawType(Number.class)) {
                try {
                    return Long.parseLong(sourceString);
                }
                catch (NumberFormatException e) {
                    return Double.parseDouble(sourceString);
                }
            }
            throw new ConverterException("Could not convert");
        }
        catch (NumberFormatException e) {
            throw new ConverterException(MessageFormat.format("Could not convert from ''{0}'' to object with type signature ''{1}''", sourceString, destinationType.toString()), e);
        }
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isNumber();
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof String;
    }
}

