/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneableConverter
extends AbstractConverter {
    public CloneableConverter() {
        this.useObjectPool = false;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isRawTypeSubOf(Cloneable.class);
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        return sourceObject != null && sourceObject instanceof Cloneable;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        try {
            Method cloneableMethod = sourceObject.getClass().getMethod("clone", new Class[0]);
            if (!Modifier.isPublic(cloneableMethod.getModifiers())) {
                throw new ConverterException(MessageFormat.format("clone method for ''{0}''is not public", sourceObject.getClass().getName()));
            }
            return cloneableMethod.invoke(sourceObject, new Object[0]);
        }
        catch (Exception e) {
            throw new ConverterException("Could not clone object with class '" + sourceObject.getClass().getName() + "'");
        }
    }

    @Override
    public boolean canHandle(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) {
        return super.canHandle(context, sourceObject, destinationType) && destinationType.isRawTypeInstance(sourceObject);
    }
}

