/*
 * Decompiled with CFR 0.152.
 */
package mx4j.loading;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class MLetTag {
    private String code;
    private String object;
    private String archive;
    private String codebase;
    private ObjectName objectName;
    private String version;
    private ArrayList signature = new ArrayList();
    private ArrayList arguments = new ArrayList();

    public URL normalizeCodeBase(URL mletFileURL) {
        URL codebaseURL = null;
        String codebase = this.getCodeBase();
        if (codebase != null) {
            try {
                codebaseURL = new URL(codebase);
            }
            catch (MalformedURLException ignored) {
                try {
                    codebaseURL = new URL(mletFileURL, codebase);
                }
                catch (MalformedURLException alsoIgnored) {
                    // empty catch block
                }
            }
        }
        if (codebaseURL == null) {
            String path = mletFileURL.getPath();
            int index = path.lastIndexOf(47);
            try {
                codebaseURL = new URL(mletFileURL, path.substring(0, index + 1));
            }
            catch (MalformedURLException ignored) {
                // empty catch block
            }
        }
        return codebaseURL;
    }

    public String[] parseArchive() {
        String archive = this.getArchive();
        ArrayList<String> archives = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(archive, ",");
        while (tokenizer.hasMoreTokens()) {
            String token2 = tokenizer.nextToken().trim();
            if (token2.length() <= 0) continue;
            token2 = token2.replace('\\', '/');
            archives.add(token2);
        }
        return archives.toArray(new String[0]);
    }

    public URL createArchiveURL(URL codebase, String archive) {
        try {
            return new URL(codebase, archive);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getCodeBase() {
        return this.codebase;
    }

    public String getArchive() {
        return this.archive;
    }

    public String getCode() {
        return this.code;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getObject() {
        return this.object;
    }

    public String[] getSignature() {
        return this.signature == null ? new String[]{} : this.signature.toArray(new String[this.signature.size()]);
    }

    public Object[] getArguments() {
        return this.arguments == null ? new Object[]{} : this.arguments.toArray(new Object[this.arguments.size()]);
    }

    void setArchive(String archive) {
        this.archive = archive;
    }

    void setCode(String code) {
        this.code = code;
    }

    void setCodeBase(String codebase) {
        if (!(codebase = codebase.replace('\\', '/')).endsWith("/")) {
            codebase = codebase + "/";
        }
        this.codebase = codebase;
    }

    void setName(ObjectName name) {
        this.objectName = name;
    }

    void setObject(String object) {
        this.object = object;
    }

    void setVersion(String version2) {
        this.version = version2;
    }

    void addArg(String type, Object value) {
        this.signature.add(type);
        this.arguments.add(value);
    }
}

