/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import java.util.concurrent.TimeoutException;
import org.tango.utils.DevFailedUtils;

public class WaitStateUtilities {
    public static void waitWhileState(DeviceProxy proxy, DevState waitState, long timeout) throws DevFailed, TimeoutException {
        WaitStateUtilities.waitWhileState(proxy, waitState, timeout, 300L);
    }

    public static void waitWhileState(DeviceProxy proxy, DevState waitState, long timeout, long pollingTime) throws DevFailed, TimeoutException {
        long time0 = System.currentTimeMillis();
        while (proxy.state().equals(waitState)) {
            if (System.currentTimeMillis() - time0 > timeout) {
                throw new TimeoutException("Stateutilities.waitWhileState : timeout reached while waiting end of state " + TangoConst.Tango_DevStateName[waitState.value()]);
            }
            try {
                Thread.sleep(pollingTime);
            }
            catch (InterruptedException e) {}
        }
    }

    public static void waitForState(DeviceProxy proxy, DevState waitState, long timeout) throws DevFailed, TimeoutException {
        WaitStateUtilities.waitForState(proxy, waitState, timeout, 300L);
    }

    public static void waitForState(DeviceProxy proxy, DevState waitState, long timeout, long pollingTime) throws DevFailed, TimeoutException {
        long time0 = System.currentTimeMillis();
        while (!proxy.state().equals(waitState)) {
            if (System.currentTimeMillis() - time0 > timeout) {
                throw new TimeoutException("timeout reached while waiting for state " + TangoConst.Tango_DevStateName[waitState.value()]);
            }
            try {
                Thread.sleep(pollingTime);
            }
            catch (InterruptedException e) {}
        }
    }

    public static void failIfWrongStateAfterWhileState(DeviceProxy deviceProxy, DevState expected, DevState waitState, long timeout, long polling) throws DevFailed, TimeoutException {
        WaitStateUtilities.waitWhileState(deviceProxy, waitState, timeout, polling);
        if (!expected.equals(deviceProxy.state())) {
            throw DevFailedUtils.newDevFailed("State not reach", "fail to reach state " + TangoConst.Tango_DevStateName[expected.value()] + " after wait " + TangoConst.Tango_DevStateName[waitState.value()]);
        }
    }
}

