/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.factory;

import fr.esrf.Tango.DevFailed;
import fr.soleil.tango.clientapi.attribute.AttributeValueType;
import fr.soleil.tango.clientapi.attribute.IExtractor;
import fr.soleil.tango.clientapi.attribute.IInserter;
import fr.soleil.tango.clientapi.command.CommandType;
import fr.soleil.tango.clientapi.command.ICommandExtractor;
import fr.soleil.tango.clientapi.command.ICommandInserter;
import org.tango.utils.DevFailedUtils;

public final class InsertExtractFactory {
    private static final String TANGO_WRONG_DATA_ERROR = "TANGO_WRONG_DATA_ERROR";

    private InsertExtractFactory() {
    }

    public static IExtractor getAttributeExtractor(int dataType) throws DevFailed {
        IExtractor extractor = AttributeValueType.getExtractorFromDataType(dataType);
        if (extractor == null) {
            extractor = AttributeValueType.getExtractorFromDataType(5);
        }
        return extractor;
    }

    public static IInserter getAttributeInserter(int dataType) throws DevFailed {
        IInserter inserter = AttributeValueType.getInserterFromDataType(dataType);
        if (inserter == null) {
            inserter = AttributeValueType.getInserterFromDataType(5);
        }
        return inserter;
    }

    public static ICommandExtractor getCommandExtractor(int dataType) throws DevFailed {
        ICommandExtractor extractor = CommandType.getExtractorFromDataType(dataType);
        if (extractor == null) {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, "command type not supported " + dataType);
        }
        return extractor;
    }

    public static ICommandInserter getCommandInserter(int dataType) throws DevFailed {
        ICommandInserter inserter = CommandType.getInserterFromDataType(dataType);
        if (inserter == null) {
            throw DevFailedUtils.newDevFailed(TANGO_WRONG_DATA_ERROR, "command type not supported " + dataType);
        }
        return inserter;
    }
}

