/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.CommunicationTimeout;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoDs.NamedDevFailed;
import fr.esrf.TangoDs.NamedDevFailedList;
import fr.esrf.TangoDs.TangoConst;
import java.io.Serializable;
import org.omg.CORBA.SystemException;

public class Except
implements TangoConst,
Serializable {
    public static String str_exception(Exception except) {
        String str = "";
        if (except instanceof ConnectionFailed) {
            str = str + ((ConnectionFailed)except).getStack();
        } else if (except instanceof CommunicationFailed) {
            str = str + ((CommunicationFailed)except).getStack();
        } else if (except instanceof WrongNameSyntax) {
            str = str + ((WrongNameSyntax)except).getStack();
        } else if (except instanceof WrongData) {
            str = str + ((WrongData)except).getStack();
        } else if (except instanceof NonDbDevice) {
            str = str + ((NonDbDevice)except).getStack();
        } else if (except instanceof NonSupportedFeature) {
            str = str + ((NonSupportedFeature)except).getStack();
        } else if (except instanceof EventSystemFailed) {
            str = str + ((EventSystemFailed)except).getStack();
        } else if (except instanceof AsynReplyNotArrived) {
            str = str + ((AsynReplyNotArrived)except).getStack();
        } else if (except instanceof DevFailed) {
            DevFailed df = (DevFailed)except;
            str = str + "Tango exception  " + df.toString() + "\n";
            for (int i = 0; i < df.errors.length; ++i) {
                str = str + "Severity -> ";
                switch (df.errors[i].severity.value()) {
                    case 0: {
                        str = str + "WARNING \n";
                        break;
                    }
                    case 1: {
                        str = str + "ERROR \n";
                        break;
                    }
                    case 2: {
                        str = str + "PANIC \n";
                        break;
                    }
                    default: {
                        str = str + "Unknown severity code";
                    }
                }
                str = str + "Desc   -> " + df.errors[i].desc + "\n";
                str = str + "Reason -> " + df.errors[i].reason + "\n";
                str = str + "Origin -> " + df.errors[i].origin + "\n";
                if (i >= df.errors.length - 1) continue;
                str = str + "-------------------------------------------------------------\n";
            }
        } else {
            str = except.toString();
        }
        return str;
    }

    public static void print_exception(DevError[] errors) {
        Except.print_exception(new DevFailed(errors));
    }

    public static void print_exception(Exception ex) {
        if (ex instanceof DevFailed) {
            DevFailed ex_dev = (DevFailed)ex;
            for (int i = 0; i < ex_dev.errors.length; ++i) {
                System.err.println("Tango exception");
                System.err.print("Severity -> ");
                switch (ex_dev.errors[i].severity.value()) {
                    case 0: {
                        System.err.println("WARNING ");
                        break;
                    }
                    case 1: {
                        System.err.println("ERROR ");
                        break;
                    }
                    case 2: {
                        System.err.println("PANIC ");
                        break;
                    }
                    default: {
                        System.err.println("Unknown severity code");
                    }
                }
                System.err.println("Desc -> " + ex_dev.errors[i].desc);
                if (ex instanceof NamedDevFailedList) {
                    NamedDevFailedList ndfl = (NamedDevFailedList)ex;
                    if (i < ndfl.get_faulty_attr_nb()) {
                        NamedDevFailed ndf = ndfl.elementAt(i);
                        for (DevError err : ndf.err_stack) {
                            System.out.println("Reason -> " + err.reason);
                        }
                    }
                } else {
                    System.err.println("Reason -> " + ex_dev.errors[i].reason);
                }
                System.err.println("Origin -> " + ex_dev.errors[i].origin);
            }
        } else {
            String ex_name = ex.getClass().getName();
            int last_dot = ex_name.lastIndexOf(46);
            if (last_dot < 0) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                return;
            }
            String ex_last_name = ex_name.substring(last_dot + 1);
            int before_last_dot = ex_name.lastIndexOf(46, last_dot - 1);
            if (before_last_dot < 0) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                return;
            }
            String ex_part_name = ex_name.substring(before_last_dot + 1, last_dot);
            if (ex_part_name.equals("CORBA")) {
                SystemException ex_sys = (SystemException)ex;
                System.err.println("CORBA system exception " + ex_last_name);
                System.err.println(ex.getMessage());
                System.err.print("Completed: ");
                switch (ex_sys.completed.value()) {
                    case 0: {
                        System.err.println("yes");
                        break;
                    }
                    case 1: {
                        System.err.println("no");
                        break;
                    }
                    case 2: {
                        System.err.println("maybe");
                    }
                }
                System.err.println("Minor code: " + ex_sys.minor);
            } else {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public static void print_exception_stack(Exception ex) {
        Except.print_exception(ex);
        ex.printStackTrace();
    }

    private static String getCurrentCodeLine() {
        return Thread.currentThread().getStackTrace()[3].toString();
    }

    public static void throw_exception(String reason, String desc) throws DevFailed {
        Except.throw_exception(reason, desc, Except.getCurrentCodeLine());
    }

    public static void throw_exception(String reason, String desc, String origin) throws DevFailed {
        Except.throw_exception(reason, desc, origin, ErrSeverity.ERR);
    }

    public static void throw_exception(String reason, String desc, String origin, ErrSeverity sever) throws DevFailed {
        DevError[] err = new DevError[]{new DevError()};
        err[0].desc = desc;
        err[0].severity = sever;
        err[0].reason = reason;
        err[0].origin = origin;
        throw new DevFailed(err);
    }

    public static void re_throw_exception(DevFailed ex, String reason, String desc) throws DevFailed {
        Except.re_throw_exception(ex, reason, desc, Except.getCurrentCodeLine());
    }

    public static void re_throw_exception(DevFailed ex, String reason, String desc, String origin) throws DevFailed {
        Except.re_throw_exception(ex, reason, desc, origin, ErrSeverity.ERR);
    }

    public static void re_throw_exception(DevFailed ex, String reason, String desc, String origin, ErrSeverity sever) throws DevFailed {
        int nb_error = ex.errors.length;
        DevError[] err = new DevError[nb_error + 1];
        System.arraycopy(ex.errors, 0, err, 0, nb_error);
        err[nb_error] = new DevError();
        err[nb_error].desc = desc;
        err[nb_error].severity = sever;
        err[nb_error].reason = reason;
        err[nb_error].origin = origin;
        throw new DevFailed(err);
    }

    public static void throw_exception(SystemException ex, String origin) throws DevFailed {
        DevError[] err = new DevError[]{new DevError()};
        err[0].desc = Except.print_CORBA_SystemException(ex);
        err[0].severity = ErrSeverity.ERR;
        err[0].reason = "API_CorbaSysException";
        err[0].origin = origin;
        throw new DevFailed(err);
    }

    public static String print_CORBA_SystemException(SystemException ex) {
        String ex_name = ex.getClass().getName();
        int last_dot = ex_name.lastIndexOf(46);
        if (last_dot == -1) {
            return "Unknown system exception !!!!!!!!";
        }
        String ex_last_name = ex_name.substring(last_dot + 1);
        int before_last_dot = ex_name.lastIndexOf(46, last_dot - 1);
        if (before_last_dot == -1) {
            return "Unknown system exception !!!!!!!!";
        }
        String ex_part_name = ex_name.substring(before_last_dot + 1, last_dot);
        if (ex_part_name.equals("CORBA")) {
            StringBuilder str = new StringBuilder("CORBA system exception ");
            str.append(ex_last_name);
            str.append(ex.getMessage());
            str.append("Completed: ");
            switch (ex.completed.value()) {
                case 0: {
                    str.append("yes");
                    break;
                }
                case 1: {
                    str.append("no");
                    break;
                }
                case 2: {
                    str.append("maybe");
                }
            }
            str.append("Minor code: ");
            str.append(ex.minor);
            return str.toString();
        }
        return "Unknown system exception !!!!!!!!";
    }

    public static void throw_connection_failed(String reason, String desc, String origin) throws ConnectionFailed {
        Except.throw_connection_failed(null, reason, desc, origin, ErrSeverity.from_int(2));
    }

    public static void throw_connection_failed(DevFailed df, String reason, String desc, String origin) throws ConnectionFailed {
        Except.throw_connection_failed(df, reason, desc, origin, ErrSeverity.from_int(2));
    }

    public static void throw_connection_failed(String reason, String desc, String origin, ErrSeverity severity) throws ConnectionFailed {
        Except.throw_connection_failed(null, reason, desc, origin, severity);
    }

    public static void throw_connection_failed(DevFailed df, String reason, String desc, String origin, ErrSeverity severity) throws ConnectionFailed {
        DevError[] err;
        if (df == null) {
            err = new DevError[1];
        } else {
            err = new DevError[df.errors.length + 1];
            for (int i = 0; i < df.errors.length; ++i) {
                err[i] = df.errors[i];
            }
        }
        err[i] = new DevError(reason, severity, desc, origin);
        throw new ConnectionFailed(err);
    }

    public static void throw_communication_failed(String reason, String desc, String origin) throws CommunicationFailed {
        Except.throw_communication_failed(null, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_communication_failed(DevFailed df, String reason, String desc, String origin) throws CommunicationFailed {
        Except.throw_communication_failed(df, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_communication_timeout(String reason, String desc, String origin) throws CommunicationTimeout {
        Except.throw_communication_timeout(null, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_communication_failed(String reason, String desc, String origin, ErrSeverity severity) throws CommunicationFailed {
        Except.throw_communication_failed(null, reason, desc, origin, severity);
    }

    public static void throw_communication_failed(DevFailed df, String reason, String desc, String origin, ErrSeverity severity) throws CommunicationFailed {
        DevError[] err;
        if (df == null) {
            err = new DevError[1];
        } else {
            err = new DevError[df.errors.length + 1];
            for (int i = 0; i < df.errors.length; ++i) {
                err[i] = df.errors[i];
            }
        }
        err[i] = new DevError(reason, severity, desc, origin);
        throw new CommunicationFailed(err);
    }

    public static void throw_communication_timeout(DevFailed df, String reason, String desc, String origin, ErrSeverity severity) throws CommunicationTimeout {
        DevError[] err;
        if (df == null) {
            err = new DevError[1];
        } else {
            err = new DevError[df.errors.length + 1];
            for (int i = 0; i < df.errors.length; ++i) {
                err[i] = df.errors[i];
            }
        }
        err[i] = new DevError(reason, severity, desc, origin);
        throw new CommunicationTimeout(err);
    }

    public static void throw_wrong_syntax_exception(String reason, String desc, String origin) throws WrongNameSyntax {
        Except.throw_wrong_syntax_exception(null, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_wrong_syntax_exception(DevFailed df, String reason, String desc, String origin) throws WrongNameSyntax {
        Except.throw_wrong_syntax_exception(df, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_wrong_syntax_exception(String reason, String desc, String origin, ErrSeverity severity) throws WrongNameSyntax {
        Except.throw_wrong_syntax_exception(null, reason, desc, origin, severity);
    }

    public static void throw_wrong_syntax_exception(DevFailed df, String reason, String desc, String origin, ErrSeverity severity) throws WrongNameSyntax {
        DevError[] err;
        if (df == null) {
            err = new DevError[1];
        } else {
            err = new DevError[df.errors.length + 1];
            for (int i = 0; i < df.errors.length; ++i) {
                err[i] = df.errors[i];
            }
        }
        err[i] = new DevError(reason, severity, desc, origin);
        throw new WrongNameSyntax(err);
    }

    public static void throw_wrong_data_exception(String reason, String desc, String origin) throws WrongData {
        Except.throw_wrong_data_exception(null, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_wrong_data_exception(DevFailed df, String reason, String desc, String origin) throws WrongData {
        Except.throw_wrong_data_exception(df, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_wrong_data_exception(String reason, String desc, String origin, ErrSeverity severity) throws WrongData {
        Except.throw_wrong_data_exception(null, reason, desc, origin, severity);
    }

    public static void throw_wrong_data_exception(DevFailed df, String reason, String desc, String origin, ErrSeverity severity) throws WrongData {
        DevError[] err;
        if (df == null) {
            err = new DevError[1];
        } else {
            err = new DevError[df.errors.length + 1];
            for (int i = 0; i < df.errors.length; ++i) {
                err[i] = df.errors[i];
            }
        }
        err[i] = new DevError(reason, severity, desc, origin);
        throw new WrongData(err);
    }

    public static void throw_non_db_exception(String reason, String desc, String origin) throws NonDbDevice {
        Except.throw_non_db_exception(null, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_non_db_exception(DevFailed df, String reason, String desc, String origin) throws NonDbDevice {
        Except.throw_non_db_exception(df, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_non_db_exception(String reason, String desc, String origin, ErrSeverity severity) throws NonDbDevice {
        Except.throw_non_db_exception(null, reason, desc, origin, severity);
    }

    public static void throw_non_db_exception(DevFailed df, String reason, String desc, String origin, ErrSeverity severity) throws NonDbDevice {
        DevError[] err;
        if (df == null) {
            err = new DevError[1];
        } else {
            err = new DevError[df.errors.length + 1];
            for (int i = 0; i < df.errors.length; ++i) {
                err[i] = df.errors[i];
            }
        }
        err[i] = new DevError(reason, severity, desc, origin);
        throw new NonDbDevice(err);
    }

    public static void throw_non_supported_exception(String reason, String desc, String origin) throws NonSupportedFeature {
        Except.throw_non_supported_exception(null, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_non_supported_exception(DevFailed df, String reason, String desc, String origin) throws NonSupportedFeature {
        Except.throw_non_supported_exception(df, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_non_supported_exception(String reason, String desc, String origin, ErrSeverity severity) throws NonSupportedFeature {
        Except.throw_non_supported_exception(null, reason, desc, origin, severity);
    }

    public static void throw_non_supported_exception(DevFailed df, String reason, String desc, String origin, ErrSeverity severity) throws NonSupportedFeature {
        DevError[] err;
        if (df == null) {
            err = new DevError[1];
        } else {
            err = new DevError[df.errors.length + 1];
            for (int i = 0; i < df.errors.length; ++i) {
                err[i] = df.errors[i];
            }
        }
        err[i] = new DevError(reason, severity, desc, origin);
        throw new NonSupportedFeature(err);
    }

    public static void throw_asyn_reply_not_arrived(String reason, String desc, String origin) throws AsynReplyNotArrived {
        Except.throw_asyn_reply_not_arrived(null, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_asyn_reply_not_arrived(DevFailed df, String reason, String desc, String origin) throws AsynReplyNotArrived {
        Except.throw_asyn_reply_not_arrived(df, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_asyn_reply_not_arrived(String reason, String desc, String origin, ErrSeverity severity) throws AsynReplyNotArrived {
        Except.throw_asyn_reply_not_arrived(null, reason, desc, origin, severity);
    }

    public static void throw_asyn_reply_not_arrived(DevFailed df, String reason, String desc, String origin, ErrSeverity severity) throws AsynReplyNotArrived {
        DevError[] err;
        if (df == null) {
            err = new DevError[1];
        } else {
            err = new DevError[df.errors.length + 1];
            for (int i = 0; i < df.errors.length; ++i) {
                err[i] = df.errors[i];
            }
        }
        err[i] = new DevError(reason, severity, desc, origin);
        throw new AsynReplyNotArrived(err);
    }

    public static void throw_event_system_failed(String reason, String desc, String origin) throws EventSystemFailed {
        Except.throw_event_system_failed(null, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_event_system_failed(DevFailed df, String reason, String desc, String origin) throws EventSystemFailed {
        Except.throw_event_system_failed(df, reason, desc, origin, ErrSeverity.from_int(1));
    }

    public static void throw_event_system_failed(String reason, String desc, String origin, ErrSeverity severity) throws EventSystemFailed {
        Except.throw_event_system_failed(null, reason, desc, origin, severity);
    }

    public static void throw_event_system_failed(DevFailed df, String reason, String desc, String origin, ErrSeverity severity) throws EventSystemFailed {
        DevError[] err;
        if (df == null) {
            err = new DevError[1];
        } else {
            err = new DevError[df.errors.length + 1];
            for (int i = 0; i < df.errors.length; ++i) {
                err[i] = df.errors[i];
            }
        }
        err[i] = new DevError(reason, severity, desc, origin);
        throw new EventSystemFailed(err);
    }
}

