/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Command;
import fr.esrf.TangoDs.DeviceClass;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.KillThread;
import fr.esrf.TangoDs.Logging;
import fr.esrf.TangoDs.MultiAttribute;
import fr.esrf.TangoDs.MyComp;
import fr.esrf.TangoDs.PollObj;
import fr.esrf.TangoDs.PollThCmd;
import fr.esrf.TangoDs.TangoMonitor;
import fr.esrf.TangoDs.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

@Deprecated
public class DServer
extends DeviceImpl {
    protected String process_name;
    protected String instance_name;
    protected StringBuffer full_name;
    protected Vector class_list = new Vector();

    DServer(DeviceClass cl, String n, String d, DevState s, String st) throws DevFailed {
        super(cl, n, d, s, st);
        this.process_name = Util.instance().get_ds_exec_name();
        this.instance_name = Util.instance().get_ds_inst_name();
        this.full_name = new StringBuffer(this.process_name);
        this.full_name.append('/');
        this.full_name.append(this.instance_name);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                int nb_class = DServer.this.class_list.size();
                for (int j = 0; j < nb_class; ++j) {
                    Vector v = ((DeviceClass)DServer.this.class_list.elementAt(j)).get_device_list();
                    int nb_dev = v.size();
                    for (int k = 0; k < nb_dev; ++k) {
                        DeviceImpl dev = (DeviceImpl)v.elementAt(k);
                        if (!dev.get_exported_flag()) continue;
                        try {
                            Util.out4.println("delete device " + dev.get_name());
                            dev.delete_device();
                            continue;
                        }
                        catch (DevFailed e) {
                            e.printStackTrace();
                        }
                    }
                }
                Util.out4.println("unregister " + Util.instance().get_ds_name());
                Util.instance().unregister_server();
            }
        }));
        this.init_device();
    }

    @Override
    public void init_device() throws DevFailed {
        block26: {
            Util.out4.println("DServer.DSserver() create dserver " + this.device_name);
            boolean class_factory_done = false;
            int i = 0;
            try {
                Util tg = Util.instance();
                POAManager manager = tg.get_poa().the_POAManager();
                try {
                    manager.activate();
                }
                catch (AdapterInactive ex) {
                    Except.throw_exception("API_CantActivatePOAManager", "The POA activate method throws an exception", "DServer.init_device()");
                }
                this.class_factory();
                class_factory_done = true;
                if (this.class_list.isEmpty()) break block26;
                tg.set_class_list(this.class_list);
                String ds_name = tg.get_ds_name();
                for (i = 0; i < this.class_list.size(); ++i) {
                    String[] dev_list_nodb;
                    DeviceClass cl_ref = (DeviceClass)this.class_list.elementAt(i);
                    cl_ref.command_factory();
                    MyComp comp = new MyComp();
                    Collections.sort(cl_ref.get_command_list(), comp);
                    cl_ref.attribute_factory(cl_ref.get_class_attr().get_attr_list());
                    cl_ref.get_class_attr().init_class_attribute(cl_ref.get_name(), 0);
                    for (int k = 0; k < cl_ref.get_command_list().size(); ++k) {
                        Command cmd = (Command)cl_ref.get_command_list().elementAt(k);
                        if (!cmd.is_template()) continue;
                        cmd.set_device_class_name(cl_ref.get_name());
                        cmd.analyse_methods();
                    }
                    String[] dev_list = null;
                    if (Util._UseDb) {
                        String[] ds = new String[]{ds_name, ((DeviceClass)this.class_list.elementAt(i)).get_name()};
                        DeviceData send = new DeviceData();
                        send.insert(ds);
                        DeviceData received = tg.get_database().command_inout("DbGetDeviceList", send);
                        try {
                            dev_list = received.extractStringArray();
                        }
                        catch (BAD_OPERATION ex) {
                            Util.out3.println("DServer.init_device() --> Wrong argument type for DbGetDeviceList command");
                            Except.throw_exception("API_IncompatibleCmdArgumentType", "Imcompatible command argument type returned by the DbGetDeviceList command", "DServer.init_device()");
                        }
                        if (dev_list.length == 0) {
                            StringBuffer o = new StringBuffer("No device defined in database for class ");
                            o.append(((DeviceClass)this.class_list.elementAt(i)).get_name());
                            Except.throw_exception("API_DatabaseAccess", o.toString(), "DServer.init_device()");
                        }
                        Util.out4.println(dev_list.length + " device(s) defined");
                        ((DeviceClass)this.class_list.elementAt(i)).device_factory(dev_list);
                        continue;
                    }
                    Vector list = ((DeviceClass)this.class_list.elementAt(i)).get_nodb_name_list();
                    if (i != this.class_list.size() - 1) {
                        ((DeviceClass)this.class_list.elementAt(i)).device_name_factory(list);
                    } else if (tg.get_cmd_line_name_list().size() == 0) {
                        ((DeviceClass)this.class_list.elementAt(i)).device_name_factory(list);
                    } else {
                        list = tg.get_cmd_line_name_list();
                    }
                    if (list.isEmpty()) {
                        dev_list_nodb = new String[]{"NoName"};
                    } else {
                        dev_list_nodb = new String[list.size()];
                        for (int k = 0; k < list.size(); ++k) {
                            dev_list_nodb[k] = (String)list.elementAt(k);
                        }
                    }
                    ((DeviceClass)this.class_list.elementAt(i)).device_factory(dev_list_nodb);
                }
            }
            catch (OutOfMemoryError ex) {
                StringBuffer o = new StringBuffer("Can't allocate memory in server while ");
                if (!class_factory_done) {
                    int class_err = this.class_list.size() + 1;
                    o.append("creating class number ");
                    o.append(class_err);
                    if (!this.class_list.isEmpty()) {
                        this.class_list.removeAllElements();
                    }
                } else {
                    o.append("building command(s) or device(s) for class number ");
                    o.append(i + 1);
                    for (int j = i; j < this.class_list.size(); ++j) {
                        this.class_list.removeElementAt(j);
                    }
                }
                Except.throw_exception("API_MemoryAllocation", o.toString(), "DServer.init_device()");
            }
            catch (DevFailed ex) {
                if (!class_factory_done) {
                    if (!this.class_list.isEmpty()) {
                        this.class_list.removeAllElements();
                    }
                } else {
                    for (int j = i; j < this.class_list.size(); ++j) {
                        this.class_list.removeElementAt(j);
                    }
                }
                throw ex;
            }
        }
    }

    private void class_factory() throws DevFailed {
        StringBuffer o;
        Util tg = Util.instance();
        String[] cl_list = null;
        try {
            if (Util._UseDb) {
                StringBuffer str = new StringBuffer(tg.get_ds_exec_name());
                str.append('/');
                str.append(tg.get_ds_inst_name());
                DeviceData send = new DeviceData();
                send.insert(str.toString());
                DeviceData received = tg.get_database().command_inout("DbGetDeviceServerClassList", send);
                cl_list = received.extractStringArray();
            } else {
                Vector v = tg.get_class_name_list();
                cl_list = new String[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    cl_list[i] = (String)v.elementAt(i);
                }
            }
        }
        catch (BAD_OPERATION ex) {
            Util.out3.println("DServer.class_factory() --> Wrong argument type for DbGetDeviceServerClassList command");
            Except.throw_exception("API_IncompatibleCmdArgumentType", "Imcompatible command argument type returned by the DbGetDeviceServerClassList command", "DServer.class_factory()");
        }
        catch (DevFailed ex) {
            Util.out3.println("DServer.class_factory() --> db command failed");
            Except.throw_exception("API_CantRetrieveClassList", "The db command DbGetDeviceServerClassList failed", "DServer.class_factory()");
        }
        Util.out4.println(cl_list.length - 1 + " class(es) defined in server");
        int i = 0;
        try {
            for (i = 0; i < cl_list.length; ++i) {
                Class<?> cl;
                if (cl_list[i].equals("DServer")) continue;
                Class<?> cl_param = Class.forName("java.lang.String");
                Class[] cl_param_array = new Class[]{cl_param};
                int pos = cl_list[i].indexOf("Class");
                if (pos == -1) {
                    StringBuffer class_name = new StringBuffer(cl_list[i]);
                    int containsDot = cl_list[i].indexOf(".");
                    if (containsDot == -1) {
                        class_name.insert(0, ".");
                        class_name.append("Class");
                        class_name.insert(0, cl_list[i]);
                    } else {
                        class_name.append("Class");
                    }
                    Util.out4.println("Searching for class : " + class_name);
                    cl = Class.forName(new String(class_name));
                } else {
                    cl = Class.forName(cl_list[i]);
                }
                Method init_meth = cl.getMethod("init", cl_param_array);
                Object[] meth_param = new Object[1];
                int containsDot = cl_list[i].lastIndexOf(".");
                meth_param[0] = containsDot == -1 ? cl_list[i] : cl_list[i].substring(containsDot + 1);
                this.class_list.addElement(init_meth.invoke(null, meth_param));
            }
        }
        catch (ClassNotFoundException ex) {
            o = new StringBuffer("Can't retrieve class ");
            o.append(cl_list[i]);
            Util.out3.println("DServer.class_factory() --> Can't find class");
            Except.throw_exception("API_ClassNotFound", new String(o), "DServer.class_factory()");
        }
        catch (NoSuchMethodException ex) {
            o = new StringBuffer("Can't retrieve init method in class ");
            o.append(cl_list[i]);
            Util.out3.println("DServer.class_factory() --> Can't retrieve int method");
            Except.throw_exception("API_InitMethodNotFound", new String(o), "DServer.class_factory()");
        }
        catch (SecurityException ex) {
            o = new StringBuffer("Security exception while creating class ");
            o.append(cl_list[i]);
            Util.out3.println("DServer.class_factory() --> Security exception during class creation");
            Except.throw_exception("API_JavaRuntimeSecurityException", new String(o), "DServer.class_factory()");
        }
        catch (InvocationTargetException ex) {
            o = new StringBuffer("The init method of class ");
            o.append(cl_list[i]);
            o.append(" throws an exception");
            Util.out3.println("DServer.class_factory() --> Init method send on exception during class creation");
            Throwable th = ex.getTargetException();
            if (th instanceof ConnectionFailed) {
                throw (ConnectionFailed)th;
            }
            if (th instanceof DevFailed) {
                throw (DevFailed)th;
            }
            Except.throw_exception("API_InitThrowsException", new String(o), "DServer.class_factory()");
        }
        catch (IllegalAccessException ex) {
            o = new StringBuffer("The init method of class ");
            o.append(cl_list[i]);
            o.append(" is not public");
            Util.out3.println("DServer.class_factory() --> Init method not accessible during class creation");
            Except.throw_exception("API_InitNotPublic", new String(o), "DServer.class_factory()");
        }
    }

    public String[] query_class() throws DevFailed {
        Util.out4.println("In QueryClass command");
        int nb_class = this.class_list.size();
        String[] ret = null;
        try {
            ret = new String[nb_class];
            for (int i = 0; i < nb_class; ++i) {
                ret[i] = ((DeviceClass)this.class_list.elementAt(i)).get_name();
            }
        }
        catch (OutOfMemoryError ex) {
            Util.out3.println("Memory Allocation error in DServer.query_class  method");
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DServer.query_class");
        }
        return ret;
    }

    public String[] query_device() throws DevFailed {
        Util.out4.println("In QueryDevice command");
        int nb_class = this.class_list.size();
        Vector<String> tmp_name = new Vector<String>();
        for (int i = 0; i < nb_class; ++i) {
            int nb_dev = ((DeviceClass)this.class_list.elementAt(i)).get_device_list().size();
            for (int j = 0; j < nb_dev; ++j) {
                tmp_name.addElement(((DeviceImpl)((DeviceClass)this.class_list.elementAt(i)).get_device_list().elementAt(j)).get_name());
            }
        }
        String[] ret = null;
        try {
            ret = new String[tmp_name.size()];
            for (int i = 0; i < tmp_name.size(); ++i) {
                ret[i] = (String)tmp_name.elementAt(i);
            }
        }
        catch (BAD_OPERATION ex) {
            Util.out3.println("Memory Allocation error in DServer.query_device method");
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "DServer.query_device");
        }
        return ret;
    }

    public void restart(String dev_name) throws DevFailed {
        int i;
        Util.out4.println("In DServer.restart(" + dev_name + ") method");
        Util tg = Util.instance();
        Vector dev_list = tg.get_device_list_by_class(((DeviceClass)this.class_list.elementAt(0)).get_name());
        int nb_class = this.class_list.size();
        DeviceImpl dev_to_del = null;
        DeviceClass dev_cl = null;
        int j = 0;
        for (i = 0; i < nb_class; ++i) {
            dev_list = tg.get_device_list_by_class(((DeviceClass)this.class_list.elementAt(i)).get_name());
            int nb_dev = dev_list.size();
            for (j = 0; j < nb_dev; ++j) {
                if (!((DeviceImpl)dev_list.elementAt(j)).get_name().equals(dev_name)) continue;
                dev_to_del = (DeviceImpl)dev_list.elementAt(j);
                dev_cl = (DeviceClass)this.class_list.elementAt(i);
                break;
            }
            if (dev_to_del != null && dev_cl != null) break;
        }
        if (dev_to_del == null || dev_cl == null) {
            StringBuffer o = new StringBuffer("Device ");
            o.append(dev_name);
            o.append(" not found");
            Except.throw_exception("API_DeviceNotFound", new String(o), "Dserver.restart()");
        }
        dev_list.removeElementAt(j);
        assert (dev_to_del != null);
        Vector p_obj = dev_to_del.get_poll_obj_list();
        Vector dev_pol = new Vector();
        for (i = 0; i < p_obj.size(); ++i) {
            dev_pol.add(p_obj.elementAt(i));
        }
        if (dev_pol.size() > 0) {
            this.stop_polling();
        }
        POA r_poa = tg.get_poa();
        if (dev_to_del.get_exported_flag()) {
            try {
                r_poa.deactivate_object(dev_to_del.get_obj_id());
            }
            catch (WrongPolicy ex) {
            }
            catch (ObjectNotActive ex) {
                // empty catch block
            }
        }
        String[] dev_name_list = new String[]{dev_name};
        assert (dev_cl != null);
        dev_cl.device_factory(dev_name_list);
        DevVarLongStringArray send = new DevVarLongStringArray();
        send.lvalue = new int[1];
        send.svalue = new String[3];
        for (i = 0; i < dev_pol.size(); ++i) {
            PollObj poll_obj = (PollObj)dev_pol.elementAt(i);
            send.lvalue[0] = poll_obj.get_upd_i();
            send.svalue[0] = poll_obj.get_name();
            send.svalue[1] = poll_obj.type == 0 ? "command" : "attribute";
            send.svalue[2] = poll_obj.name;
            try {
                this.add_obj_polling(send, false);
                continue;
            }
            catch (DevFailed e) {
                if (Util._tracelevel < 4) continue;
                Except.print_exception(e);
            }
        }
    }

    public void restart_server() throws DevFailed {
        Util.out4.println("In DServer.restart_server() method");
        this.set_state(DevState.ON);
        this.set_status("The device is ON");
        MultiAttribute tmp = new MultiAttribute(this.device_name, this.get_device_class());
        this.set_device_attr(tmp);
        if (!this.class_list.isEmpty()) {
            int nb_class = this.class_list.size();
            POA r_poa = Util.instance().get_poa();
            for (int j = 0; j < nb_class; ++j) {
                Vector v = ((DeviceClass)this.class_list.elementAt(j)).get_device_list();
                int nb_dev = v.size();
                for (int k = 0; k < nb_dev; ++k) {
                    DeviceImpl dev = (DeviceImpl)v.elementAt(k);
                    if (!dev.get_exported_flag()) continue;
                    dev.delete_device();
                    try {
                        r_poa.deactivate_object(((DeviceImpl)v.elementAt(k)).get_obj_id());
                        continue;
                    }
                    catch (WrongPolicy ex) {
                        ex.printStackTrace();
                        continue;
                    }
                    catch (ObjectNotActive ex) {
                        ex.printStackTrace();
                    }
                }
                v.removeAllElements();
                ((DeviceClass)this.class_list.elementAt(j)).initClass();
            }
            this.class_list.removeAllElements();
            System.out.println("DServer.restart_server - class list " + this.class_list);
        }
        this.init_device();
        Util.instance().polling_configure();
    }

    public void kill() {
        Util.out4.println("In Kill command");
        int nb_class = this.class_list.size();
        for (int j = 0; j < nb_class; ++j) {
            Vector v = ((DeviceClass)this.class_list.elementAt(j)).get_device_list();
            int nb_dev = v.size();
            for (int k = 0; k < nb_dev; ++k) {
                DeviceImpl dev = (DeviceImpl)v.elementAt(k);
                if (!dev.get_exported_flag()) continue;
                try {
                    dev.delete_device();
                    continue;
                }
                catch (DevFailed e) {
                    e.printStackTrace();
                }
            }
        }
        KillThread killer = new KillThread();
        killer.start();
    }

    public String get_process_name() {
        return this.process_name;
    }

    public String get_personal_name() {
        return this.instance_name;
    }

    public String get_instance_name() {
        return this.instance_name;
    }

    public String get_full_name() {
        return new String(this.full_name);
    }

    public Vector get_class_list() {
        return this.class_list;
    }

    @Override
    public Logger get_logger() {
        return Logging.core_logger();
    }

    @Override
    public void init_logger() {
    }

    String[] polled_device() {
        Util.out4.println("In polled_device command");
        int nb_class = this.class_list.size();
        Vector<String> dev_name = new Vector<String>();
        for (int i = 0; i < nb_class; ++i) {
            DeviceClass dc = (DeviceClass)this.class_list.elementAt(i);
            int nb_dev = dc.get_device_list().size();
            for (int j = 0; j < nb_dev; ++j) {
                DeviceImpl dev = dc.get_device_at(j);
                if (!dev.is_polled()) continue;
                dev_name.add(dev.get_name());
            }
        }
        if (dev_name.size() == 0) {
            Util.out4.println("Return an empty sequence because no devices are polled");
            return new String[0];
        }
        MyComp comp = new MyComp();
        Collections.sort(dev_name, comp);
        int nb_dev = dev_name.size();
        String[] ret = new String[nb_dev];
        for (int i = 0; i < nb_dev; ++i) {
            ret[i] = (String)dev_name.elementAt(i);
        }
        return ret;
    }

    synchronized String[] dev_poll_status(String dev_name) throws DevFailed {
        Util.out4.println("In dev_poll_status command");
        DeviceImpl dev = Util.instance().get_device_by_name(dev_name);
        Vector poll_list = dev.get_poll_obj_list();
        int nb_poll_obj = poll_list.size();
        if (nb_poll_obj == 0) {
            return new String[0];
        }
        int nb_cmd = 0;
        for (int i = 0; i < nb_poll_obj; ++i) {
            PollObj poll_obj = (PollObj)poll_list.elementAt(i);
            if (poll_obj.get_type() != 0) continue;
            ++nb_cmd;
        }
        String[] ret = new String[nb_poll_obj];
        int cmd_ind = 0;
        int attr_ind = nb_cmd;
        for (int i = 0; i < nb_poll_obj; ++i) {
            PollObj poll_obj = (PollObj)poll_list.elementAt(i);
            int type = poll_obj.get_type();
            String returned_info = type == 0 ? "Polled command name = " : "Polled attribute name = ";
            returned_info = returned_info + poll_obj.get_name();
            returned_info = returned_info + "\nPolling period (mS) = ";
            int tmp = poll_obj.get_upd();
            returned_info = returned_info + tmp;
            returned_info = returned_info + "\nPolling ring buffer depth = ";
            int depth = dev.get_poll_ring_depth();
            returned_info = depth == 0 ? returned_info + 10 : returned_info + depth;
            if (poll_obj.is_ring_empty()) {
                returned_info = returned_info + "\nNo data recorded yet";
            } else {
                int nb_msec;
                int tv_usec;
                returned_info = returned_info + "\nTime needed for the last ";
                returned_info = type == 0 ? returned_info + "command execution (mS) = " : returned_info + "attribute reading (mS) = ";
                returned_info = returned_info + poll_obj.get_needed_time_i();
                returned_info = returned_info + "\nData not updated since ";
                double since = poll_obj.get_last_insert_date_i();
                long ctm = System.currentTimeMillis();
                int tv_sec = (int)(ctm / 1000L);
                double now_d = (double)tv_sec + (double)(tv_usec = (int)(ctm - (long)(1000 * tv_sec)) * 1000) / 1000000.0;
                double diff_t = now_d - since;
                if (diff_t < 1.0) {
                    int nb_msec2 = (int)(diff_t * 1000.0);
                    returned_info = returned_info + nb_msec2 + " mS";
                } else if (diff_t < 60.0) {
                    int nb_sec = (int)diff_t;
                    int nb_msec3 = (int)((diff_t - (double)nb_sec) * 1000.0);
                    returned_info = returned_info + nb_sec + " S and ";
                    returned_info = returned_info + nb_msec3 + " mS";
                } else {
                    int nb_min = (int)(diff_t / 60.0);
                    int nb_sec = (int)(diff_t - (double)(60 * nb_min));
                    nb_msec = (int)((diff_t - (double)((int)diff_t)) * 1000.0);
                    returned_info = returned_info + nb_min + " MN";
                    if (nb_sec != 0) {
                        returned_info = returned_info + " ," + nb_sec + " S";
                    }
                    if (nb_msec != 0) {
                        returned_info = returned_info + " and " + nb_msec + " mS";
                    }
                }
                try {
                    returned_info = returned_info + "\nDelta between last records (in mS) = ";
                    double[] delta = poll_obj.get_delta_t_i(4);
                    for (int j = 0; j < delta.length; ++j) {
                        nb_msec = (int)(delta[j] * 1000.0);
                        returned_info = returned_info + nb_msec;
                        if (j == delta.length - 1) continue;
                        returned_info = returned_info + ", ";
                    }
                }
                catch (DevFailed e) {
                    // empty catch block
                }
                if (poll_obj.is_last_an_error_i()) {
                    returned_info = type == 0 ? returned_info + "\nLast command execution FAILED :" : returned_info + "\nLast attribute read FAILED :";
                    DevFailed ex = poll_obj.get_last_except_i();
                    returned_info = returned_info + "\n\tReason = " + ex.errors[0].reason;
                    returned_info = returned_info + "\n\tDesc = " + ex.errors[0].desc;
                    returned_info = returned_info + "\n\tOrigin = " + ex.errors[0].origin;
                }
            }
            if (type == 0) {
                ret[cmd_ind] = returned_info;
                ++cmd_ind;
                continue;
            }
            ret[attr_ind] = returned_info;
            ++attr_ind;
        }
        return ret;
    }

    public void add_obj_polling(DevVarLongStringArray argin) throws DevFailed {
        this.add_obj_polling(argin, true);
    }

    public void add_obj_polling(DevVarLongStringArray argin, boolean with_db_upd) throws DevFailed {
        Util.out4.println("In add_obj_polling command");
        for (String value : argin.svalue) {
            Util.out4.println("Input string = " + value);
        }
        for (int value : argin.lvalue) {
            Util.out4.println("Input long = " + value);
        }
        if (argin.svalue.length != 3 || argin.lvalue.length != 1) {
            Except.throw_exception("API_WrongNumberOfArgs", "Incorrect number of inout arguments", "DServer.add_obj_polling");
        }
        Util util = Util.instance();
        DeviceImpl dev = null;
        try {
            dev = util.get_device_by_name(argin.svalue[0]);
        }
        catch (DevFailed e) {
            Except.re_throw_exception(e, "API_DeviceNotFound", "Device " + argin.svalue[0] + " not found", "DServer.add_obj_polling");
        }
        String obj_type = argin.svalue[1].toLowerCase();
        String obj_name = argin.svalue[2].toLowerCase();
        int type = 0;
        assert (dev != null);
        if (obj_type.equals("command")) {
            dev.check_command_exists(obj_name);
            type = 0;
        } else if (obj_type.equals("attribute")) {
            dev.get_device_attr().get_attr_by_name(obj_name);
            type = 1;
        } else {
            Except.throw_exception("API_NotSupported", "Object type " + obj_type + " not supported", "DServer.add_obj_polling");
        }
        if (type == 0 && obj_name.equals("Init")) {
            Except.throw_exception("API_NotSupported", "It's not possible to poll the Init command!", "DServer.add_obj_polling");
        }
        Vector poll_list = dev.get_poll_obj_list();
        for (int i = 0; i < poll_list.size(); ++i) {
            PollObj poll_obj = (PollObj)poll_list.elementAt(i);
            if (poll_obj.get_type() != type || !poll_obj.get_name().equals(obj_name)) continue;
            String s = type == 0 ? "Command " : "Attribute ";
            Except.throw_exception("API_AlreadyPolled", s + " " + obj_name + " already polled", "DServer.add_obj_polling");
        }
        int upd = argin.lvalue[0];
        if (upd < 20 && upd != 0) {
            Except.throw_exception("API_NotSupported", upd + " is below the min authorized period (100 mS)", "DServer.add_obj_polling");
        }
        poll_list.add(new PollObj(dev, type, obj_name, upd));
        Util.out4.println("Sending cmd to polling thread");
        TangoMonitor mon = util.get_poll_monitor();
        PollThCmd shared_cmd = util.get_poll_shared_cmd();
        if (shared_cmd.cmd_pending) {
            mon.wait_it();
        }
        shared_cmd.cmd_pending = true;
        shared_cmd.cmd_code = 0;
        shared_cmd.dev = dev;
        shared_cmd.index = poll_list.size() - 1;
        mon.signal();
        Util.out4.println("Cmd sent to polling thread");
        while (shared_cmd.cmd_pending) {
            boolean interupted = mon.wait_it(3000L);
            if (!shared_cmd.cmd_pending || interupted) continue;
            Util.out4.println("TIME OUT");
            poll_list.remove(poll_list.size() - 1);
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "DServer.add_obj_polling");
        }
        Util.out4.println("Thread cmd normally executed");
        if (with_db_upd && Util._UseDb) {
            Vector non_auto_list;
            String upd_str = "" + upd;
            boolean found = false;
            DbDatum db_info = new DbDatum("polled_cmd");
            if (type == 0) {
                non_auto_list = dev.get_non_auto_polled_cmd();
                for (int i = 0; i < non_auto_list.size(); ++i) {
                    String s = (String)non_auto_list.elementAt(i);
                    if (!s.equals(obj_name)) continue;
                    non_auto_list.remove(i);
                    db_info.name = "non_auto_polled_cmd";
                    db_info.insert(this.stringVect2StringArray(non_auto_list));
                    found = true;
                    break;
                }
                if (!found) {
                    int i;
                    Vector cmd_list = dev.get_polled_cmd();
                    for (i = 0; i < cmd_list.size(); i += 2) {
                        String s = (String)cmd_list.elementAt(i);
                        if (!s.equals(obj_name)) continue;
                        cmd_list.remove(i + 1);
                        cmd_list.insertElementAt(upd_str, i + 1);
                        break;
                    }
                    if (i == cmd_list.size()) {
                        cmd_list.add(obj_name);
                        cmd_list.add(upd_str);
                    }
                    db_info.insert(this.stringVect2StringArray(cmd_list));
                }
            } else {
                non_auto_list = dev.get_non_auto_polled_attr();
                for (int i = 0; i < non_auto_list.size(); ++i) {
                    String s = (String)non_auto_list.elementAt(i);
                    if (!s.equals(obj_name)) continue;
                    non_auto_list.remove(i);
                    db_info.name = "non_auto_polled_attr";
                    db_info.insert(this.stringVect2StringArray(non_auto_list));
                    found = true;
                    break;
                }
                if (!found) {
                    int i;
                    db_info.name = "polled_attr";
                    Vector attr_list = dev.get_polled_attr();
                    for (i = 0; i < attr_list.size(); i += 2) {
                        String s = (String)attr_list.elementAt(i);
                        if (!s.equals(obj_name)) continue;
                        attr_list.remove(i + 1);
                        attr_list.insertElementAt(upd_str, i + 1);
                        break;
                    }
                    if (i == attr_list.size()) {
                        attr_list.add(obj_name);
                        attr_list.add(upd_str);
                    }
                    db_info.insert(this.stringVect2StringArray(attr_list));
                }
            }
            DbDatum[] send_data = new DbDatum[]{db_info};
            dev.get_db_device().put_property(send_data);
            Util.out4.println("Polling properties updated");
        }
        dev.is_polled(true);
    }

    void upd_obj_polling(DevVarLongStringArray argin) throws DevFailed {
        this.upd_obj_polling(argin, true);
    }

    void upd_obj_polling(DevVarLongStringArray argin, boolean with_db_upd) throws DevFailed {
        Util.out4.println("In upd_obj_polling command");
        for (String value : argin.svalue) {
            Util.out4.println("Input string = " + value);
        }
        for (int value : argin.lvalue) {
            Util.out4.println("Input long = " + value);
        }
        if (argin.svalue.length != 3 || argin.lvalue.length != 1) {
            Except.throw_exception("API_WrongNumberOfArgs", "Incorrect number of inout arguments", "DServer.upd_obj_polling");
        }
        Util util = Util.instance();
        DeviceImpl dev = null;
        try {
            dev = util.get_device_by_name(argin.svalue[0]);
        }
        catch (DevFailed e) {
            Except.re_throw_exception(e, "API_DeviceNotFound", "Device " + argin.svalue[0] + " not found", "DServer.upd_obj_polling");
        }
        assert (dev != null);
        if (!dev.is_polled()) {
            Except.throw_exception("API_DeviceNotPolled", "Device " + argin.svalue[0] + " is not polled", "DServer.upd_obj_polling_period");
        }
        String obj_type = argin.svalue[1].toLowerCase();
        String obj_name = argin.svalue[2].toLowerCase();
        int type = 0;
        if (obj_type.equals("command")) {
            type = 0;
        } else if (obj_type.equals("attribute")) {
            type = 1;
        } else {
            Except.throw_exception("API_NotSupported", "Object type " + obj_type + " not supported", "DServer.upd_obj_polling_period");
        }
        Vector poll_list = dev.get_poll_obj_list();
        for (int i = 0; i < poll_list.size(); ++i) {
            PollObj poll_obj = (PollObj)poll_list.elementAt(i);
            if (poll_obj.get_type() != type || !poll_obj.get_name().equals(obj_name)) continue;
            poll_obj.update_upd(argin.lvalue[0]);
        }
        TangoMonitor mon = util.get_poll_monitor();
        PollThCmd shared_cmd = util.get_poll_shared_cmd();
        if (shared_cmd.cmd_pending) {
            mon.wait_it();
        }
        shared_cmd.cmd_pending = true;
        shared_cmd.cmd_code = 4;
        shared_cmd.dev = dev;
        shared_cmd.name = obj_name;
        shared_cmd.type = type;
        shared_cmd.new_upd = argin.lvalue[0];
        mon.signal();
        if (with_db_upd && Util._UseDb) {
            String upd_str = "" + argin.lvalue[0];
            DbDatum db_info = new DbDatum("polled_attr");
            if (type == 0) {
                int i;
                db_info.name = "polled_cmd";
                Vector cmd_list = dev.get_polled_cmd();
                for (i = 0; i < cmd_list.size(); i += 2) {
                    String s = (String)cmd_list.elementAt(i);
                    if (!s.equals(obj_name)) continue;
                    cmd_list.remove(i + 1);
                    cmd_list.insertElementAt(upd_str, i + 1);
                    break;
                }
                if (i == cmd_list.size()) {
                    cmd_list.add(obj_name);
                    cmd_list.add(upd_str);
                }
                db_info.insert(this.stringVect2StringArray(cmd_list));
            } else {
                int i;
                Vector attr_list = dev.get_polled_attr();
                for (i = 0; i < attr_list.size(); i += 2) {
                    String s = (String)attr_list.elementAt(i);
                    if (!s.equals(obj_name)) continue;
                    attr_list.remove(i + 1);
                    attr_list.insertElementAt(upd_str, i + 1);
                    break;
                }
                if (i == attr_list.size()) {
                    attr_list.add(obj_name);
                    attr_list.add(upd_str);
                }
                db_info.insert(this.stringVect2StringArray(attr_list));
            }
            DbDatum[] send_data = new DbDatum[]{db_info};
            dev.get_db_device().put_property(send_data);
            Util.out4.println("Polling properties updated");
        }
    }

    public void rem_obj_polling(String[] argin) throws DevFailed {
        this.rem_obj_polling(argin, Util._UseDb);
    }

    public synchronized void rem_obj_polling(String[] argin, boolean with_db_upd) throws DevFailed {
        Util.out4.println("In rem_obj_polling command");
        for (String arg : argin) {
            Util.out4.println("Input string = " + arg);
        }
        if (argin.length != 3) {
            Except.throw_exception("API_WrongNumberOfArgs", "Incorrect number of inout arguments", "DServer.rem_obj_polling");
        }
        Util tg = Util.instance();
        DeviceImpl dev = null;
        try {
            dev = tg.get_device_by_name(argin[0]);
        }
        catch (DevFailed e) {
            Except.re_throw_exception(e, "API_DeviceNotFound", "Device " + argin + " not found", "DServer.rem_obj_polling");
        }
        assert (dev != null);
        if (!dev.is_polled()) {
            Except.throw_exception("API_DeviceNotPolled", "Device " + argin[0] + " is not polled", "DServer.rem_obj_polling_period");
        }
        String obj_type = argin[1].toLowerCase();
        String obj_name = argin[2].toLowerCase();
        int type = 0;
        if (obj_type.equals("command")) {
            type = 0;
        } else if (obj_type.equals("attribute")) {
            type = 1;
        } else {
            Except.throw_exception("API_NotSupported", "Object type " + obj_type + " not supported", "DServer.rem_obj_polling_period");
        }
        Vector poll_list = dev.get_poll_obj_list();
        for (int i = 0; i < poll_list.size(); ++i) {
            PollObj poll_obj = (PollObj)poll_list.elementAt(i);
            if (poll_obj.get_type() != type || !poll_obj.get_name().equals(obj_name)) continue;
            poll_list.remove(i);
        }
        Util.out4.println("Sending cmd to polling thread");
        TangoMonitor mon = tg.get_poll_monitor();
        PollThCmd shared_cmd = tg.get_poll_shared_cmd();
        if (shared_cmd.cmd_pending) {
            mon.signal();
        }
        shared_cmd.cmd_pending = true;
        shared_cmd.cmd_code = 1;
        shared_cmd.dev = dev;
        shared_cmd.name = obj_name;
        shared_cmd.type = type;
        mon.signal();
        Util.out4.println("Cmd sent to polling thread");
        while (shared_cmd.cmd_pending) {
            boolean interrupted = mon.wait_it(3000L);
            if (!shared_cmd.cmd_pending || interrupted) continue;
            System.out.println("TIME OUT");
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "DServer.rem_obj_polling");
        }
        Util.out4.println("Thread cmd normally executed");
        if (poll_list.size() == 0) {
            dev.is_polled(false);
        }
        if (with_db_upd && Util._UseDb) {
            DbDatum db_info = new DbDatum("polled_attr");
            boolean update_needed = false;
            if (type == 0) {
                int i;
                db_info.name = "polled_cmd";
                Vector cmd_list = dev.get_polled_cmd();
                for (i = 0; i < cmd_list.size(); ++i) {
                    String s = (String)cmd_list.elementAt(i);
                    if (s.equals(obj_name)) {
                        cmd_list.remove(i);
                        cmd_list.remove(i);
                        db_info.insert(this.stringVect2StringArray(cmd_list));
                        update_needed = true;
                        break;
                    }
                    ++i;
                }
                if (!update_needed) {
                    String s;
                    Vector non_auto_cmd = dev.get_non_auto_polled_cmd();
                    for (i = 0; i < non_auto_cmd.size() && !(s = (String)non_auto_cmd.elementAt(i)).equals(obj_name); ++i) {
                    }
                    if (i == cmd_list.size()) {
                        non_auto_cmd.add(obj_name);
                        db_info.name = "non_auto_polled_cmd";
                        db_info.insert(this.stringVect2StringArray(non_auto_cmd));
                        update_needed = true;
                    }
                }
            } else {
                int i;
                Vector attr_list = dev.get_polled_attr();
                for (i = 0; i < attr_list.size(); ++i) {
                    String s = (String)attr_list.elementAt(i);
                    if (s.equals(obj_name)) {
                        attr_list.remove(i);
                        attr_list.remove(i);
                        db_info.insert(this.stringVect2StringArray(attr_list));
                        update_needed = true;
                        break;
                    }
                    ++i;
                }
                if (!update_needed) {
                    String s;
                    Vector non_auto_attr = dev.get_non_auto_polled_attr();
                    for (i = 0; i < non_auto_attr.size() && !(s = (String)non_auto_attr.elementAt(i)).equals(obj_name); ++i) {
                    }
                    if (i == attr_list.size()) {
                        non_auto_attr.add(obj_name);
                        db_info.name = "non_auto_polled_cmd";
                        db_info.insert(this.stringVect2StringArray(non_auto_attr));
                        update_needed = true;
                    }
                }
            }
            if (update_needed) {
                DbDatum[] send_data = new DbDatum[]{db_info};
                dev.get_db_device().put_property(send_data);
                Util.out4.println("Polling properties updated");
            }
        }
    }

    synchronized void stop_polling() throws DevFailed {
        Util.out4.println("In stop_polling method");
        Util tg = Util.instance();
        TangoMonitor mon = tg.get_poll_monitor();
        PollThCmd shared_cmd = tg.get_poll_shared_cmd();
        if (shared_cmd.cmd_pending) {
            mon.signal();
        }
        shared_cmd.cmd_pending = true;
        shared_cmd.cmd_code = 3;
        mon.signal();
        while (shared_cmd.cmd_pending) {
            boolean interupted = mon.wait_it(3000L);
            if (!shared_cmd.cmd_pending || interupted) continue;
            Util.out4.println("TIME OUT");
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "DServer.stop_polling");
        }
        tg.poll_status(false);
        this.set_status("The device is ON\nThe polling is OFF");
    }

    synchronized void start_polling() throws DevFailed {
        Util.out4.println("In start_polling method");
        Util tg = Util.instance();
        TangoMonitor mon = tg.get_poll_monitor();
        PollThCmd shared_cmd = tg.get_poll_shared_cmd();
        if (shared_cmd.cmd_pending) {
            mon.signal();
        }
        shared_cmd.cmd_pending = true;
        shared_cmd.cmd_code = 2;
        mon.signal();
        while (shared_cmd.cmd_pending) {
            boolean interupted = mon.wait_it(3000L);
            if (!shared_cmd.cmd_pending || interupted) continue;
            Util.out4.println("TIME OUT");
            Except.throw_exception("API_CommandTimedOut", "Polling thread blocked !!!", "DServer.start_polling");
        }
        tg.poll_status(true);
        this.set_status("The device is ON\nThe polling is ON");
    }

    private String[] stringVect2StringArray(Vector v) {
        String[] array = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            array[i] = (String)v.elementAt(i);
        }
        return array;
    }

    @Override
    public void delete_device() throws DevFailed {
        this.class_list.clear();
    }
}

