/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import java.util.Hashtable;

class KeepAliveThread
extends Thread
implements TangoConst {
    private static final long EVENT_RESUBSCRIBE_PERIOD = 600000L;
    private static final long EVENT_HEARTBEAT_PERIOD = 10000L;
    private static boolean stop = false;
    private static KeepAliveThread instance = null;

    private KeepAliveThread() {
        this.setName("KeepAliveThread");
    }

    @Override
    public void run() {
        while (!stop) {
            long t0 = System.currentTimeMillis();
            try {
                EventConsumer.subscribeIfNotDone();
                this.resubscribe_if_needed();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Error err) {
                err.printStackTrace();
            }
            long msToSleep = 10000L - (System.currentTimeMillis() - t0);
            if (msToSleep < 5L) {
                msToSleep = 5L;
            }
            this.waitNextLoop(msToSleep);
        }
    }

    private synchronized void waitNextLoop(long ms) {
        try {
            this.wait(ms);
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
    }

    synchronized void stopThread() {
        stop = true;
        if (instance != null) {
            this.notify();
        }
        instance = null;
    }

    static KeepAliveThread getInstance() {
        if (instance == null) {
            instance = new KeepAliveThread();
            instance.start();
        }
        return instance;
    }

    static boolean heartbeatHasBeenSkipped(EventChannelStruct eventChannelStruct) {
        long now = System.currentTimeMillis();
        return now - eventChannelStruct.last_heartbeat > 10000L;
    }

    private void resubscribe_if_needed() {
        Enumeration<String> channel_names = EventConsumer.getChannelMap().keys();
        long now = System.currentTimeMillis();
        while (channel_names.hasMoreElements()) {
            String name = channel_names.nextElement();
            EventChannelStruct eventChannelStruct = EventConsumer.getChannelMap().get(name);
            if (now - eventChannelStruct.last_subscribed > 200000L) {
                this.reSubscribeByName(eventChannelStruct, name);
            }
            eventChannelStruct.consumer.checkIfHeartbeatSkipped(name, eventChannelStruct);
        }
    }

    private void reSubscribeByName(EventChannelStruct eventChannelStruct, String name) {
        Hashtable<String, EventCallBackStruct> callBackMap = EventConsumer.getEventCallbackMap();
        EventCallBackStruct callbackStruct = null;
        Enumeration<String> channelNames = callBackMap.keys();
        while (channelNames.hasMoreElements()) {
            String key = channelNames.nextElement();
            EventCallBackStruct eventStruct = callBackMap.get(key);
            if (!eventStruct.channel_name.equals(name)) continue;
            callbackStruct = eventStruct;
        }
        if (callbackStruct != null) {
            callbackStruct.consumer.reSubscribeByName(eventChannelStruct, name);
        }
    }
}

