/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IIORDumpDAO;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;

public class IORDumpDAODefaultImpl
implements IIORDumpDAO {
    private String iorString = null;
    private String type_id = null;
    private String iiopVersion = null;
    private String host = null;
    private String hostname = "";
    private int port = -1;
    private int prg_number = -1;
    private String deviceName = null;
    List<NetworkConnection> connections = new ArrayList<NetworkConnection>();

    @Override
    public void init(IORdump iORdump, String devname, String iorString) throws DevFailed {
        this.deviceName = devname == null ? "unknown" : devname;
        if (iorString == null) {
            DeviceProxy dev = new DeviceProxy(devname);
            iorString = dev.get_ior();
        } else {
            this.iorString = iorString;
        }
        if (iorString != null) {
            if (iorString.equals("nada")) {
                this.iorString = null;
            } else {
                this.iorAnalysis(iORdump, iorString);
            }
        }
    }

    @Override
    public void init(IORdump iORdump, String devname) throws DevFailed {
        this.deviceName = devname;
        DeviceProxy dev = new DeviceProxy(devname);
        this.iorString = dev.get_ior();
        if (this.iorString != null) {
            if (this.iorString.equals("nada")) {
                this.iorString = null;
            } else {
                this.iorAnalysis(iORdump, this.iorString);
            }
        }
    }

    @Override
    public void init(IORdump iORdump, DeviceProxy dev) throws DevFailed {
        this.deviceName = dev.name();
        this.iorString = dev.get_ior();
        if (this.iorString != null) {
            if (this.iorString.equals("nada")) {
                this.iorString = null;
            } else {
                this.iorAnalysis(iORdump, this.iorString);
            }
        }
    }

    @Override
    public String toString(IORdump iORdump) {
        if (this.iorString == null) {
            return "No IOR found in database for " + this.deviceName + "\n" + "(Maybe, the device has never been exported...)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Device:          ").append(this.deviceName).append("\n");
        sb.append("type_id:         ").append(this.get_type_id()).append("\n");
        if (!iORdump.is_taco) {
            sb.append("iiop_version:    ").append(this.get_iiop_version()).append("\n");
        }
        sb.append("host:            ").append(this.get_host()).append("\n");
        List<String> alternates = this.getAlternateAddresses();
        if (alternates.size() > 0) {
            for (String add : alternates) {
                sb.append("alternate addr.: ").append(add).append("\n");
            }
        }
        if (!iORdump.is_taco) {
            sb.append("port:            ").append(this.get_port());
        } else {
            sb.append("prg number:      ").append(this.get_prg_number());
        }
        return sb.toString();
    }

    private void iorAnalysis(IORdump iORdump, String iorString) throws DevFailed {
        if (iorString == null) {
            return;
        }
        if (iorString.startsWith("rpc:")) {
            iORdump.is_taco = true;
            this.type_id = "Taco";
            this.host = iorString.substring("rpc:".length(), iorString.indexOf(":", "rpc:".length() + 1));
            String s = iorString.substring(iorString.indexOf(":", "rpc:".length() + 1) + 1);
            this.prg_number = Integer.parseInt(s);
            return;
        }
        if (!iorString.startsWith("IOR:")) {
            return;
        }
        ParsedIOR pior = new ParsedIOR((ORB)ApiUtil.get_orb(), iorString);
        IOR ior = pior.getIOR();
        this.type_id = ior.type_id;
        List<Profile> profiles = pior.getProfiles();
        for (Profile profile : profiles) {
            IIOPProfile p = (IIOPProfile)profile;
            this.iiopVersion = "" + p.version().major + "." + p.version().minor;
            try {
                this.connections.add(new NetworkConnection((IIOPAddress)p.getAddress()));
                List<IIOPAddress> alternates = p.getAlternateAddresses();
                for (IIOPAddress alternate : alternates) {
                    this.connections.add(new NetworkConnection(alternate));
                }
            }
            catch (Exception e) {
                this.host = " (" + e + ")";
            }
            if (this.connections.isEmpty()) {
                Except.throw_exception("NO_NETWORK_FOUND", "Failed to found network connection", "IORdump.iorAnalysis()");
            }
            NetworkConnection connection = this.connections.get(0);
            this.hostname = connection.name;
            this.host = this.hostname + " (" + connection.address + ")";
            this.port = connection.port;
        }
    }

    @Override
    public String get_type_id() {
        return this.type_id;
    }

    @Override
    public String get_host() {
        return this.host;
    }

    @Override
    public String get_hostname() {
        return this.hostname;
    }

    @Override
    public int get_port() {
        return this.port;
    }

    @Override
    public int get_prg_number() {
        return this.prg_number;
    }

    @Override
    public String get_iiop_version() {
        return this.iiopVersion;
    }

    public List<String> getAlternateAddresses() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < this.connections.size(); ++i) {
            NetworkConnection connection = this.connections.get(i);
            String address = connection.address;
            if (!connection.name.equals(connection.address)) {
                address = address + " (" + connection.name + ")";
            }
            list.add(address);
        }
        return list;
    }

    private class GetHostNameThread
    extends Thread {
        private InetAddress inetAddress;
        private String hostName = null;

        private GetHostNameThread(InetAddress inetAddress) {
            this.inetAddress = inetAddress;
        }

        @Override
        public void run() {
            this.hostName = this.inetAddress.getHostName();
        }
    }

    private class NetworkConnection {
        private String name;
        private String address;
        private int port;

        private NetworkConnection(IIOPAddress iiopAddress) throws UnknownHostException {
            String originalHost = iiopAddress.getOriginalHost();
            InetAddress inetAddress = InetAddress.getByName(originalHost);
            this.address = inetAddress.getHostAddress();
            GetHostNameThread thread = new GetHostNameThread(inetAddress);
            thread.start();
            try {
                thread.join(100L);
            }
            catch (InterruptedException e) {
                System.err.println(e.toString());
            }
            this.name = thread.hostName != null ? thread.hostName : this.address;
            this.port = iiopAddress.getPort();
            if (this.port < 0) {
                this.port += 65536;
            }
        }
    }
}

