/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class HostInfo {
    private static String name = null;
    private static String address = null;
    private static boolean trace;
    private static Vector<String> addresses;

    private HostInfo() throws DevFailed {
        String env = System.getenv("TraceAddresses");
        boolean bl = trace = env != null && env.equals("true");
        if (trace) {
            System.out.println("HostInfo.HostInfo()");
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                InetAddress inetAddress;
                Enumeration<InetAddress> inetAddresses;
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback()) {
                    if (!trace) continue;
                    System.out.println("----------------- " + networkInterface.getName() + " --------------------");
                    inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        inetAddress = inetAddresses.nextElement();
                        System.out.println("getCanonicalHostName(): " + inetAddress.getCanonicalHostName());
                        System.out.println("getHostName():          " + inetAddress.getHostName());
                        System.out.println("getHostAddress():       " + inetAddress.getHostAddress());
                    }
                    continue;
                }
                inetAddresses = networkInterface.getInetAddresses();
                if (trace) {
                    System.out.println("----------------- " + networkInterface.getName() + " --------------------");
                }
                while (inetAddresses.hasMoreElements()) {
                    inetAddress = inetAddresses.nextElement();
                    if (trace) {
                        System.out.println("getCanonicalHostName(): " + inetAddress.getCanonicalHostName());
                        System.out.println("getHostName():          " + inetAddress.getHostName());
                        System.out.println("getHostAddress():       " + inetAddress.getHostAddress());
                    }
                    if (networkInterface.getName().startsWith("docker")) continue;
                    this.checkInetAddress(inetAddress);
                }
            }
        }
        catch (SocketException e) {
            System.err.println(e.toString());
            Except.throw_exception("TangoApi_SocketException", e.toString(), "HostInfo.HostInfo()");
        }
        if (name == null || address == null) {
            System.err.println("Host name/address cannot be determined !");
            Except.throw_exception("TangoApi_NetworkSystemException", "Host name/address cannot be determined !", "HostInfo.HostInfo()");
        }
    }

    private boolean checkInetAddress(InetAddress inetAddress) {
        if (!inetAddress.getCanonicalHostName().startsWith("local")) {
            if (!inetAddress.getCanonicalHostName().equalsIgnoreCase(inetAddress.getHostAddress())) {
                addresses.add(inetAddress.getHostAddress());
                if (this.isIPV4address(inetAddress.getHostAddress())) {
                    name = inetAddress.getCanonicalHostName();
                    address = inetAddress.getHostAddress();
                    return true;
                }
            } else if (trace) {
                System.err.println("Warning: at least one getCanonicalHostName() returns " + inetAddress.getCanonicalHostName() + "\n  Check files /etc/resolv.conf and /etc/nsswitch.conf ");
            }
        }
        return false;
    }

    private boolean isIPV4address(String address) {
        StringTokenizer st = new StringTokenizer(address, ".");
        ArrayList<String> nodes = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            nodes.add(st.nextToken());
        }
        return nodes.size() == 4;
    }

    public static String getName() throws DevFailed {
        if (name == null) {
            new HostInfo();
        }
        return name;
    }

    public static String getAddress() throws DevFailed {
        if (address == null) {
            new HostInfo();
        }
        return address;
    }

    public static Vector<String> getAddresses() throws DevFailed {
        if (address == null) {
            new HostInfo();
        }
        return addresses;
    }

    private static String toStaticString() {
        String str = "";
        try {
            if (name == null) {
                new HostInfo();
            }
            str = str + "name:          " + name + "\n";
            str = str + "address:       " + address + "\n";
        }
        catch (DevFailed e) {
            str = e.errors[0].desc;
        }
        return str;
    }

    public static void main(String[] args) {
        System.out.println(HostInfo.toStaticString());
    }

    static {
        addresses = new Vector();
    }
}

