/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.Group;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.Group.GroupAttrReply;
import fr.esrf.TangoApi.Group.GroupAttrReplyList;
import fr.esrf.TangoApi.Group.GroupCmdReply;
import fr.esrf.TangoApi.Group.GroupCmdReplyList;
import fr.esrf.TangoApi.Group.GroupElement;
import fr.esrf.TangoApi.Group.GroupReply;
import fr.esrf.TangoApi.Group.GroupReplyList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class GroupDeviceElement
extends GroupElement
implements Serializable {
    private final Map<Integer, AsynchRequest> arp;
    private DeviceProxy proxy;

    public GroupDeviceElement(String name) {
        super(name);
        try {
            this.proxy = new DeviceProxy(name);
        }
        catch (DevFailed df) {
            this.proxy = null;
        }
        this.arp = new HashMap<Integer, AsynchRequest>();
    }

    @Override
    void dump_i(int indent_level) {
        for (int i = 0; i < indent_level; ++i) {
            System.out.print("  ");
        }
        System.out.println("`-> Device: " + this.get_name());
    }

    @Override
    DeviceProxy get_device_i(String n) {
        return this.name_equals(n) ? this.proxy : null;
    }

    @Override
    DeviceProxy get_device_i(int i) {
        return --i == 0 ? this.proxy : null;
    }

    @Override
    boolean ping_i(boolean fwd) {
        if (this.proxy == null) {
            return false;
        }
        try {
            this.proxy.ping();
        }
        catch (DevFailed df) {
            return false;
        }
        return true;
    }

    @Override
    void set_timeout_millis(int timeout, boolean fwd) throws DevFailed {
        try {
            this.proxy.set_timeout_millis(timeout);
        }
        catch (DevFailed df) {
            throw df;
        }
        catch (Exception e) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "unknown exception caught";
            errors[0].desc = "unknown error";
            errors[0].origin = "GroupDeviceElemnt.set_indidual_timeout_millis";
            DevFailed ex = new DevFailed(errors);
            throw ex;
        }
    }

    @Override
    int command_inout_asynch_i(String c, boolean fgt, boolean fwd, int rid) throws DevFailed {
        block5: {
            try {
                int actual_rid = this.proxy.command_inout_asynch(c, fgt);
                if (!fgt) {
                    this.arp.put(new Integer(rid), new AsynchRequest(actual_rid, c));
                }
            }
            catch (DevFailed df) {
                if (!fgt) {
                    this.arp.put(new Integer(rid), new AsynchRequest(-1, c, df));
                }
            }
            catch (Exception e) {
                if (fgt) break block5;
                DevError[] errors = new DevError[]{new DevError()};
                errors[0].severity = ErrSeverity.ERR;
                errors[0].reason = "unknown exception caught";
                errors[0].desc = "unknown error";
                errors[0].origin = "GroupDeviceElemnt.command_inout";
                DevFailed ex = new DevFailed(errors);
                this.arp.put(new Integer(rid), new AsynchRequest(-1, c, ex));
            }
        }
        return rid;
    }

    @Override
    int command_inout_asynch_i(String c, DeviceData dd, boolean fgt, boolean fwd, int rid) throws DevFailed {
        block5: {
            try {
                int actual_rid = this.proxy.command_inout_asynch(c, dd, fgt);
                if (!fgt) {
                    this.arp.put(new Integer(rid), new AsynchRequest(actual_rid, c));
                }
            }
            catch (DevFailed df) {
                if (!fgt) {
                    this.arp.put(new Integer(rid), new AsynchRequest(-1, c, df));
                }
            }
            catch (Exception e) {
                if (fgt) break block5;
                DevError[] errors = new DevError[]{new DevError()};
                errors[0].severity = ErrSeverity.ERR;
                errors[0].reason = "unknown exception caught";
                errors[0].desc = "unknown error";
                errors[0].origin = "GroupDeviceElemnt.command_inout";
                DevFailed ex = new DevFailed(errors);
                this.arp.put(new Integer(rid), new AsynchRequest(-1, c, ex));
            }
        }
        return rid;
    }

    @Override
    GroupCmdReplyList command_inout_reply_i(int rid, int tmo, boolean fwd) throws DevFailed {
        Integer rid_obj = new Integer(rid);
        GroupCmdReplyList rl = new GroupCmdReplyList();
        AsynchRequest ar = this.arp.get(rid_obj);
        if (ar == null) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "API_BadAsynPollId";
            errors[0].desc = "Invalid asynch. request identifier specified";
            errors[0].origin = "GroupDeviceElement.command_inout_reply";
            DevFailed e = new DevFailed(errors);
            rl.add(new GroupCmdReply(this.get_name(), "unknown", e));
            return rl;
        }
        if (ar.req_id == -1) {
            for (String element : ar.obj_name) {
                rl.add(new GroupCmdReply(this.get_name(), element, ar.exception));
            }
            this.arp.remove(rid_obj);
            return rl;
        }
        try {
            DeviceData dd = this.proxy.command_inout_reply(ar.req_id, tmo);
            for (String element : ar.obj_name) {
                rl.add(new GroupCmdReply(this.get_name(), element, dd));
            }
        }
        catch (AsynReplyNotArrived na) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "API_AsynReplyNotArrived";
            errors[0].desc = "No reply for asynch request";
            errors[0].origin = "GroupDeviceElement.command_inout_reply";
            DevFailed e = new DevFailed(errors);
            for (String element : ar.obj_name) {
                rl.add(new GroupCmdReply(this.get_name(), element, e));
            }
        }
        catch (DevFailed df) {
            for (String element : ar.obj_name) {
                rl.add(new GroupCmdReply(this.get_name(), element, df));
            }
        }
        catch (Exception ex) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "unknown exception caught";
            errors[0].desc = "unknown error";
            errors[0].origin = "GroupDeviceElemnt.command_inout";
            DevFailed e = new DevFailed(errors);
            for (String element : ar.obj_name) {
                rl.add(new GroupCmdReply(this.get_name(), element, e));
            }
        }
        this.arp.remove(rid_obj);
        return rl;
    }

    @Override
    int read_attribute_asynch_i(String[] a, boolean fwd, int rid) throws DevFailed {
        try {
            int actual_rid = this.proxy.read_attribute_asynch(a);
            this.arp.put(new Integer(rid), new AsynchRequest(actual_rid, a));
        }
        catch (DevFailed df) {
            this.arp.put(new Integer(rid), new AsynchRequest(-1, a, df));
        }
        catch (Exception e) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "unknown exception caught";
            errors[0].desc = "unknown error";
            errors[0].origin = "GroupDeviceElemnt.read_attribute";
            DevFailed ex = new DevFailed(errors);
            this.arp.put(new Integer(rid), new AsynchRequest(-1, a, ex));
        }
        return rid;
    }

    @Override
    int read_attribute_asynch_i(String a, boolean fwd, int rid) throws DevFailed {
        try {
            int actual_rid = this.proxy.read_attribute_asynch(a);
            this.arp.put(new Integer(rid), new AsynchRequest(actual_rid, a));
        }
        catch (DevFailed df) {
            this.arp.put(new Integer(rid), new AsynchRequest(-1, a, df));
        }
        catch (Exception e) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "unknown exception caught";
            errors[0].desc = "unknown error";
            errors[0].origin = "GroupDeviceElemnt.read_attribute";
            DevFailed ex = new DevFailed(errors);
            this.arp.put(new Integer(rid), new AsynchRequest(-1, a, ex));
        }
        return rid;
    }

    @Override
    GroupAttrReplyList read_attribute_reply_i(int rid, int tmo, boolean fwd) throws DevFailed {
        Integer rid_obj = new Integer(rid);
        GroupAttrReplyList rl = new GroupAttrReplyList();
        AsynchRequest ar = this.arp.get(rid_obj);
        if (ar == null) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "API_BadAsynPollId";
            errors[0].desc = "Invalid asynch. request identifier specified";
            errors[0].origin = "GroupDeviceElement.read_attribute_reply";
            DevFailed e = new DevFailed(errors);
            rl.add(new GroupAttrReply(this.get_name(), "unknown", e));
            return rl;
        }
        if (ar.req_id == -1) {
            for (String element : ar.obj_name) {
                rl.add(new GroupAttrReply(this.get_name(), element, ar.exception));
            }
            this.arp.remove(rid_obj);
            return rl;
        }
        try {
            DeviceAttribute[] das = this.proxy.read_attribute_reply(ar.req_id, tmo);
            int i = 0;
            for (String element : ar.obj_name) {
                rl.add(new GroupAttrReply(this.get_name(), element, das[i++]));
            }
        }
        catch (AsynReplyNotArrived na) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "API_AsynReplyNotArrived";
            errors[0].desc = "No reply for asynch request";
            errors[0].origin = "GroupDeviceElement.read_attribute_reply";
            DevFailed e = new DevFailed(errors);
            for (String element : ar.obj_name) {
                rl.add(new GroupAttrReply(this.get_name(), element, e));
            }
        }
        catch (DevFailed df) {
            for (String element : ar.obj_name) {
                rl.add(new GroupAttrReply(this.get_name(), element, df));
            }
        }
        catch (Exception ex) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "unknown exception caught";
            errors[0].desc = "unknown error";
            errors[0].origin = "GroupDeviceElemnt.read_attribute_reply";
            DevFailed e = new DevFailed(errors);
            for (String element : ar.obj_name) {
                rl.add(new GroupAttrReply(this.get_name(), element, e));
            }
        }
        this.arp.remove(rid_obj);
        return rl;
    }

    @Override
    int write_attribute_asynch_i(DeviceAttribute da, boolean fwd, int rid) throws DevFailed {
        try {
            int actual_rid = this.proxy.write_attribute_asynch(da);
            this.arp.put(new Integer(rid), new AsynchRequest(actual_rid, da.getName()));
        }
        catch (DevFailed df) {
            this.arp.put(new Integer(rid), new AsynchRequest(-1, da.getName(), df));
        }
        catch (Exception e) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "unknown exception caught";
            errors[0].desc = "unknown error";
            errors[0].origin = "GroupDeviceElemnt.write_attribute";
            DevFailed ex = new DevFailed(errors);
            this.arp.put(new Integer(rid), new AsynchRequest(-1, da.getName(), ex));
        }
        return rid;
    }

    @Override
    GroupReplyList write_attribute_reply_i(int rid, int tmo, boolean fwd) throws DevFailed {
        Integer rid_obj = new Integer(rid);
        GroupReplyList rl = new GroupReplyList();
        AsynchRequest ar = this.arp.get(rid_obj);
        if (ar == null) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "API_BadAsynPollId";
            errors[0].desc = "Invalid asynch. request identifier specified";
            errors[0].origin = "GroupDeviceElement.write_attribute_reply";
            DevFailed e = new DevFailed(errors);
            rl.add(new GroupReply(this.get_name(), "unknown", e));
            return rl;
        }
        if (ar.req_id == -1) {
            for (String element : ar.obj_name) {
                rl.add(new GroupReply(this.get_name(), element, ar.exception));
            }
            this.arp.remove(rid_obj);
            return rl;
        }
        try {
            this.proxy.write_attribute_reply(ar.req_id, tmo);
            for (String element : ar.obj_name) {
                rl.add(new GroupReply(this.get_name(), element));
            }
        }
        catch (AsynReplyNotArrived na) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "API_AsynReplyNotArrived";
            errors[0].desc = "No reply for asynch request";
            errors[0].origin = "GroupDeviceElement.write_attribute_reply";
            DevFailed e = new DevFailed(errors);
            for (String element : ar.obj_name) {
                rl.add(new GroupReply(this.get_name(), element, e));
            }
        }
        catch (DevFailed df) {
            for (String element : ar.obj_name) {
                rl.add(new GroupReply(this.get_name(), element, df));
            }
        }
        catch (Exception ex) {
            DevError[] errors = new DevError[]{new DevError()};
            errors[0].severity = ErrSeverity.ERR;
            errors[0].reason = "unknown exception caught";
            errors[0].desc = "unknown error";
            errors[0].origin = "GroupDeviceElemnt.write_attribute_reply";
            DevFailed e = new DevFailed(errors);
            for (String element : ar.obj_name) {
                rl.add(new GroupReply(this.get_name(), element, e));
            }
        }
        this.arp.remove(rid_obj);
        return rl;
    }

    private class AsynchRequest {
        public int req_id;
        public String[] obj_name;
        public DevFailed exception;

        AsynchRequest(int _req_id, String _obj_name) {
            this.req_id = _req_id;
            this.obj_name = new String[1];
            this.obj_name[0] = _obj_name;
            this.exception = null;
        }

        AsynchRequest(int _req_id, String[] _obj_name) {
            this.req_id = _req_id;
            this.obj_name = _obj_name;
            this.exception = null;
        }

        AsynchRequest(int _req_id, String _obj_name, DevFailed _exception) {
            this.req_id = _req_id;
            this.obj_name = new String[1];
            this.obj_name[0] = _obj_name;
            this.exception = _exception;
        }

        AsynchRequest(int _req_id, String[] _obj_name, DevFailed _exception) {
            this.req_id = _req_id;
            this.obj_name = _obj_name;
            this.exception = _exception;
        }
    }
}

