/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.multicast;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.InvokerReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ClassHierarchyIntrospector {
    public static Method equals;
    public static Method hashCode;

    private ClassHierarchyIntrospector() {
    }

    public static Class[] getAllInterfaces(Object[] objects) {
        HashSet interfaces = new HashSet();
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            ClassHierarchyIntrospector.getInterfaces(objects[i].getClass(), interfaces);
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Class[] getAllInterfaces(Class clazz) {
        HashSet interfaces = new HashSet();
        ClassHierarchyIntrospector.getInterfaces(clazz, interfaces);
        interfaces.remove(InvokerReference.class);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private static void getInterfaces(Class clazz, Set interfaces) {
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        while (clazz != null) {
            Class<?>[] implemented = clazz.getInterfaces();
            for (int i = 0; i < implemented.length; ++i) {
                if (interfaces.contains(implemented[i])) continue;
                ClassHierarchyIntrospector.getInterfaces(implemented[i], interfaces);
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static Class getMostCommonSuperclass(Object[] objects) {
        Class clazz = null;
        boolean found = false;
        if (objects != null && objects.length > 0) {
            block0: while (!found) {
                for (int i = 0; i < objects.length; ++i) {
                    found = true;
                    if (objects[i] == null) continue;
                    Class currentClazz = objects[i].getClass();
                    if (clazz == null) {
                        clazz = currentClazz;
                    }
                    if (clazz.isAssignableFrom(currentClazz)) continue;
                    if (currentClazz.isAssignableFrom(clazz)) {
                        clazz = currentClazz;
                        continue;
                    }
                    clazz = clazz.getSuperclass();
                    found = false;
                    continue block0;
                }
            }
        }
        if (clazz == null) {
            clazz = Object.class;
        }
        return clazz;
    }

    public static Class[] addIfClassProxyingSupportedAndNotObject(Class clazz, Class[] interfaces, ProxyFactory proxyFactory) {
        Class[] result;
        if (proxyFactory.canProxy(ArrayList.class) && !clazz.equals(Object.class)) {
            result = new Class[interfaces.length + 1];
            result[0] = clazz;
            System.arraycopy(interfaces, 0, result, 1, interfaces.length);
        } else {
            result = interfaces;
        }
        return result;
    }

    static {
        try {
            equals = Object.class.getMethod("equals", Object.class);
            hashCode = Object.class.getMethod("hashCode", null);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError();
        }
        catch (SecurityException e) {
            throw new InternalError();
        }
    }
}

