/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

import de.desy.tine.definitions.TFormat;
import de.desy.tine.xmlUtils.ValidatedInt;

public class ValidatedFormat {
    private boolean valid;
    private int format;
    private String tag;
    private int arrayType;

    public boolean isValid() {
        return this.valid;
    }

    public ValidatedInt getFormat() {
        return new ValidatedInt(this.format, this.valid);
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setFormat(int value) {
        this.format = value;
    }

    public ValidatedFormat() {
        this.valid = false;
        this.format = 0;
    }

    public void set(int value, boolean valid) {
        this.valid = valid;
        this.format = value;
    }

    public ValidatedFormat(int format, String tag, int arrayType, boolean valid) {
        this.valid = valid;
        this.format = format;
        this.tag = tag;
        this.arrayType = arrayType;
    }

    public String toString() {
        return "[" + Integer.toString(this.format) + "," + (this.valid ? " VALID]" : "NOT VALID]");
    }

    static ValidatedFormat parse(String s) {
        if (s == null || s.length() == 0) {
            return new ValidatedFormat(255, "", 0, false);
        }
        short fmt = TFormat.getFormatCode(s);
        String tag = TFormat.getFormatTag(s);
        short atyp = TFormat.getFormatArrayType(s);
        return new ValidatedFormat(fmt, tag, atyp, true);
    }

    public int getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(int arrayType) {
        this.arrayType = arrayType;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

