/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.xmlUtils.TineConfigItem;
import de.desy.tine.xmlUtils.ValidatedInt;
import de.desy.tine.xmlUtils.ValidatedTolerance;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HistoryCfg
extends TineConfigItem {
    private String deviceName = new String("");
    private ValidatedTolerance tolerance = new ValidatedTolerance();
    private String redirection = new String("");
    private ValidatedInt index = new ValidatedInt();
    private ValidatedInt heartbeat = new ValidatedInt();
    private ValidatedInt pollRate = new ValidatedInt();
    private ValidatedInt archiveRate = new ValidatedInt();
    private ValidatedInt depthShort = new ValidatedInt();
    private ValidatedInt depthLong = new ValidatedInt();

    public ValidatedInt getArchiveRate() {
        return this.archiveRate;
    }

    public HistoryCfg(String name) {
        super(name);
    }

    public ValidatedInt getDepthLong() {
        return this.depthLong;
    }

    public ValidatedInt getDepthShort() {
        return this.depthShort;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public ValidatedInt getHeartbeat() {
        return this.heartbeat;
    }

    public ValidatedInt getIndex() {
        return this.index;
    }

    public ValidatedInt getPollRate() {
        return this.pollRate;
    }

    public String getRedirection() {
        return this.redirection;
    }

    public ValidatedTolerance getTolerance() {
        return this.tolerance;
    }

    public void setArchiveRate(ValidatedInt archiveRate) {
        this.archiveRate = archiveRate;
    }

    public void setDepthLong(ValidatedInt depthLong) {
        this.depthLong = depthLong;
    }

    public void setDepthShort(ValidatedInt depthShort) {
        this.depthShort = depthShort;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setHeartbeat(ValidatedInt heartbeat) {
        this.heartbeat = heartbeat;
    }

    public void setIndex(ValidatedInt index) {
        this.index = index;
    }

    public void setPollRate(ValidatedInt pollRate) {
        this.pollRate = pollRate;
    }

    public void setRedirection(String redirection) {
        this.redirection = redirection;
    }

    public void setTolerance(ValidatedTolerance tolerance) {
        this.tolerance = tolerance;
    }

    void dump(int margin) {
        String m = new String("");
        for (int i = 0; i < margin; ++i) {
            m = m + " ";
        }
        System.out.println(m + "Device name = " + this.getDeviceName());
        System.out.println(m + "Tolerance = " + this.getTolerance());
        System.out.println(m + "Redirection = " + this.getRedirection());
        System.out.println(m + "Index = " + this.getIndex());
        System.out.println(m + "Heartbeat = " + this.getHeartbeat());
        System.out.println(m + "Poll rate = " + this.getPollRate());
        System.out.println(m + "Archive rate = " + this.getArchiveRate());
        System.out.println(m + "Depth short = " + this.getDepthShort());
        System.out.println(m + "Depth long = " + this.getDepthLong());
    }

    void parse(Element root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Text textNode;
            Node child = children.item(i);
            if (!(child instanceof Element) || (textNode = (Text)(childElement = (Element)child).getFirstChild()) == null) continue;
            String text = textNode.getData().trim();
            if (childElement.getTagName().equalsIgnoreCase("DEVICE_NAME")) {
                this.setDeviceName(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("TOLERANCE")) {
                this.setTolerance(ValidatedTolerance.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("REDIRECTION")) {
                this.setRedirection(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("INDEX")) {
                this.setIndex(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("HEARTBEAT")) {
                this.setHeartbeat(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("POLL_RATE")) {
                this.setPollRate(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ARCHIVE_RATE")) {
                this.setArchiveRate(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DEPTH_SHORT")) {
                this.setDepthShort(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DEPTH_LONG")) {
                this.setDepthLong(ValidatedInt.parse(text));
                continue;
            }
            MsgLog.log("HistoryCfg", "-WARNING: unsupported tag: " + childElement.getTagName(), 136, null, 0);
        }
    }
}

