/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

import de.desy.tine.xmlUtils.AliasCfg;
import de.desy.tine.xmlUtils.EqmCfg;
import de.desy.tine.xmlUtils.TineConfigItem;
import de.desy.tine.xmlUtils.ValidatedInt;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FecCfg
extends TineConfigItem {
    private String name = new String("");
    private String historyHome = new String("");
    private String context = new String("");
    private String subsystem = new String("");
    private String description = new String("");
    private String hardware = new String("");
    private String location = new String("");
    private String responsible = new String("");
    private ValidatedInt portOffset = new ValidatedInt();
    private LinkedList<AliasCfg> aliasList = new LinkedList();
    private LinkedList<EqmCfg> eqms = new LinkedList();

    public LinkedList<AliasCfg> getAliasList() {
        return this.aliasList;
    }

    public FecCfg(String name) {
        super(name);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }

    public String getHardware() {
        return this.hardware;
    }

    public LinkedList<EqmCfg> getEqmList() {
        return this.eqms;
    }

    public String getHistoryHome() {
        return this.historyHome;
    }

    public String getName() {
        return this.name;
    }

    public ValidatedInt getPortOffset() {
        return this.portOffset;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public void setResponsible(String responsible) {
        this.responsible = responsible;
    }

    public void setAliasList(LinkedList<AliasCfg> aliasList) {
        this.aliasList = aliasList;
    }

    public void setEqmList(LinkedList<EqmCfg> eqms) {
        this.eqms = eqms;
    }

    public void setHistoryHome(String historyHome) {
        this.historyHome = historyHome;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPortOffset(ValidatedInt portOffset) {
        this.portOffset = portOffset;
    }

    @Override
    void dump(int margin) {
        String m = new String("");
        for (int i = 0; i < margin; ++i) {
            m = m + " ";
        }
        System.out.println(m + "Name = " + this.getName());
        System.out.println(m + "Alias Table :");
        for (AliasCfg a : this.aliasList) {
            a.dump(margin + 3);
            System.out.println();
        }
        System.out.println(m + "Location = " + this.getLocation());
        System.out.println(m + "Description = " + this.getDescription());
        System.out.println(m + "Context = " + this.getContext());
        System.out.println(m + "Subsystem = " + this.getSubsystem());
        System.out.println(m + "Hardware = " + this.getHardware());
        System.out.println(m + "Port Offset = " + this.getPortOffset().toString());
        System.out.println(m + "History home = " + this.getHistoryHome());
        int idx = 0;
        for (EqmCfg e : this.eqms) {
            System.out.println(m + "EQM[" + idx++ + "]");
            e.dump(margin + 3);
        }
    }

    @Override
    void parse(Element root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Text textNode;
            Node child = children.item(i);
            if (!(child instanceof Element) || (textNode = (Text)(childElement = (Element)child).getFirstChild()) == null) continue;
            String text = textNode.getData().trim();
            if (childElement.getTagName().equalsIgnoreCase("NAME")) {
                this.setName(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("PORT_OFFSET")) {
                this.setPortOffset(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("HISTORY_HOME")) {
                this.setHistoryHome(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("LOCATION")) {
                this.setLocation(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("HARDWARE")) {
                this.setHardware(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALIAS")) {
                AliasCfg ac = new AliasCfg("ALIAS");
                this.aliasList.add(ac);
                ac.parse(childElement);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("CONTEXT")) {
                this.setContext(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SUBSYSTEM")) {
                this.setSubsystem(text);
                continue;
            }
            if (!childElement.getTagName().equalsIgnoreCase("EQM")) continue;
            EqmCfg ec = new EqmCfg("EQM");
            this.eqms.add(ec);
            ec.parse(childElement);
        }
    }
}

