/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

import de.desy.tine.xmlUtils.TineConfigItem;
import de.desy.tine.xmlUtils.ValidatedInt;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AlarmDefinitionCfg
extends TineConfigItem {
    private String tag = new String("");
    private ValidatedInt dataFormat = new ValidatedInt();
    private String alarmText = new String("");
    private String deviceText = new String("");
    private String dataText = new String("");
    private String url = new String("");
    private ValidatedInt alarmCode = new ValidatedInt();
    private ValidatedInt alarmMask = new ValidatedInt();
    private ValidatedInt severity = new ValidatedInt();
    private ValidatedInt alarmSystem = new ValidatedInt();
    private ValidatedInt dataSize = new ValidatedInt();

    public AlarmDefinitionCfg(String name) {
        super(name);
    }

    public ValidatedInt getAlarmCode() {
        return this.alarmCode;
    }

    public ValidatedInt getAlarmMask() {
        return this.alarmMask;
    }

    public ValidatedInt getAlarmSystem() {
        return this.alarmSystem;
    }

    public String getAlarmText() {
        return this.alarmText;
    }

    public ValidatedInt getDataFormat() {
        return this.dataFormat;
    }

    public ValidatedInt getDataSize() {
        return this.dataSize;
    }

    public String getDataText() {
        return this.dataText;
    }

    public String getDeviceText() {
        return this.deviceText;
    }

    public ValidatedInt getSeverity() {
        return this.severity;
    }

    public String getTag() {
        return this.tag;
    }

    public String getUrl() {
        return this.url;
    }

    public void setAlarmCode(ValidatedInt alarmCode) {
        this.alarmCode = alarmCode;
    }

    public void setAlarmMask(ValidatedInt alarmMask) {
        this.alarmMask = alarmMask;
    }

    public void setAlarmSystem(ValidatedInt alarmSystem) {
        this.alarmSystem = alarmSystem;
    }

    public void setAlarmText(String alarmText) {
        this.alarmText = alarmText;
    }

    public void setDataFormat(ValidatedInt dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setDataSize(ValidatedInt dataSize) {
        this.dataSize = dataSize;
    }

    public void setDataText(String dataText) {
        this.dataText = dataText;
    }

    public void setDeviceText(String deviceText) {
        this.deviceText = deviceText;
    }

    public void setSeverity(ValidatedInt severity) {
        this.severity = severity;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    void dump(int margin) {
        String m = new String("");
        for (int i = 0; i < margin; ++i) {
            m = m + " ";
        }
        System.out.println(m + "Tag = " + this.getTag());
        System.out.println(m + "Data Format = " + this.getDataFormat());
        System.out.println(m + "Alarm text = " + this.getDataText());
        System.out.println(m + "Device text = " + this.getDeviceText());
        System.out.println(m + "Url = " + this.getUrl());
        System.out.println(m + "Alarm code = " + this.getAlarmCode());
        System.out.println(m + "Alarm mask = " + this.getAlarmMask());
        System.out.println(m + "Severity = " + this.getSeverity());
        System.out.println(m + "Alarm system = " + this.getAlarmSystem());
        System.out.println(m + "Data size = " + this.getDataSize());
    }

    void parse(Element root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Text textNode;
            Node child = children.item(i);
            if (!(child instanceof Element) || (textNode = (Text)(childElement = (Element)child).getFirstChild()) == null) continue;
            String text = textNode.getData().trim();
            if (childElement.getTagName().equalsIgnoreCase("TAG")) {
                this.setTag(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DATA_FORMAT")) {
                this.setDataFormat(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALARM_TEXT")) {
                this.setAlarmText(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DEVICE_TEXT")) {
                this.setDeviceText(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DATA_TEXT")) {
                this.setDataText(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("URL")) {
                this.setUrl(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALARM_CODE")) {
                this.setAlarmCode(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALARM_MASK")) {
                this.setAlarmMask(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SEVERITY")) {
                this.setSeverity(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALARM_SYSTEM")) {
                this.setAlarmSystem(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DATA_SIZE")) {
                this.setDataSize(ValidatedInt.parse(text));
                continue;
            }
            System.out.println("-WARNING: unsupported tag: " + childElement.getTagName());
        }
    }
}

