/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class UNAME
implements TCompoundDataObject {
    public int ival;
    public float f1val;
    public float f2val;
    public float f3val;
    public String str;
    public static final int sizeInBytes = 32;
    public static final short dFormat = 46;
    ByteArrayOutputStream dBuffer;
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.f1val;
    }

    public int getIntegerValue() {
        return this.ival;
    }

    public String toString() {
        return "[" + this.ival + ", " + this.f1val + ", " + this.f2val + ", " + this.f3val + ", " + this.str + "]";
    }

    public void setValues(int newIValue, float newF1Value, float newF2Value, float newF3Value, String newString) {
        this.ival = newIValue;
        this.f1val = newF1Value;
        this.f2val = newF2Value;
        this.f3val = newF3Value;
        this.str = newString;
    }

    public void setString(String newString) {
        this.str = newString;
    }

    public String getString() {
        return this.str;
    }

    public int getSizeInBytes() {
        return 32;
    }

    public short getFormat() {
        return 46;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public UNAME() {
        this.f1val = 0.0f;
        this.f2val = 0.0f;
        this.ival = 0;
        this.f3val = 0.0f;
        this.str = "";
    }

    public UNAME(float f1, String s) {
        this.f1val = f1;
        this.f2val = 0.0f;
        this.ival = 0;
        this.f3val = 0.0f;
        this.str = s;
    }

    public UNAME(float f1, float f2, String s) {
        this.f1val = f1;
        this.f2val = f2;
        this.ival = 0;
        this.f3val = 0.0f;
        this.str = s;
    }

    public UNAME(int i, String s) {
        this.f1val = 0.0f;
        this.f2val = 0.0f;
        this.ival = i;
        this.f3val = 0.0f;
        this.str = s;
    }

    public UNAME(int i, float f1, float f2, float f3, String s) {
        this.f1val = f1;
        this.f2val = f2;
        this.ival = i;
        this.f3val = f3;
        this.str = s;
    }

    public UNAME(UNAME instance) {
        this.f1val = instance.f1val;
        this.f2val = instance.f2val;
        this.ival = instance.ival;
        this.f3val = instance.f3val;
        this.str = new String(instance.str);
    }

    public boolean equals(UNAME instance) {
        if (instance.ival != this.ival) {
            return false;
        }
        if (instance.f1val != this.f1val) {
            return false;
        }
        if (instance.f2val != this.f2val) {
            return false;
        }
        if (instance.f3val != this.f3val) {
            return false;
        }
        if (instance.str == null || this.str == null) {
            return false;
        }
        return instance.str.compareTo(this.str) == 0;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer = new ByteArrayOutputStream(32);
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.writeInt(Swap.Long(this.ival));
            byte[] b = Swap.Float(this.f1val);
            ds.write(b, 0, 4);
            b = Swap.Float(this.f2val);
            ds.write(b, 0, 4);
            b = Swap.Float(this.f3val);
            ds.write(b, 0, 4);
            b = this.str.getBytes();
            int len = b.length;
            if (len < 16) {
                ds.write(this.str.getBytes(), 0, len);
                b = new byte[16];
                ds.write(b, 0, 16 - len);
            } else {
                ds.write(this.str.getBytes(), 0, 16);
            }
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            int i;
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            this.ival = Swap.Long(ds.readInt());
            byte[] b = new byte[80];
            ds.read(b, 0, 4);
            this.f1val = Swap.Float(b);
            ds.read(b, 0, 4);
            this.f2val = Swap.Float(b);
            ds.read(b, 0, 4);
            this.f3val = Swap.Float(b);
            ds.read(b, 0, 16);
            for (i = 0; i < 16 && b[i] != 0; ++i) {
            }
            this.str = new String(b).substring(0, i);
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.f1val);
        result = 31 * result + Float.floatToIntBits(this.f2val);
        result = 31 * result + Float.floatToIntBits(this.f3val);
        result = 31 * result + this.ival;
        result = 31 * result + (this.str == null ? 0 : this.str.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UNAME other = (UNAME)obj;
        return this.equals(other);
    }
}

