/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class NAME64DBL
implements TCompoundDataObject {
    public String name;
    public double dval;
    public static final int sizeInBytes = 72;
    public static final short dFormat = 54;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(72);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.dval;
    }

    public int getIntegerValue() {
        return (int)this.dval;
    }

    public void setValues(String newName, double newDValue) {
        this.name = newName;
        this.dval = newDValue;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public int getSizeInBytes() {
        return 72;
    }

    public short getFormat() {
        return 54;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public NAME64DBL() {
        this.name = new String(new StringBuffer(64));
        this.dval = 0.0;
    }

    public NAME64DBL(String Name2) {
        this.name = Name2;
        this.dval = 0.0;
    }

    public NAME64DBL(String Name2, double d) {
        this.name = Name2;
        this.dval = d;
    }

    public NAME64DBL(NAME64DBL instance) {
        this.name = instance.name == null ? new String(new StringBuffer(64)) : new String(instance.name);
        this.dval = instance.dval;
    }

    public String toString() {
        return "[" + this.name + ", " + this.dval + "]";
    }

    public byte[] toByteArray() {
        if (this.name == null) {
            this.name = new String(new StringBuffer(64));
        }
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bname = this.name.getBytes();
            byte[] b = new byte[64];
            for (int i = 0; i < 64 && i < bname.length; ++i) {
                b[i] = bname[i];
            }
            ds.write(b, 0, b.length);
            byte[] db = Swap.Double(this.dval);
            ds.write(db, 0, 8);
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAME64DBL", "could not prepare byte stream", 66, e, 0);
            return null;
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[72];
            ds.read(b, 0, 64);
            int len = 0;
            int i = 0;
            while (i < 64 && b[i] != 0) {
                ++i;
                ++len;
            }
            this.name = new String(b, 0, len);
            byte[] db = new byte[8];
            ds.read(db, 0, 8);
            this.dval = Swap.Double(db);
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAME64DBL", "could not prepare byte stream", 66, e, 0);
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.dval);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NAME64DBL other = (NAME64DBL)obj;
        if (Double.doubleToLongBits(this.dval) != Double.doubleToLongBits(other.dval)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

