/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class NAME16DBLDBL
implements TCompoundDataObject {
    public String name;
    public double d1val;
    public double d2val;
    public static final int sizeInBytes = 32;
    public static final short dFormat = 41;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(32);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.d1val;
    }

    public int getIntegerValue() {
        return (int)this.d2val;
    }

    public void setValues(String newName, double newD1Value, double newD2Value) {
        this.name = newName;
        this.d1val = newD1Value;
        this.d2val = newD2Value;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public int getSizeInBytes() {
        return 32;
    }

    public short getFormat() {
        return 41;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public NAME16DBLDBL() {
        this.name = new String(new StringBuffer(16));
        this.d1val = 0.0;
        this.d2val = 0.0;
    }

    public NAME16DBLDBL(String Name2) {
        this.name = Name2;
        this.d1val = 0.0;
        this.d2val = 0.0;
    }

    public NAME16DBLDBL(String Name2, double d) {
        this.name = Name2;
        this.d1val = d;
        this.d2val = 0.0;
    }

    public NAME16DBLDBL(String Name2, double d1, double d2) {
        this.name = Name2;
        this.d1val = d1;
        this.d2val = d2;
    }

    public NAME16DBLDBL(String Name2, int d1, int d2) {
        this.name = Name2;
        this.d1val = d1;
        this.d2val = d2;
    }

    public NAME16DBLDBL(String Name2, float d1, int d2) {
        this.name = Name2;
        this.d1val = d1;
        this.d2val = d2;
    }

    public String toString() {
        return "[" + this.name + "," + this.d1val + "," + this.d2val + "]";
    }

    public NAME16DBLDBL(NAME16DBLDBL instance) {
        this.name = instance.name == null ? new String(new StringBuffer(16)) : new String(instance.name);
        this.d1val = instance.d1val;
        this.d2val = instance.d2val;
    }

    public boolean equals(NAME16DBLDBL instance) {
        if (instance.name == null || this.name == null) {
            return false;
        }
        if (instance.name.compareTo(this.name) != 0) {
            return false;
        }
        if (instance.d1val != this.d1val) {
            return false;
        }
        return instance.d2val == this.d2val;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bname = this.name.getBytes();
            byte[] b = new byte[16];
            for (int i = 0; i < 16 && i < bname.length; ++i) {
                b[i] = bname[i];
            }
            ds.write(b, 0, b.length);
            byte[] db = Swap.Double(this.d1val);
            ds.write(db, 0, 8);
            db = Swap.Double(this.d2val);
            ds.write(db, 0, 8);
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAME16DBLDBL", "could not prepare byte stream", 66, e, 0);
            return null;
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[32];
            ds.read(b, 0, 16);
            int len = 0;
            int i = 0;
            while (i < 16 && b[i] != 0) {
                ++i;
                ++len;
            }
            this.name = new String(b, 0, len);
            byte[] db = new byte[8];
            ds.read(db, 0, 8);
            this.d1val = Swap.Double(db);
            ds.read(db, 0, 8);
            this.d2val = Swap.Double(db);
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAME16DBLDBL", "could not prepare byte stream", 66, e, 0);
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.d1val);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.d2val);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NAME16DBLDBL other = (NAME16DBLDBL)obj;
        return this.equals(other);
    }
}

