/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IMAGE
implements TCompoundDataObject {
    private SourceHeader sourceHeader = new SourceHeader();
    private FrameHeader frameHeader = new FrameHeader();
    private byte[] imageFrame = null;
    private byte[] hHeaderByteArray = new byte[TFormat.getFormatHeaderSize((short)55)];
    private int sizeInBytes = TFormat.getFormatHeaderSize((short)55);
    ByteArrayOutputStream dBuffer;

    private static long UnsignedInt(int ival) {
        long lval = ival;
        if (lval < 0L) {
            lval += 0x100000000L;
        }
        return lval;
    }

    public void setImageFrameBuffer(byte[] buffer) {
        this.imageFrame = buffer;
        this.sizeInBytes = TFormat.getFormatHeaderSize((short)55) + this.imageFrame.length;
    }

    public byte[] getImageFrameBuffer() {
        return this.imageFrame;
    }

    public void setHeaderBytes(DataInputStream dis) throws IOException {
        dis.read(this.hHeaderByteArray);
    }

    public void setImageBytes(DataInputStream dis) throws IOException {
        dis.read(this.imageFrame);
    }

    public void setImageBytes(DataInputStream dis, int off, int len) throws IOException {
        dis.read(this.imageFrame, off, len);
    }

    public int getImageFrameSize() {
        return this.imageFrame.length;
    }

    public int getHeaderSize() {
        return TFormat.getFormatHeaderSize((short)55);
    }

    private void readImageSourceHeader(DataInputStream dis) throws IOException {
        this.sourceHeader.baseTag = Swap.Long(dis.readInt());
        this.sourceHeader.cameraPortId = IMAGE.UnsignedInt(Swap.Long(dis.readInt()));
        this.sourceHeader.versionTag = IMAGE.UnsignedInt(Swap.Long(dis.readInt()));
        this.sourceHeader.totalLength = IMAGE.UnsignedInt(Swap.Long(dis.readInt()));
        this.sourceHeader.timestampSeconds = Swap.Long(dis.readInt());
        this.sourceHeader.timestampMicroseconds = Swap.Long(dis.readInt());
        byte[] b = new byte[64];
        dis.read(b, 0, 64);
        this.sourceHeader.cameraPortName = new String(b).trim();
    }

    private void writeImageSourceHeader(DataOutputStream ds) throws IOException {
        ds.writeInt(Swap.Long(this.sourceHeader.baseTag));
        ds.writeInt(Swap.Long(this.sourceHeader.cameraPortId));
        ds.writeInt(Swap.Long(this.sourceHeader.versionTag));
        ds.writeInt(Swap.Long(this.sourceHeader.totalLength));
        ds.writeInt(Swap.Long(this.sourceHeader.timestampSeconds));
        ds.writeInt(Swap.Long(this.sourceHeader.timestampMicroseconds));
        byte[] b = new byte[64];
        ds.write(this.sourceHeader.cameraPortName.getBytes());
        ds.write(b, 0, 64 - this.sourceHeader.cameraPortName.length());
    }

    private void readImageFrameHeader(DataInputStream dis) throws IOException {
        this.frameHeader.sourceWidth = Swap.Long(dis.readInt());
        this.frameHeader.sourceHeight = Swap.Long(dis.readInt());
        this.frameHeader.aoiWidth = Swap.Long(dis.readInt());
        this.frameHeader.aoiHeight = Swap.Long(dis.readInt());
        this.frameHeader.xStart = Swap.Long(dis.readInt());
        this.frameHeader.yStart = Swap.Long(dis.readInt());
        this.frameHeader.bytesPerPixel = Swap.Long(dis.readInt());
        this.frameHeader.effectiveBitsPerPixel = Swap.Long(dis.readInt());
        this.frameHeader.horizontalBinning = Swap.Long(dis.readInt());
        this.frameHeader.verticalBinning = Swap.Long(dis.readInt());
        this.frameHeader.sourceFormat = Swap.Long(dis.readInt());
        this.frameHeader.imageFormat = Swap.Long(dis.readInt());
        this.frameHeader.frameNumber = IMAGE.UnsignedInt(Swap.Long(dis.readInt()));
        this.frameHeader.eventNumber = IMAGE.UnsignedInt(Swap.Long(dis.readInt()));
        byte[] b = new byte[4];
        dis.read(b, 0, 4);
        this.frameHeader.xScale = Swap.Float(b);
        dis.read(b, 0, 4);
        this.frameHeader.yScale = Swap.Float(b);
        dis.read(b, 0, 4);
        this.frameHeader.imageRotation = Swap.Float(b);
        dis.read(b, 0, 4);
        this.frameHeader.fspare1 = Swap.Float(b);
        dis.read(b, 0, 4);
        this.frameHeader.fspare2 = Swap.Float(b);
        dis.read(b, 0, 4);
        this.frameHeader.fspare3 = Swap.Float(b);
        this.frameHeader.imageFlags = Swap.Long(dis.readInt());
        this.frameHeader.ispare1 = Swap.Long(dis.readInt());
        this.frameHeader.ispare2 = Swap.Long(dis.readInt());
        this.frameHeader.ispare3 = Swap.Long(dis.readInt());
        this.frameHeader.appendedFrameSize = Swap.Long(dis.readInt());
    }

    private void writeImageFrameHeader(DataOutputStream ds) throws IOException {
        ds.writeInt(Swap.Long(this.frameHeader.sourceWidth));
        ds.writeInt(Swap.Long(this.frameHeader.sourceHeight));
        ds.writeInt(Swap.Long(this.frameHeader.aoiWidth));
        ds.writeInt(Swap.Long(this.frameHeader.aoiHeight));
        ds.writeInt(Swap.Long(this.frameHeader.xStart));
        ds.writeInt(Swap.Long(this.frameHeader.yStart));
        ds.writeInt(Swap.Long(this.frameHeader.bytesPerPixel));
        ds.writeInt(Swap.Long(this.frameHeader.effectiveBitsPerPixel));
        ds.writeInt(Swap.Long(this.frameHeader.horizontalBinning));
        ds.writeInt(Swap.Long(this.frameHeader.verticalBinning));
        ds.writeInt(Swap.Long(this.frameHeader.sourceFormat));
        ds.writeInt(Swap.Long(this.frameHeader.imageFormat));
        ds.writeInt(Swap.Long(this.frameHeader.frameNumber));
        ds.writeInt(Swap.Long(this.frameHeader.eventNumber));
        ds.write(Swap.Float(this.frameHeader.xScale));
        ds.write(Swap.Float(this.frameHeader.yScale));
        ds.write(Swap.Float(this.frameHeader.imageRotation));
        ds.write(Swap.Float(this.frameHeader.fspare1));
        ds.write(Swap.Float(this.frameHeader.fspare2));
        ds.write(Swap.Float(this.frameHeader.fspare3));
        ds.writeInt(Swap.Long(this.frameHeader.imageFlags));
        ds.writeInt(Swap.Long(this.frameHeader.ispare1));
        ds.writeInt(Swap.Long(this.frameHeader.ispare2));
        ds.writeInt(Swap.Long(this.frameHeader.ispare3));
        ds.writeInt(Swap.Long(this.frameHeader.appendedFrameSize));
    }

    public FrameHeader getFrameHeader() {
        return this.frameHeader;
    }

    public SourceHeader getSourceHeader() {
        return this.sourceHeader;
    }

    public byte[] toByteArray() {
        try {
            int thisSizeInBytes = TFormat.getFormatHeaderSize((short)55);
            int frameSizeInBytes = this.imageFrame.length;
            this.dBuffer = new ByteArrayOutputStream(thisSizeInBytes += frameSizeInBytes);
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            this.writeImageSourceHeader(ds);
            this.writeImageFrameHeader(ds);
            if (this.imageFrame != null) {
                ds.write(this.imageFrame, 0, frameSizeInBytes);
            }
            ds.close();
            return this.dBuffer.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void toStruct() {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.hHeaderByteArray);
            DataInputStream dis = new DataInputStream(bais);
            this.readImageSourceHeader(dis);
            this.readImageFrameHeader(dis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] getByteArray() {
        return this.hHeaderByteArray;
    }

    public void setByteArray(byte[] byteArray) {
        this.hHeaderByteArray = byteArray;
    }

    public short getFormat() {
        return 55;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public int getIntegerValue() {
        return 0;
    }

    public class FrameHeader {
        public int sourceWidth;
        public int sourceHeight;
        public int aoiWidth;
        public int aoiHeight;
        public int xStart;
        public int yStart;
        public int bytesPerPixel;
        public int effectiveBitsPerPixel;
        public int horizontalBinning;
        public int verticalBinning;
        public int sourceFormat;
        public int imageFormat;
        public long frameNumber;
        public long eventNumber;
        public float xScale;
        public float yScale;
        public float imageRotation;
        public float fspare1;
        public float fspare2;
        public float fspare3;
        public int imageFlags;
        public int ispare1;
        public int ispare2;
        public int ispare3;
        public int appendedFrameSize;
    }

    public class SourceHeader {
        public int baseTag;
        public long cameraPortId;
        public long versionTag;
        public long totalLength;
        public int timestampSeconds;
        public int timestampMicroseconds;
        public String cameraPortName = "unknown";

        public void setTotalLength(int lengthInBytes) {
            this.totalLength = lengthInBytes;
        }

        public void setTotalLength(long lengthInBytes) {
            this.totalLength = lengthInBytes;
        }

        public void setTimeStamp(long time) {
            this.timestampSeconds = (int)(time / 1000L);
            this.timestampMicroseconds = (int)(time % 1000L * 1000L);
        }

        public void setStaticValues(int baseId, int specId, int version, String cameraPort) {
            this.baseTag = baseId;
            this.cameraPortId = specId;
            this.versionTag = version;
            this.cameraPortName = cameraPort;
        }

        public void setStaticValues(int baseId, long specId, long version, String cameraPort) {
            this.baseTag = baseId;
            this.cameraPortId = specId;
            this.versionTag = version;
            this.cameraPortName = cameraPort;
        }

        public String toString() {
            String s = new String("ha !");
            return s;
        }
    }
}

